/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class SpawnConfig {
    @Config.Comment(value={"Parasites can't spawn from spawners in base SRP. This fixes it. Reintroduced after moving it to RLMixins"})
    @Config.Name(value="Fix Spawner Block spawning")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.spawnerspawnfix.json", defaultValue=true)
    public boolean fixSpawnerSpawns = true;
    @Config.Comment(value={"Blacklist of biomes and dimensions in which no parasites will spawn. \nThis works only for phases on + custom spawner on, except if \"Fix Spawning Entirely\" is enabled, in which case it always works.\nPattern: dimensionId, modid:biomename \nDisable full mods with dimid, modid \nDisable full dimensions with dimid, no biomes for that dimension in any line\nFor example: \n0, minecraft:mutated_forest\n3, biomesoplenty\n-1"})
    @Config.Name(value="Parasite Spawning Biome Blacklist per dimension")
    public String[] biomeBlacklist = new String[0];
    @Config.Comment(value={"Use Biome Blacklist as Whitelist"})
    @Config.Name(value="Parasite Spawning Biome Blacklist per dimension is whitelist")
    public boolean biomeBlacklistIsWhitelist = false;
    @Config.Comment(value={"SRP does summoning via a max point system. Both don't really work and especially don't get saved/read to NBT so just unloading/reloading a parasite will clear its summon list. This does it correctly.\nPattern: paraname, maxSummonPoints\nSet either to -1 to ignore points.\nClear the list to disable this overhaul (requires restart)."})
    @Config.Name(value="Summoning Overhaul - Max Summon Points")
    public String[] summoningOverhaul = new String[]{"pri_summoner, 4", "ada_summoner, 6", "beckon_si, 4", "beckon_sii, 9", "beckon_siii, 12", "beckon_siv, 12", "dispatcher_si, 3", "dispatcher_sii, 5", "dispatcher_siii, 7", "dispatcher_siv, 9", "bomber_light, 3", "grunt, 3", "monarch, 3", "overseer, 6", "vigilante, 3", "warden, 3", "marauder, 3", "bomber_heavy, 3", "wraith, 3", "bogle, 3", "haunter, 3", "carrier_colony, 3", "architect, 6"};
    @Config.Comment(value={"SRP disables certain parasites until a colony is created. This also happens though if colonies aren't even activated, fully locking away certain parasites (preeminents by default). This makes SRP ignore the colony lock if colonies are disabled.\nWARNING: SRP has preeminents in the default phase spawning lists for phase 3 and beyond. If you enable this fix, you will need to change your SRP defaults. Preeminents should only spawn in parasite biomes and/or late phases like 9/10."})
    @Config.Name(value="Fix Colony Lock - requires SRP config change")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.cololockfix.json", defaultValue=false)
    public boolean fixColonyLock = false;
    @Config.Comment(value={"SRP allows to disable certain parasites until a certain phase in a certain dimension is reached. This also happens though if phases aren't even activated, fully locking away certain parasites. This makes SRP ignore the evolution lock if evolution is disabled."})
    @Config.Name(value="Fix Evolution Lock")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.evolockfix.json", defaultValue=true)
    public boolean fixEvolutionLock = true;
    @Config.Comment(value={"If custom phase spawner is disabled, SRP checks for min and max type id of parasites per phase to spawn them. Different than with the custom spawner though, it also checks those ids for parasite biome spawns, which can make parasite biomes feel very empty. This makes the parasite biome ignore the min and max id and instead just spawn its config-set parasites no matter the phase."})
    @Config.Name(value="Fix Parasite Biome Spawns")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.parabiomespawns.json", defaultValue=true)
    public boolean fixBiomeSpawnsNoCustom = true;
    @Config.Comment(value={"Colony Carrier has type id 31, making it equal to primitive mobs for phases enabled but custom phase spawner disabled. This will fix it to have a type id of 63, making it equal to other ground preeminents, making it spawn in phases 8-10 by default."})
    @Config.Name(value="Fix Colony Carrier Type Id")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.colocarriertypefix.json", defaultValue=true)
    public boolean fixColonyCarrierTypeId = true;
    @Config.Comment(value={"Auto fill the conversion rules with existing conversion pathways when they happen. Will be updated on logout."})
    @Config.Name(value="Conversion Phase Lock Rules - Auto fill")
    public boolean autoFillConversionRules = false;
    @Config.Comment(value={"A lot of parasites evolve into each other. Use this list to stop specific evolution pathways until a specific phase is reached. Pattern: paraIn, paraOut, minPhase\nNote: this also works for COTH conversions (assim/feral/hijack/incomplete forms), use modid:mobname in that case. For SRP mobs you don't need to note the modid.\nSpecial case: for incomplete forms use incompleteform without _small or _medium."})
    @Config.Name(value="Conversion Phase Lock Rules")
    public String[] conversionRules = new String[0];
    @Config.Comment(value={"In situations where parasite spawns should ignore light levels, they are still prevented by blocklight (torches and other light sources).\nThese situations are:\n\t- when the phase is above the \"Phase Parasites Ignore Sunlight\"\n\t- when inside a parasite biome\n\t- or if \"Mobs Ignore Sun\" option is true (and evo phases off)\nThis config varies that behavior:\n--- Parasites will only spawn if the blocklight is lower or equal to the given value. ---\nExamples: Set to 16 to make light sources not affect spawning at all.\nOr set to 0 to prevent any spawning if there is any blocklight on a block.\nDefault value of 7 is how SRP handles it.\nNOTE: this config replaces the old RLMixins \"Parasite Light Level (SRParasites)\" mixin toggle (enabled = set to 16)"})
    @Config.Name(value="Min Blocklight Threshold")
    @Config.RequiresMcRestart
    @Config.RangeInt(min=0, max=16)
    public int blockLightThresholdTwo = 7;
    @Config.Comment(value={"Fully overhauls the SRP spawning system.\nSRP spawns parasites just to cancel the spawns right afterwards in various situations.\nThis slows down hostile mob spawning and takes up performance for no reason, even in dimensions where parasites aren't even allowed to spawn.\nIt also does mob cap counts for every single spawn instead of doing what vanilla does and doing a mob cap check for every spawn attempt (which can include multiple spawn packs).\nIt's also just very hard to read and includes various oversights due to being so spread out throughout the SRP code.\nThis fix puts the whole spawning logic into one place, auto fixes some bugs and fixes the aforementioned issues.\nAutomatically includes the following fixes (and probably others i haven't even spotted):\n\t- \"Fix Parasite Biome Spawns\"\n\t- \"Fix Colony Lock in Para Biome\"\n\t- Auto fixes Quark Soul Beads being effectively incompat with SRP\nNerd info: This is done by adding a whole new spawning group PARASITE on top of the existing HOSTILE, PASSIVE, AMBIENT and WATER_CREATURE spawning groups, \nand modifying the potentialSpawnEvent instead of the checkSpawnEvent."})
    @Config.Name(value="Fix Spawning Entirely")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.srpmixins.vanilla.enumcreaturetype.json", lateMixin="mixins.srpmixins.srp.fixspawning.json", defaultValue=true)
    public boolean fixSpawningEntirely = true;
    @Config.Comment(value={"If SRParasitesWorld.cfg \"Colony Parasite Values Biome\" is enabled, spawns in Parasite Biome would NEVER allow colony-locked parasites (default: preeminents) no matter how many colonies have been established in the world.\nThis fix makes it then use the actual colony point requirements set in SRParasitesWorld.cfg \"Colony Parasite Values\" instead."})
    @Config.Name(value="Fix Colony Lock in Para Biome")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.colofixinbiome.json", defaultValue=true)
    public boolean fixColoLockInParaBiome = true;
}

