/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class ParaBiomeConfig {
    @Config.Comment(value={"Fully overhauls the parasite biome spread logic to make it more performant. If there are other mods that use mixins with the biome spread system, there will be incompatibilities.\nIncludes a fix for ore blocks turning into Pestilent Ore Blocks.\nIncompatible with Cotesia Glomerata"})
    @Config.Name(value="Biome Spread Performance Overhaul")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.biomespreadoverhaul.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="srpcotesia", desired=false, reason="Disable \"Biome Spread Performance Overhaul\"!", warnIngame=false)
    public boolean biomeSpreadOverhaul = true;
    @Config.Comment(value={"SRParasites.cfg has two options for para biome spreading speed (cooldown+block limit), but those don't get applied. Set to true to fix that"})
    @Config.Name(value="Fix Parasitic Biome spreading limit")
    public boolean fixBiomeSpreadingLimit = true;
    @Config.Comment(value={"SRP keeps a single fog density value for all players at the same time. In Multiplayer this leads to desyncs with no fog appearing inside the biome, or fog appearing outside of the biome. This fixes it."})
    @Config.Name(value="Fix Parasitic Biome Fog")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.fogmultiplayerfix.json", defaultValue=true)
    public boolean fixBiomeFog = true;
    @Config.Comment(value={"Parasite Bush and Vines will force load chunks when a parasite biome is growing. This stops the force loading. Moved from RLMixins (thanks fonny!)"})
    @Config.Name(value="Fix Parasite Bush Generation Lag")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.parasitebushgen.json", defaultValue=true)
    public boolean fixBiomeBushLag = true;
    @Config.Comment(value={"SRP sends a new network packet for every individual block position that gets turned into parasitic biome or back to plains. This fix sends one bigger packet instead, for performance."})
    @Config.Name(value="Fix SRP Biome Packet")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.biomepacket.json", defaultValue=true)
    public boolean fixBiomePacket = true;
    @Config.Comment(value={"Makes some values of the Biome Purifier tweakable (see configs here) and makes it more performant.\nIncluded fixes without a toggle:\n\t- Applies potion effects (glowing/rage) in the whole chunk column (down to bedrock) instead of just in 32 blocks cube distance\n\t- Reverts infestation on block place instead of on random tick\n\t- Applies potion effects on block interact instead of on random tick"})
    @Config.Name(value="Biome Purifier - Tweak+Fix")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.biomepurifier.json", defaultValue=true)
    public boolean fixBiomePurifier = true;
    @Config.Comment(value={"How many blocks away the biome purifier will clean up infested (not parasite biome!) blocks when placed."})
    @Config.Name(value="Biome Purifier - Infestation Reversion Range")
    @Config.RangeInt(min=0)
    public int biomePurifReversionRange = 5;
    @Config.Comment(value={"Base SRP Biome Purifier only applies glowing to the first found Nexus parasite, this fix applies it to all of them"})
    @Config.Name(value="Biome Purifier - Apply Glowing To All")
    public boolean biomePurifApplyGlowingToAll = true;
    @Config.Comment(value={"How many ticks a Nexus mob will have Glowing for after being affected by a biome purifier"})
    @Config.Name(value="Biome Purifier - Glowing Duration")
    @Config.RangeInt(min=0)
    public int biomePurifGlowingDuration = 1200;
    @Config.Comment(value={"How many ticks parasites in range will have Rage II for after being affected by a biome purifier"})
    @Config.Name(value="Biome Purifier - Rage Duration")
    @Config.RangeInt(min=0)
    public int biomePurifRageDuration = 1200;
    @Config.Comment(value={"How many chunks(!) away entities are affected (glowing/rage) by the biome purifier."})
    @Config.Name(value="Biome Purifier - Effect range")
    @Config.RangeInt(min=0)
    public int biomePurifPotionRange = 2;
    @Config.Comment(value={"How often (in ticks) the server checks whether nodes/colonies have been removed (default: 24000). Set to -1 to disable the mixin."})
    @Config.Name(value="Node/Colony Removal Check Frequency")
    @Config.RangeInt(min=-1)
    public int nodeColonyResetCheckFrequency = 200;
}

