/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class ModCompatConfig {
    @Config.Comment(value={"Set to false to disable all bloodmoon related tweaks"})
    @Config.Name(value="Enable Bloodmoon tweaks")
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.bloodmoon.json", defaultValue=false)
    @MixinConfig.CompatHandlingContainer(value={@MixinConfig.CompatHandling(modid="bloodmoon", desired=true, reason="Mod Compat for Bloodmoon, requires Bloodmoon", warnIngame=false), @MixinConfig.CompatHandling(modid="lostcities", desired=true, reason="Mod Compat for Lost Cities, requires Lost Cities", warnIngame=false)})
    @Config.RequiresMcRestart
    public boolean enableBloodmoon = false;
    @Config.Comment(value={"Set to false to disable all lost cities related tweaks. This also disables the bloodmoon tweaks as they only work inside the lost cities"})
    @Config.Name(value="Enable Lost Cities tweaks")
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.lostcities.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="lostcities", desired=true, reason="Mod Compat for Lost Cities, requires Lost Cities", warnIngame=false)
    @Config.RequiresMcRestart
    public boolean enableLostCities = false;
    @Config.Comment(value={"Disable Lures in LC and instead spawn a Dispatcher Nidus"})
    @Config.Name(value="Lures disabled in LC")
    public boolean disableLuresInLC = true;
    @Config.Comment(value={"Blood moons happen in Lost Cities dimension (requires this mod on client to see red moon), with increased parasite mob cap"})
    @Config.Name(value="Do Blood Moons in LC")
    public boolean bloodmoonInLC = true;
    @Config.Comment(value={"Multiply Parasite Mob Cap by this much during Blood Moons (if using SRP custom spawner). \nDoesn't work if \"Fix Spawning Entirely\" is enabled, use \"Parasite Mob Cap Rules\" for that"})
    @Config.Name(value="Bloodmoon Parasite Cap Multiplier")
    @Config.RangeInt(min=0)
    public float bloodmoonInLCmobCapMultiplier = 4.0f;
    @Config.Comment(value={"LC Portals are locked until reaching this phase. Disable with -1"})
    @Config.Name(value="LC Portal Phase Lock")
    public int portalLClockedPhase = 6;
    @Config.Comment(value={"SRPMixins has compat with OverLast when using custom phases (player phases or chunk phases). \nUse this to toggle off the compatibility.\nIt is auto disabled anyway if you dont use custom phases or OverLast.\nWorks with both OverLast and OverLastLite (only HUD)"})
    @Config.Name(value="Enable OverLast custom phases")
    @Config.RequiresMcRestart
    public boolean enableOverLastCustomPhases = true;
    @Config.Comment(value={"Remove point display from overlast phase HUD for more immersion and uncertainty."})
    @Config.Name(value="OverLast HUD Without Points")
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.overlast.nopointsinhud.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="overlast", desired=true, reason="Mod Compat for OverLast, requires OverLast")
    @Config.RequiresMcRestart
    public boolean overlastHUDnoPoints = false;
    @Config.Comment(value={"Set to true to make \"Scape and Spartan: Parasites\" weapons with the Uncapped property ignore parasite damage caps.\nNOTE: This property works without SRPMixins as well, this just streamlines the handling a bit. \nI kinda thought it didn't work - without actually testing it..."})
    @Config.Name(value="Scape and Spartan: Parasites Compat - Ignore Dmg Cap")
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.swparasites.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="swparasites", desired=true, reason="Mod Compat for Scape and Spartan: Parasites, requires Scape and Spartan: Parasites", warnIngame=false)
    @Config.RequiresMcRestart
    public boolean enableSWParasitesCompat = true;
    @Config.Comment(value={"This allows using some additional rules in InControl specifically for SRP\nNew Rules: \"srp_minphase\", \"srp_maxphase\", \"srp_minnodes\", \"srp_maxnodes\", \"srp_mincolos\", \"srp_maxcolos\"\nAll rules take a single integer number as comparison and can be used in any incontrol json.\nNote: Nodes and Colonies are counted over all dimensions, thats just how SRP works"})
    @Config.Name(value="In Control Compat - Add Rules")
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.incontrol.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="incontrol", desired=true, reason="Mod Compat for In Control, requires In Control", warnIngame=false)
    @Config.RequiresMcRestart
    public boolean enableInControlCompat = true;
    @Config.Comment(value={"Renders custom tiles in the Antique Atlas for parasite biomes."})
    @Config.Name(value="Antique Atlas Compat - Render Biome Tile")
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.antiqueatlas.renderbiometile.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="antiqueatlas", desired=true, reason="Mod Compat for Antique Atlas, requires Antique Atlas", warnIngame=false)
    @Config.RequiresMcRestart
    public boolean enableAntiqueAtlasCompat = true;
    @Config.Comment(value={"Registers \"srparasites:phase\", \"srparasites:kills\" and \"srparasites:nodes\" value getters and more importantly  \"srpmixins:phase\", \"srpmixins:kills\" and \"srpmixins:nodes\" conditions for The Hordes mod.\nNote: i prefixed the conditions with srpmixins modid to not compete with Hordes unreleased SRP compat conditions srparasites:phase and srparasites:kills which work slightly differently and don't have srpmixins custom phase compat."})
    @Config.Name(value="Hordes Compat - Register Conditions & ValueGetters")
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.hordes.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="hordes", desired=true, reason="Mod Compat for The Hordes, requires The Hordes", warnIngame=false)
    @Config.RequiresMcRestart
    public boolean enableHordesCompat = true;
}

