/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class DeterrentConfig {
    @Config.Comment(value={"Custom Mob Cap for Nexus Parasites (Dispatcher+Beckon) using SRP Phase Custom Spawner. Nexus Parasites still count to the global SRP Mob Cap. Disable with -1, requires MC restart for full disable"})
    @Config.Name(value="Nexus Mob Cap")
    @Config.RangeInt(min=-1)
    public int nexusCap = 15;
    @Config.Comment(value={"Whitelist Deterrent and Nexus mobs to take dmg per second if world is in low evolution phase"})
    @Config.Name(value="Deterrents take damage from low phase whitelist ")
    public String[] whiteListedDeterrents = new String[]{"srparasites:kyphosis", "srparasites:sentry", "srparasites:seizer", "srparasites:dispatcherten", "srparasites:beckon_si", "srparasites:beckon_sii", "srparasites:beckon_siii", "srparasites:beckon_siv", "srparasites:dispatcher_si", "srparasites:dispatcher_sii", "srparasites:dispatcher_siii", "srparasites:dispatcher_siv"};
    @Config.Comment(value={"Set to true to use Deterrent taking dmg whitelist as blacklist"})
    @Config.Name(value="Deterrent whitelist is blacklist")
    public boolean blackListDeterrents = false;
    @Config.Comment(value={"Play respective sounds when Beckons or Dispatchers of higher stages naturally spawn"})
    @Config.Name(value="Play high stage Beckon+Dispatcher spawn sounds")
    @Config.RequiresMcRestart
    public boolean playsounds = true;
    @Config.Comment(value={"Deny Stage 3 Beckons growing up if a Stage 4 Beckon is already nearby (20 blocks distance)"})
    @Config.Name(value="Limit Stage 4 Beckons")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.beckonupgradedeny.json", defaultValue=true)
    public boolean limitStage4Beckons = true;
    @Config.Comment(value={"Fix beckons reverting all the infested blocks around them on stage increase if evolution is disabled.\nThis also fixes dying higher stage beckons reverting infested blocks (if evolution is disabled) ignoring the SRP config \"Reinforcement System Block Revert Stage\" value, which would only allow reversion if the infested blocks were made by beckons with stage lower or equal to the config value."})
    @Config.Name(value="Fix Infested Block Reversion")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.beckoninfestationfix.json", defaultValue=true)
    public boolean fixInfestedBlockReversion = true;
    @Config.Comment(value={"SRP only uses the Beckon Stage III Infestation Limits (in SRParasitesMobs.cfg) instead of limiting the infestation spread by beckon stage, essentially ignoring the stage I and stage II config values. This fixes it."})
    @Config.Name(value="Fix Block Infestation Limit")
    public boolean fixInfestedBlockLimit = true;
    @Config.Comment(value={"When Beckons stand inside infested grass, they will not be able to propagate their new stage (after upgrade) to the infested blocks around them, making some infestation mechanics not work properly in those cases. This fixes it."})
    @Config.Name(value="Fix Block Infestation Beckon Upgrade")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.aiblockinfestfix.json", defaultValue=true)
    public boolean fixKyphosisInfestation = true;
    @Config.Comment(value={"Beckon infested area grows a lot of infested grass in it. Increase this multiplier to make it more rare (default SRP is 1, default here is 8x rarer)."})
    @Config.Name(value="Infested Grass Rarity")
    @Config.RangeDouble(min=0.0)
    public float infestedGrassSpawnRateMultiplier = 8.0f;
    @Config.Comment(value={"Beckons infest blocks in a square shaped area. This makes the area circular instead, looks better."})
    @Config.Name(value="Circular Infestation Area")
    public boolean infestationAreaIsCircular = true;
    @Config.Comment(value={"If set to true, fully disables the infestation reversion mechanic where killing a Beckon above certain infested blocks with low enough internal \"stage\" they will turn back to various non-infested blocks."})
    @Config.Name(value="Disable Infestation Reversion")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.infestationreversiontoggle.json", defaultValue=false)
    public boolean infestationReversionToggle = false;
    @Config.Comment(value={"Fully overhauls the beckon infestation spread logic to make it more performant. If there are other mods that use mixins with the infestation system, there will be incompatibilities.\nSince there are also specific mixins into that logic from SRPMixins itself, you'll have to disable those.\n\t- Circular Infestation Area\n\t- Fix Block Infestation Limit\nIncompatible with Cotesia Glomerata"})
    @Config.Name(value="Infestation Performance Overhaul")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.infestationoverhaul.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="srpcotesia", desired=false, reason="Disable \"Infestation Performance Overhaul\"!", warnIngame=false)
    public boolean infestationOverhaul = true;
    @Config.Comment(value={"Will allow quenches to turn remain blocks to air on impact."})
    @Config.Name(value="Quenchs Remove Remains")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.quenchremovesremains.json", defaultValue=true)
    public boolean quenchRemovesRemains = true;
}

