/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class DamageFixConfig {
    @Config.Comment(value={"Set to false to disable all fixes for parasite damages"})
    @Config.Name(value="Damage Fix: Global switch")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.damagefix.json", defaultValue=true)
    public boolean doDamageFixes = true;
    @Config.Comment(value={"Ancient Overlord homing missile base damage. Will be increased by various multipliers (parasite specific, global, dimensionspecific)"})
    @Config.Name(value="Damage Fix: Overlord projectile base damage")
    @Config.RangeInt(min=0)
    public float overlordProjectileDamage = 50.0f;
    @Config.Comment(value={"Haunter homing missile base damage. Will be increased by various multipliers (parasite specific, global, dimensionspecific)"})
    @Config.Name(value="Damage Fix: Haunter projectile base damage")
    @Config.RangeInt(min=0)
    public float haunterProjectileDamage = 32.0f;
    @Config.Comment(value={"Ancient Dreadnaught melee aura base damage. Will be increased by various multipliers (parasite specific, global, dimensionspecific)"})
    @Config.Name(value="Damage Fix: Dreadnaught melee aura base damage")
    @Config.RangeInt(min=0)
    public float dreadnaughtMeleeDamage = 32.0f;
    @Config.Comment(value={"Bogle melee aura base damage. Will be increased by various multipliers (parasite specific, global, dimensionspecific)"})
    @Config.Name(value="Damage Fix: Bogle melee aura base damage")
    @Config.RangeInt(min=0)
    public float bogleMeleeDamage = 25.0f;
    @Config.Comment(value={"Wraith melee aura base damage. Will be increased by various multipliers (parasite specific, global, dimensionspecific)"})
    @Config.Name(value="Damage Fix: Wraith melee aura base damage")
    @Config.RangeInt(min=0)
    public float wraithMeleeDamage = 25.0f;
    @Config.Comment(value={"Makes Succors deal fixed damage instead of 2 times its creator's dmg"})
    @Config.Name(value="Fix Succor Damage")
    public boolean fixSuccorDamage = true;
    @Config.Comment(value={"How much damage Succors should deal (x6 in Hard mode with x4 multiplier)"})
    @Config.Name(value="Fix Succor Damage - Dealt damage")
    @Config.RangeInt(min=0)
    public float fixedSuccorDamage = 30.0f;
    @Config.Comment(value={"Makes Arachnida Pullballs have modifiable hit range sizes"})
    @Config.Name(value="Fix Arachnida Pull")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.arachnidapullballhit.json", defaultValue=true)
    public boolean changeArachnidaPull = true;
    @Config.Comment(value={"How big of an area to scan for impacts with entities for the primitive arachnidas pullball. The value is what is added on top of the actual sidelength of the projectiles bounding box, so 0 would be using only its own bounding box."})
    @Config.Name(value="Fix Arachnida Pull - Primitive Range")
    @Config.RangeDouble(min=0.0)
    public float primArachPullBallHit = 2.0f;
    @Config.Comment(value={"How big of an area to scan for impacts with entities for the adapted arachnidas pullball. The value is what is added on top of the actual sidelength of the projectiles bounding box, so 0 would be using only its own bounding box."})
    @Config.Name(value="Fix Arachnida Pull - Adapted Range")
    @Config.RangeInt(min=0)
    public float adaArachPullBallHit = 2.5f;
    @Config.Comment(value={"Green (virulent) parasites stack viral on entities when they are touching them. This config value limits this to once per x ticks. By default, SRP allows it every tick (config = 1). Set to -1 to disable.\nNote: this also applies to buglins stacking up COTH when touching them.\nNote: primitive mobs only apply viral for 2 seconds (40 ticks) so increasing this value too much will remove the stacking effect. All other mobs apply for 5 seconds (100 ticks)."})
    @Config.Name(value="Viral stack speed on touch")
    @Config.RangeInt(min=-1, max=100)
    @Config.RequiresMcRestart
    public int viralStackSpeedOnTouch = 10;
}

