/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class CothConfig {
    @Config.Comment(value={"Fixes the srpcothimmunity tag (basically counting coth lvls) getting incremented for coth immune mobs, making them not immune anymore"})
    @Config.Name(value="Fix srpcothimmunity tag")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.cothimmunityfix.json", defaultValue=true)
    public boolean fixSrpCothImmunity = true;
    @Config.Comment(value={"If setting SRP config min assimilations required to spawn for a specific parasite, setting it to 0 will still not auto allow that spawn. This fixes it."})
    @Config.Name(value="Fix Min Assimilations Zero")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.minassimilations.json", defaultValue=true)
    public boolean fixMinAssimilations = true;
    @Config.Comment(value={"SRP uses the min assimilation values of the corresponding assimilated mob to allow feral mobs to spawn naturally. Use this list to override that with custom values. Remove lines to use default assimilated values. Pattern: mob name, min feralisations"})
    @Config.Name(value="Min Feralisations")
    public String[] minFeralisations = new String[]{"fer_cow, 4", "fer_enderman, 9", "fer_horse, 3", "fer_human, 5", "fer_pig, 4", "fer_sheep, 3", "fer_villager, 6", "fer_wolf, 2", "fer_bear, 2"};
    @Config.Comment(value={"SRP has the min assimilation value for big spider be hardcoded at 0 which is fixed by SRPMixins \"Fix Min Assimilations Zero\" to actually mean 0. \nDue to this, sim big spiders actually spawn naturally from the phase spawn lists they are in. \nTo make them again only spawn from some beckon spawn lists - how it behaves (incorrectly?) in base SRP - the default value here is 1, which can only be reached if using wyrmsofnyrus (since no other mobs are assimilated to big spiders). \nTo have them spawn naturally as i think its intended to (why else would the be in the phase spawn lists?), set this value back to 0.\nFully disable this mixin with -1 (requires restart)."})
    @Config.Name(value="Sim Big Spider Min Assimilations")
    public int assimBigSpiderMinAssimilations = 1;
    @Config.Comment(value={"Feral Bears couldn't get created from assimilated ones upgrading or from gnats. This fixes it."})
    @Config.Name(value="Fix Feral Bear Creation")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.feraliseferbears.json", defaultValue=true)
    public boolean fixFeralBearCreation = true;
    @Config.Comment(value={"Fixes mobs not checking for visibility when trying to spread COTH onto other mobs that have camouflage.\nAlso fixes assimilated mobs never checking for visibility when infecting nearby mobs"})
    @Config.Name(value="Fix Infect Nearby Visibility")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.infectnearbyfix.json", defaultValue=true)
    public boolean fixInfectNearby = true;
    @Config.Comment(value={"When mobs convert due to COTH without a parasite attacking them, vanilla onDeath is not called for the entitiy. \nThis for example leads to dead pets not notifying their owner about their death in chat and mobs with inventories (donkeys etc) not dropping the contents of their inventories. \nThis fix calls onDeath and cancels the normal mob drops that would result in calling onDeath."})
    @Config.Name(value="Call OnDeath when converting")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.cothondeath.json", defaultValue=true)
    public boolean fixCothOnDeath = true;
    @Config.Comment(value={"Camouflage has a chance to protect against COTH (default: 70%). Since a lot of effects try to apply COTH every single tick, any chance to protect against COTH will fail in less than a second.\nThis fix makes Camouflage only check once whether it protects against COTH and then either protect or not protect for the entire duration.\nThis will also not apply Camouflage to mobs that already have COTH, which gives a small ability to check if a mob has low stage COTH (otherwise green particles)\nNOTE: Camouflage only protects against COTH from some sources, not from all of them. Those sources are\n- getting attacked by a parasite (except rupter)\n- standing on gore/remain\n- mobs & assimilated paras spreading COTH to nearby"})
    @Config.Name(value="Fix Camouflage")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.camouflagefix.json", defaultValue=true)
    public boolean fixCamouflage = true;
    @Config.Comment(value={"Assimilated mobs with a high enough killcount (SRP default config: 60) are supposed to turn into their feral forms, but this doesn't work in SRP. This fixes it.\nNote: this will still only rarely happen, as the more usual thing is the assimilated mob having enough killcount to melt with 3 other nearby Assimilateds to moving flesh."})
    @Config.Name(value="Fix Assim turn to Feral")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.simturntoferalfix.json", defaultValue=true)
    public boolean fixSimTurnToFeral = true;
}

