/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class ChunkPhaseConfig {
    @Config.Comment(value={"Do Evolution mechanic by chunk. World areas that are inhabited longer will have higher phases. Can't be used together with player phases."})
    @Config.Name(value="Use Chunk Phases")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.customphasemechanics.json", defaultValue=false)
    public boolean enabled = false;
    @Config.Comment(value={"If using chunk phases, how many regions around the current region should get updated when points or lure cooldown of a chunk change? It's a radius, so it will update a square of (2 x radius + 1)\u00b2 regions. Default 3, so 7x7 regions"})
    @Config.Name(value="Region update radius")
    @Config.RangeInt(min=0)
    public int regionUpdateRadius = 2;
    @Config.Comment(value={"If using chunk phases, set the starting phase per biome id. All unset biomes will use the dimension default set in SRPSystems.cfg. Pattern: biomeId, startPhase"})
    @Config.Name(value="Custom Biome Start Phases")
    public String[] biomeStartPhases = new String[]{"minecraft:mutated_forest, -2"};
    @Config.Comment(value={"If using chunk phases, use regular dimension-wide phases for these dimensions to save performance"})
    @Config.Name(value="Dimension blacklist")
    public int[] dimensionBlacklist = new int[]{-1, 1, 111};
    @Config.Comment(value={"If using chunk phases, turn the dimension blacklist for chunk phases into a whitelist"})
    @Config.Name(value="Dimension blacklist is whitelist")
    public boolean dimensionBlacklistIsWhitelist = false;
    @Config.Comment(value={"If using chunk phases, a chunk region that gets points will be a square of this many chunks squared.\nWARNING: never change this in an existing world, or you will lose your evolution progress"})
    @Config.Name(value="Chunk spacing")
    @Config.RequiresMcRestart
    @Config.RangeInt(min=1)
    public int chunkSpacing = 3;
}

