/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class AdaptationConfig {
    @Config.Comment(value={"Overhaul Living/Sentient Armor adaptation, making it more performant and fixing some issues.\nFixes that are included without a toggle: \n- When combining living+sentient gear, will use the point multiplier of each armor piece instead of using the last checked one."})
    @Config.Name(value="Overhaul Adaptation")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.srpmixins.vanilla.adaptationoverhaul.json", lateMixin="mixins.srpmixins.srp.adaptationoverhaul.json", defaultValue=true)
    public boolean overhaulAdaptation = true;
    @Config.Comment(value={"In SRP, adaptable Parasites will have a chance to fail adapting to a damage type if they got hit by inFire or onFire dmg maximum 10 ticks (half a second) before the current hit. \nThis means you would have to hit them during the iframe the fire tick creates to make them fail the adaptation. \nEnable this fix to instead make them have a chance to fail adaptation whenever they are burning (and not having fire resistance).\nWarning: this makes any burn inflicting method to deal with parasites about twice as useful against their adaptation"})
    @Config.Name(value="Fix Adaptation While Burning")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.adaptwhileburningfix.json", defaultValue=true)
    public boolean fixAdaptationWhileBurning = true;
    @Config.Comment(value={"If adapting during an attack with no immediate attacker entity, SRP adapts to \"\". This fixes that bug. Requires \"Overhaul Adaptation\"."})
    @Config.Name(value="Fix Null Adaptation")
    public boolean fixNullAdaptation = true;
    @Config.Comment(value={"If SRP doesn't find a blacklisted damage type for a mob/player in BlackList Mobs, it will also search the Blacklist Else list. This fixes that bug. Requires \"Overhaul Adaptation\"."})
    @Config.Name(value="Fix Blacklist Check")
    public boolean fixBlacklistCheck = true;
    @Config.Comment(value={"SRPConfig has a list \"Adaptation Bonus\" which isn't read properly and will crash if filled with entries. This fixes it."})
    @Config.Name(value="Fix Adaptation Bonus Config")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.adaptationbonusfix.json", defaultValue=true)
    public boolean fixAdaptationBonusList = true;
    @Config.Comment(value={"Adaptable parasites will adapt to the players mainhand weapon when hit by indirect dmgs (harming splash potions, arrows, modded indirect dmg sources). Enable this to make them adapt to the indirect dmg source instead (so magic, arrow etc). Moved from RLMixins (thanks Kotlin!)"})
    @Config.Name(value="Fix Adaptation to Indirect Damages")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.adapttoindirect.json", defaultValue=true)
    public boolean fixAdaptationToIndirect = true;
    @Config.Comment(value={"Wearing Living or Sentient Armor is supposed to apply the SRP config \"Mob Fire Damage Multiplier\" to any fire (inFire/onFire) dmg the player takes, as well as any dmg when the player is burning (isBurning). In those cases, adapting to the dmg is also supposed to fail. Fire dmg doing that didn't work in base SRP due to a bug. \nUse this list to modify how it works when \"Overhaul Adaptation\" is enabled. \nOriginally intended would be inFire, onFire, isBurning, actual SRP behavior is just isBurning. \nPossible additions would be lava, hotFloor and fireworks, or just fully disabling the feature by clearing the list."})
    @Config.Name(value="Fire Multiplier Dmg Types")
    public String[] fireMultiDmgTypes = new String[]{"isBurning"};
    @Config.Comment(value={"SRPMixins adds a recipe to reset adaptation on Living/Sentient Armor. This needs you to surround the armor with four of the named item. To disable the recipe, clear this config and restart the game.\nFor CraftTweaker users there is also a method to use for custom recipes, using srpmixins.StackHelper.removeAdaptation(IItemStack stack);"})
    @Config.Name(value="Adaptation Reset Item")
    public String adaptationResetItem = "contenttweaker:blood_tear";
    @Config.Comment(value={"Optional item in the corner spots of the crafting table for the adaptation reset recipe. Keep empty for air/empty"})
    @Config.Name(value="Adaptation Second Reset Item")
    public String adaptationResetItemTwo = "";
    @Config.Comment(value={"Overrides what damage types should be counted as what other damage types. Use NONE to not adapt to it."})
    @Config.Name(value="Adaptation Type Overrides")
    public String[] adaptationTypeOverrides = new String[]{"srparasites:homming, thrown"};
}

