/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import srpmixins.SRPMixins;
import srpmixins.config.SRPConfigProvider;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.providers.SRPMobConfigProvider;

public class SRPMixinsConfigProvider {
    public static final Map<Integer, Float> dimensionHealthMultipliers = new HashMap<Integer, Float>();
    public static final Map<Integer, Float> dimensionDmgMultipliers = new HashMap<Integer, Float>();
    public static final Map<Integer, Float> dimensionArmorMultipliers = new HashMap<Integer, Float>();
    public static final Map<Integer, Float> dimensionKBResMultipliers = new HashMap<Integer, Float>();
    public static final Map<Integer, Set<String>> biomeSpawningBlacklists = new HashMap<Integer, Set<String>>();
    public static float playerNeedlerMulti = 0.4f;
    public static List<Integer> whiteListedDeterrents;
    public static final Map<Integer, Integer> minFeralisations;
    public static final Map<String, Integer> foodBlacklist;
    public static final Map<String, Set<Integer>> blockBreakBlacklist;
    public static final Set<String> fireMultiDmgTypes;
    public static final Map<Integer, Integer> summonLimits;
    public static final Map<String, String> adaptationOverrides;

    public static void init() {
        SRPMixinsConfigProvider.setupBiomeBlacklistMap();
        SRPMixinsConfigProvider.setupPlayerNeedlerMulti();
        SRPMixinsConfigProvider.setupWhitelistedDeterrents();
        SRPMixinsConfigProvider.setupMinFeralisations();
        SRPMixinsConfigProvider.setupFoodBlacklist();
        SRPMixinsConfigProvider.setupBlockBreakBlacklist();
        SRPMixinsConfigProvider.setupFireMultiDmgTypes();
        SRPMixinsConfigProvider.setupSummonLimits();
        SRPMixinsConfigProvider.setupAdaptationOverrides();
    }

    public static void reset() {
        biomeSpawningBlacklists.clear();
        whiteListedDeterrents.clear();
        minFeralisations.clear();
        foodBlacklist.clear();
        blockBreakBlacklist.clear();
        fireMultiDmgTypes.clear();
        summonLimits.clear();
        adaptationOverrides.clear();
        SRPMixinsConfigProvider.init();
    }

    private static void setupAdaptationOverrides() {
        for (String s : SRPMixinsConfigHandler.adaptation.adaptationTypeOverrides) {
            String[] split = s.split(",");
            if (split.length != 2) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse adaptation override, expected two strings, got {}", (Object)s);
                continue;
            }
            adaptationOverrides.put(split[0].trim(), split[1].trim());
        }
    }

    private static void setupSummonLimits() {
        for (String s : SRPMixinsConfigHandler.spawns.summoningOverhaul) {
            String[] split = s.split(",");
            if (split.length != 2) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse summoning overhaul entry {}. Expected pattern: paraname, maxpoints", (Object)s);
                continue;
            }
            int paraId = SRPMobConfigProvider.mobNameToParaIdMap.getOrDefault(split[0].trim(), Integer.MAX_VALUE);
            if (paraId == Integer.MAX_VALUE) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse summoning overhaul entry {}. Given para name not found in registry", (Object)s);
                continue;
            }
            try {
                summonLimits.put(paraId, Integer.parseInt(split[1].trim()));
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse summoning overhaul entry {}. Expected integer for max points", (Object)s);
            }
        }
    }

    private static void setupFireMultiDmgTypes() {
        fireMultiDmgTypes.addAll(Arrays.asList(SRPMixinsConfigHandler.adaptation.fireMultiDmgTypes));
    }

    private static void setupBlockBreakBlacklist() {
        for (String s : SRPMixinsConfigHandler.various.blockBreakBlacklist) {
            String[] split = s.split(",");
            if (split.length < 2) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse block break blacklist entry {}. Expected pattern: modid:blockname, comma separated parasite mobname/group list", (Object)s);
                continue;
            }
            HashSet<Integer> listedParaIds = new HashSet<Integer>();
            for (int i = 1; i < split.length; ++i) {
                String entry = split[i].trim();
                if (SRPMobConfigProvider.mobNameToParaIdMap.containsKey(entry)) {
                    listedParaIds.add(SRPMobConfigProvider.mobNameToParaIdMap.get(entry));
                    continue;
                }
                if (!SRPMobConfigProvider.mobGroupToParaIdMap.containsKey(entry)) continue;
                listedParaIds.addAll((Collection)SRPMobConfigProvider.mobGroupToParaIdMap.get(entry));
            }
            blockBreakBlacklist.put(split[0].trim(), listedParaIds);
        }
    }

    private static void setupFoodBlacklist() {
        for (String s : SRPMixinsConfigHandler.various.foodBlacklist) {
            String[] split = s.split(",");
            if (split.length == 1) {
                foodBlacklist.put(split[0].trim(), -1);
                continue;
            }
            if (split.length == 2) {
                try {
                    foodBlacklist.put(split[0].trim(), Integer.parseInt(split[1].trim()));
                }
                catch (Exception e) {
                    SRPMixins.LOGGER.warn("SRPMixins unable to parse food blacklist entry {}. Metadata not a number", (Object)s);
                }
                continue;
            }
            SRPMixins.LOGGER.warn("SRPMixins unable to parse food blacklist entry {}. Expected pattern: modid:itemname, optional metadata", (Object)s);
        }
    }

    private static void setupMinFeralisations() {
        for (String s : SRPMixinsConfigHandler.coth.minFeralisations) {
            String[] split = s.split(",");
            if (split.length == 2) {
                String firstEntry = split[0].trim();
                int paraId = SRPMobConfigProvider.mobNameToParaIdMap.getOrDefault(firstEntry, -1);
                if (paraId == -1) {
                    try {
                        paraId = Integer.parseInt(firstEntry);
                    }
                    catch (Exception e) {
                        SRPMixins.LOGGER.warn("SRPMixins unable to parse Min Feralisation line {}. Mob name doesn't exist", (Object)s);
                        continue;
                    }
                }
                if (!SRPMobConfigProvider.mobGroupToParaIdMap.get("FERAL").contains(paraId)) {
                    SRPMixins.LOGGER.warn("SRPMixins unable to parse Min Feralisation line {}. Not a feral parasite", (Object)s);
                    continue;
                }
                try {
                    int count = Integer.parseInt(split[1].trim());
                    minFeralisations.put(paraId, count);
                }
                catch (Exception e) {
                    SRPMixins.LOGGER.warn("SRPMixins unable to parse Min Feralisation line {}. Count is not a number", (Object)s);
                }
                continue;
            }
            SRPMixins.LOGGER.warn("SRPMixins unable to parse Min Feralisation line. Expected pattern: int, int, found {}", (Object)s);
        }
    }

    private static void setupWhitelistedDeterrents() {
        whiteListedDeterrents = Arrays.stream(SRPMixinsConfigHandler.deterrents.whiteListedDeterrents).map(s -> SRPMobConfigProvider.mobNameToParaIdMap.get(s.replace("srparasites:", ""))).collect(Collectors.toList());
    }

    private static void setupPlayerNeedlerMulti() {
        playerNeedlerMulti = SRPMixinsConfigHandler.potions.playerNeedlerMulti;
        if (playerNeedlerMulti < 0.0f) {
            playerNeedlerMulti = SRPConfigSystems.needlerDamage;
        }
    }

    public static void setupBiomeBlacklistMap() {
        for (String line : SRPMixinsConfigHandler.spawns.biomeBlacklist) {
            String[] split = line.split(",");
            if (split.length < 1) continue;
            try {
                int dim = Integer.parseInt(split[0].trim());
                if (!biomeSpawningBlacklists.containsKey(dim)) {
                    biomeSpawningBlacklists.put(dim, new HashSet());
                }
                if (split.length < 2) continue;
                String biome = split[1].trim();
                biomeSpawningBlacklists.get(dim).add(biome);
            }
            catch (NumberFormatException e) {
                SRPMixins.LOGGER.warn("SRPMixins config could not parse biome blacklist line {}", (Object)line);
            }
        }
    }

    public static int getLurePhaseMultiplier(byte phase) {
        if (!SRPMixinsConfigHandler.lures.variableCarcassValues) {
            return 1;
        }
        if (SRPMixinsConfigHandler.lures.carcassPhaseMultis.length != SRPConfigProvider.getMaxPhase() + 1) {
            return 1;
        }
        if (phase < 0 || phase > SRPConfigProvider.getMaxPhase()) {
            return 1;
        }
        return SRPMixinsConfigHandler.lures.carcassPhaseMultis[phase];
    }

    static {
        minFeralisations = new HashMap<Integer, Integer>();
        foodBlacklist = new HashMap<String, Integer>();
        blockBreakBlacklist = new HashMap<String, Set<Integer>>();
        fireMultiDmgTypes = new HashSet<String>();
        summonLimits = new HashMap<Integer, Integer>();
        adaptationOverrides = new HashMap<String, String>();
    }
}

