/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config;

import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import srpmixins.SRPMixins;

public class EarlyConfigReader {
    private static File configFile = null;
    private static String configBooleanString = null;
    private static String configIntString = null;
    private static Map<String, Boolean> configArrayFilledMap = null;

    public static boolean getBoolean(String name, boolean defaultValue) {
        if (configFile == null) {
            configFile = new File("config", "srpmixins.cfg");
        }
        if (configBooleanString == null) {
            if (configFile.exists() && configFile.isFile()) {
                try (Stream<String> stream = Files.lines(configFile.toPath());){
                    configBooleanString = stream.filter(s -> s.trim().startsWith("B:")).collect(Collectors.joining());
                }
                catch (Exception e) {
                    SRPMixins.LOGGER.error("Failed to parse SRPMixins config: " + e);
                }
            } else {
                configBooleanString = "";
            }
        }
        if (configBooleanString.contains("B:\"" + name + "\"=")) {
            return configBooleanString.contains("B:\"" + name + "\"=true");
        }
        return defaultValue;
    }

    public static int getInt(String name, int defaultValue) {
        if (configFile == null) {
            configFile = new File("config", "srpmixins.cfg");
        }
        if (configIntString == null) {
            if (configFile.exists() && configFile.isFile()) {
                try (Stream<String> stream = Files.lines(configFile.toPath());){
                    configIntString = stream.filter(s -> s.trim().startsWith("I:")).collect(Collectors.joining());
                }
                catch (Exception ex) {
                    SRPMixins.LOGGER.error("Failed to parse SRPMixins config: " + ex);
                }
            } else {
                configIntString = "";
            }
        }
        if (configIntString.contains("I:\"" + name + "\"=")) {
            int index = configIntString.indexOf("I:\"" + name + "\"=");
            try {
                Matcher matcher = Pattern.compile("(\\d+)").matcher(configIntString.substring(index));
                matcher.find();
                return Integer.parseInt(matcher.group(1));
            }
            catch (Exception e) {
                SRPMixins.LOGGER.error("SRPMixins: Failed to parse int config " + name + ", " + e);
                return 0;
            }
        }
        return defaultValue;
    }

    public static boolean isArrayFilled(String name, boolean filledByDefault) {
        if (configFile == null) {
            configFile = new File("config", "srpmixins.cfg");
        }
        if (configArrayFilledMap == null) {
            configArrayFilledMap = new HashMap<String, Boolean>();
            if (configFile.exists() && configFile.isFile()) {
                try {
                    String allLines = Files.lines(configFile.toPath()).collect(Collectors.joining("\t"));
                    Matcher matcher = Pattern.compile("[SID]:\"([^\t]+)\" <([^>]*)>").matcher(allLines);
                    while (matcher.find()) {
                        configArrayFilledMap.put(matcher.group(1), !matcher.group(2).matches("\\s*"));
                    }
                }
                catch (Exception ex) {
                    SRPMixins.LOGGER.error("Failed to parse SRPMixins config: " + ex);
                }
            }
        }
        return configArrayFilledMap.getOrDefault(name, filledByDefault);
    }
}

