/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.compat.overlast;

import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import srpmixins.SRPMixinsPlugin;
import srpmixins.config.EarlyConfigReader;
import srpmixins.config.SRPMixinsConfigHandler;

public class OverLastCompat {
    public static OverLastVersion getOverLastVersion() {
        ModContainer overlastMod = (ModContainer)Loader.instance().getIndexedModList().get("overlast");
        if (overlastMod == null) {
            return OverLastVersion.NONE;
        }
        if (overlastMod.getVersion().matches("^0\\.0\\.\\d+$")) {
            return OverLastVersion.LITE;
        }
        return OverLastVersion.FULL;
    }

    public static boolean shouldEnqueueOverLastMixins(OverLastVersion versionCompare) {
        OverLastVersion version = OverLastCompat.getOverLastVersion();
        if (version != versionCompare) {
            return false;
        }
        boolean customPhases = SRPMixinsPlugin.areCustomPhasesEnabled();
        boolean overlastEnabled = EarlyConfigReader.getBoolean("Enable OverLast custom phases", SRPMixinsConfigHandler.modcompat.enableOverLastCustomPhases);
        return customPhases && overlastEnabled;
    }

    public static enum OverLastVersion {
        FULL,
        LITE,
        NONE;

    }
}

