/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.compat.hordes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.config.data.ComparableOperation;
import net.smileycorp.hordes.config.data.DataType;
import net.smileycorp.hordes.config.data.conditions.Condition;
import net.smileycorp.hordes.config.data.values.ValueGetter;
import srpmixins.compat.hordes.ParasiteKillGetter;

public class ParasiteKillsCondition
implements Condition {
    protected final ValueGetter<Integer> actualKills = new ParasiteKillGetter();
    protected final ComparableOperation operation;
    protected final ValueGetter<Integer> comparisonKills;

    private ParasiteKillsCondition(ComparableOperation operation, ValueGetter<Integer> value) {
        this.operation = operation;
        this.comparisonKills = value;
    }

    public boolean apply(World level, EntityLivingBase entity, EntityPlayerMP player, Random rand) {
        return this.operation.apply(this.actualKills.get(level, entity, player, rand), this.comparisonKills.get(level, entity, player, rand));
    }

    public static ParasiteKillsCondition deserialize(JsonElement json) {
        try {
            JsonObject obj = json.getAsJsonObject();
            ComparableOperation operation = ComparableOperation.of((String)obj.get("operation").getAsString());
            ValueGetter value = ValueGetter.readValue((DataType)DataType.INT, (JsonElement)obj.get("value"));
            return new ParasiteKillsCondition(operation, (ValueGetter<Integer>)value);
        }
        catch (Exception e) {
            HordesLogger.logError((Object)"Incorrect parameters for condition srpmixins:kills", (Exception)e);
            return null;
        }
    }
}

