/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.compat.crafttweaker;

import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import crafttweaker.annotations.ZenDoc;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import srpmixins.config.SRPConfigProvider;
import srpmixins.config.providers.SRPMobConfigProvider;
import srpmixins.util.customphasemechanics.SRPSaveDataInterface;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="srpmixins.SRPSaveData")
public class ISRPSaveData {
    SRPSaveData internal;
    int dim;

    private static World getOverworld() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_71218_a(0);
    }

    public ISRPSaveData(SRPSaveData internal, int dimension) {
        this.internal = internal;
        this.dim = dimension;
    }

    @ZenMethod(value="getForPlayer")
    @ZenDoc(value="Returns a phase/point/cooldown container for the provided IPlayer (only useful if player phases is enabled)")
    public static ISRPSaveData getForPlayer(IPlayer iPlayer) {
        EntityPlayer player = (EntityPlayer)iPlayer.getInternal();
        return new ISRPSaveData(SRPSaveDataInterface.get(player.field_70170_p, player, null), player.field_70170_p.field_73011_w.getDimension());
    }

    @ZenMethod(value="getForBlockPos")
    @ZenDoc(value="Returns a phase/point/cooldown container for the chunk in the provided world at the provided IBlockPos or nearest player to the provided IBlockPos (only useful if chunk phases or player phases are enabled)")
    public static ISRPSaveData getForBlockPos(IWorld iworld, IBlockPos pos) {
        World world = (World)iworld.getInternal();
        return new ISRPSaveData(SRPSaveDataInterface.get(world, null, (BlockPos)pos.getInternal()), world.field_73011_w.getDimension());
    }

    @ZenMethod(value="get")
    @ZenDoc(value="Returns a global phase/point/cooldown container for the provided world (only useful if player phases and chunk phases are disabled)")
    public static ISRPSaveData getGlobal(IWorld iworld) {
        World world = (World)iworld.getInternal();
        return new ISRPSaveData(SRPSaveData.get((World)world), world.field_73011_w.getDimension());
    }

    @ZenMethod(value="getPhase")
    @ZenGetter(value="phase")
    @ZenDoc(value="Returns the current evolution phase")
    public byte getPhase() {
        return this.internal.getEvolutionPhase(this.dim);
    }

    @ZenMethod(value="getPoints")
    @ZenGetter(value="points")
    @ZenDoc(value="Returns the current evolution points")
    public int getPoints() {
        return this.internal.getTotalKills(this.dim);
    }

    @ZenMethod(value="getCooldown")
    @ZenGetter(value="cooldown")
    @ZenDoc(value="Returns the current cooldown (in ticks)")
    public int getCooldown() {
        return this.internal.getCooldown(ISRPSaveData.getOverworld(), this.dim);
    }

    @ZenMethod(value="getCanLose")
    @ZenGetter(value="canLose")
    @ZenDoc(value="Returns whether the evolution points can be reduced (via carcasses for example). Note: Different than base SRP this is not inverted in meaning, so true means can reduce, false means can't reduce.")
    public boolean getCanLose() {
        return !this.internal.getCanLoss(this.dim);
    }

    @ZenMethod(value="getCanGain")
    @ZenGetter(value="canGain")
    @ZenDoc(value="Returns whether the evolution points can be increased.")
    public boolean getCanGain() {
        return this.internal.getCanGain(this.dim);
    }

    @ZenMethod(value="getAssimilationCount")
    @ZenDoc(value="Returns how often an assimilated/feral/hijacked parasite with the given parasite name (example: sim_human) has been created via assimilation, which is needed for some parasites to naturally spawn. Thresholds are defined in configs.")
    public int getAssimilationCount(String paraName) {
        return this.internal.getNumberIDDataSpawn(SRPMobConfigProvider.mobNameToParaIdMap.get(paraName).intValue());
    }

    @ZenMethod(value="isEvoLocked")
    @ZenDoc(value="Returns whether a parasite with the given parasite name (example: sim_dragone) is evolution locked. If it is locked, it cannot spawn naturally until it is unlocked. See SRParasitesSystems.cfg/\"Evolution Parasite Lock List\" for the base system. Parasites can also be locked/unlocked just using the provided methods here.")
    public boolean isEvoLocked(String paraName) {
        return this.internal.checkParasiteID(SRPMobConfigProvider.mobNameToParaIdMap.get(paraName).intValue());
    }

    @ZenMethod(value="setPhase")
    @ZenSetter(value="phase")
    @ZenDoc(value="Sets the evolution phase (params: phase)")
    public void setPhase(byte phase) {
        this.internal.setEvolutionPhase(this.dim, phase, true, ISRPSaveData.getOverworld(), true);
    }

    @ZenMethod(value="setPoints")
    @ZenSetter(value="points")
    @ZenDoc(value="Sets the evolution points (params: points)")
    public void setPoints(int points) {
        this.internal.setTotalKills(this.dim, points, false, ISRPSaveData.getOverworld(), true);
    }

    @ZenMethod(value="addPoints")
    @ZenDoc(value="Adds to the current evolution points (params: pointsToAdd)")
    public void addPoints(int points) {
        this.internal.setTotalKills(this.dim, points, true, ISRPSaveData.getOverworld(), true);
    }

    @ZenMethod(value="setCooldown")
    @ZenSetter(value="cooldown")
    @ZenDoc(value="Sets the cooldown in seconds (params: pointsToAdd)")
    public void setCooldown(int cooldown) {
        this.internal.setCooldown(cooldown, ISRPSaveData.getOverworld(), this.dim);
    }

    @ZenMethod(value="addCooldown")
    @ZenDoc(value="Adds seconds to the cooldown (params: cooldownToAdd)")
    public void addCooldown(int cooldown) {
        int currCooldown = this.internal.getCooldown(ISRPSaveData.getOverworld(), this.dim);
        this.internal.setCooldown(currCooldown + cooldown, ISRPSaveData.getOverworld(), this.dim);
    }

    @ZenMethod(value="setCanLose")
    @ZenSetter(value="canLose")
    @ZenDoc(value="Sets whether the SRPSaveData of the provided dimension can have its evolution points reduced (params: newCanLose). Note: Different than base SRP this is not inverted in meaning, so true means can reduce, false means can't reduce.")
    public void setCanLose(boolean newValue) {
        this.internal.setLoss(!newValue, this.dim);
    }

    @ZenMethod(value="setCanGain")
    @ZenSetter(value="canGain")
    @ZenDoc(value="Sets whether the SRPSaveData of the provided dimension can have its evolution points increased (params: newCanGain).")
    public void setCanGain(boolean newValue) {
        this.internal.setGaining(newValue, this.dim);
    }

    @ZenMethod(value="increaseAssimilationCount")
    @ZenDoc(value="Increases the assimilation count of the provided assimilated/feral/hijacked parasite name (example: sim_human) by one.")
    public void increaseAssimilationCount(String paraName) {
        this.internal.addNumberIDDataSpawn(SRPMobConfigProvider.mobNameToParaIdMap.get(paraName).intValue());
    }

    @ZenMethod(value="unlockEvoLockForParasite")
    @ZenDoc(value="Unlocks the evolution lock of the parasite with the provided parasite name (example: sim_dragone).")
    public void unlockEvoLockForParasite(String paraName) {
        this.internal.unlockParasite(SRPMobConfigProvider.mobNameToParaIdMap.get(paraName).intValue());
    }

    @ZenMethod(value="lockParasite")
    @ZenDoc(value="Puts the parasite with the provided parasite name (example: sim_dragone) on the evolution lock list, preventing it from naturally spawning. Note: as this is not using the SRP config defined mechanic, you will have to manually unlock the parasite under your own conditions in your CT script.")
    public void lockParasite(String paraName) {
        int paraId;
        ArrayList lockedList = this.internal.getLockedList();
        if (!lockedList.contains(paraId = SRPMobConfigProvider.mobNameToParaIdMap.get(paraName).intValue())) {
            lockedList.add(paraId);
        }
    }

    @ZenMethod(value="resetEvoLock")
    @ZenDoc(value="Resets the evolution lock list to the SRP config defined list (see SRParasitesSystems.cfg/\"Evolution Parasite Lock List\".")
    public void resetEvoLock() {
        this.internal.resetLock();
    }

    @ZenMethod(value="getPointThreshold")
    @ZenDoc(value="Returns how many points are required for the given phase")
    public static int getPointThreshold(byte phase) {
        return SRPConfigProvider.getPhaseMinPoints(phase);
    }
}

