/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.capability.chunkphases;

import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import srpmixins.capability.chunkphases.CapabilityEvoPointsHandler;
import srpmixins.capability.chunkphases.ICapabilityEvoPoints;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.providers.ChunkPhaseConfigProvider;

public class ChunkPhasesUtil {
    public static ChunkPos blockPosToRegionChunkPos(BlockPos pos) {
        int x = ChunkPhasesUtil.chunkPosToRegionChunkPos(pos.func_177958_n() >> 4);
        int z = ChunkPhasesUtil.chunkPosToRegionChunkPos(pos.func_177952_p() >> 4);
        return new ChunkPos(x, z);
    }

    private static int chunkPosToRegionChunkPos(int chunkCoord) {
        return Math.floorDiv(chunkCoord, ChunkPhaseConfigProvider.chunkPhasesSpacing) * ChunkPhaseConfigProvider.chunkPhasesSpacing + ChunkPhaseConfigProvider.chunkPhasesHalfSpacing;
    }

    public static BlockPos getRegionChunkCenterBlock(ChunkPos pos) {
        int x = pos.field_77276_a << 4;
        int z = pos.field_77275_b << 4;
        if (ChunkPhaseConfigProvider.chunkPhasesSpacingIsOdd) {
            x += 8;
            z += 8;
        }
        return new BlockPos(x, 63, z);
    }

    public static boolean chunkPosIsRegionCenter(ChunkPos pos) {
        int regionX = ChunkPhasesUtil.chunkPosToRegionChunkPos(pos.field_77276_a);
        int regionZ = ChunkPhasesUtil.chunkPosToRegionChunkPos(pos.field_77275_b);
        return pos.field_77276_a == regionX && pos.field_77275_b == regionZ;
    }

    public static SRPSaveData getDataForPosition(BlockPos blockPos, World world, SRPSaveData defaultData) {
        int dimension = world.field_73011_w.getDimension();
        boolean isInList = ChunkPhaseConfigProvider.chunkPhasesDimensionBlacklist.contains(dimension);
        if (isInList != SRPMixinsConfigHandler.chunkphases.dimensionBlacklistIsWhitelist) {
            return defaultData;
        }
        ChunkPos regionPos = ChunkPhasesUtil.blockPosToRegionChunkPos(blockPos);
        Chunk chunk = world.func_72863_F().func_186026_b(regionPos.field_77276_a, regionPos.field_77275_b);
        if (chunk == null) {
            return defaultData;
        }
        ICapabilityEvoPoints chunkCap = (ICapabilityEvoPoints)chunk.getCapability(CapabilityEvoPointsHandler.CAP_EVOPOINTS, null);
        if (chunkCap != null) {
            return (SRPSaveData)chunkCap;
        }
        return defaultData;
    }
}

