/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.capability.chunkphases;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import srpmixins.capability.chunkphases.CapabilityEvoPoints;
import srpmixins.capability.chunkphases.ChunkPhasesUtil;
import srpmixins.capability.chunkphases.ICapabilityEvoPoints;
import srpmixins.config.providers.ChunkPhaseConfigProvider;

public class CapabilityEvoPointsHandler {
    public static final ResourceLocation CAP_EVOPOINTS_KEY = new ResourceLocation("srpmixins", "evopoints");
    @CapabilityInject(value=ICapabilityEvoPoints.class)
    public static Capability<ICapabilityEvoPoints> CAP_EVOPOINTS;

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(ICapabilityEvoPoints.class, (Capability.IStorage)new Storage(), CapabilityEvoPoints::new);
    }

    public static class Storage
    implements Capability.IStorage<ICapabilityEvoPoints> {
        public NBTBase writeNBT(Capability<ICapabilityEvoPoints> capability, ICapabilityEvoPoints instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("evoPoints", instance.getEvoPoints());
            nbt.func_74768_a("evoPointsBuffer", instance.getEvoPointsBuffer());
            nbt.func_74774_a("evoPhase", instance.getEvoPhase());
            nbt.func_74772_a("cooldownUntil", instance.getCooldownUntil());
            return nbt;
        }

        public void readNBT(Capability<ICapabilityEvoPoints> capability, ICapabilityEvoPoints instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tags = (NBTTagCompound)nbt;
            instance.setEvoPointsFromNBT(tags.func_74762_e("evoPoints"));
            instance.setEvoPointsBufferFromNBT(tags.func_74762_e("evoPointsBuffer"));
            instance.setEvoPhaseFromNBT(tags.func_74771_c("evoPhase"));
            instance.setCooldownUntilFromNBT(tags.func_74763_f("cooldownUntil"));
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final ICapabilityEvoPoints instance;

        public Provider(Chunk chunk, byte startPhase) {
            this.instance = new CapabilityEvoPoints(chunk, startPhase);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAP_EVOPOINTS;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAP_EVOPOINTS ? CAP_EVOPOINTS.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAP_EVOPOINTS.writeNBT((Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAP_EVOPOINTS.readNBT((Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class AttachCapabilityHandler {
        @SubscribeEvent
        public static void onAttachChunkCapabilities(AttachCapabilitiesEvent<Chunk> event) {
            BlockPos regionCenter;
            ResourceLocation biomeId;
            Chunk chunk = (Chunk)event.getObject();
            World world = chunk.func_177412_p();
            if (world == null || world.field_72995_K) {
                return;
            }
            if (chunk.hasCapability(CAP_EVOPOINTS, null)) {
                return;
            }
            ChunkPos chunkPos = chunk.func_76632_l();
            if (!ChunkPhasesUtil.chunkPosIsRegionCenter(chunkPos)) {
                return;
            }
            byte startPhase = -9;
            if (!ChunkPhaseConfigProvider.biomeStartPhases.isEmpty() && (biomeId = chunk.func_177411_a(regionCenter = ChunkPhasesUtil.getRegionChunkCenterBlock(chunkPos), chunk.func_177412_p().field_73011_w.func_177499_m()).getRegistryName()) != null) {
                startPhase = ChunkPhaseConfigProvider.biomeStartPhases.getOrDefault(biomeId.toString(), (byte)-9);
            }
            event.addCapability(CAP_EVOPOINTS_KEY, (ICapabilityProvider)new Provider(chunk, startPhase));
        }
    }
}

