/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.capability.chunkphases;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import srpmixins.capability.chunkphases.CapabilityEvoPointsHandler;
import srpmixins.capability.chunkphases.ICapabilityEvoPoints;
import srpmixins.config.SRPConfigProvider;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.SRPMixinsConfigProvider;
import srpmixins.config.providers.ChunkPhaseConfigProvider;
import srpmixins.mixin.customphases.SRPSaveDataAccessor;

public class CapabilityEvoPoints
extends SRPSaveData
implements ICapabilityEvoPoints {
    private final Chunk chunk;
    private int evoPoints = 0;
    private int evoPointsBuffer = 0;
    private byte evoPhase = 0;
    private long cooldownUntil = 0L;
    private Integer currPhaseMin = null;
    private Integer nextPhaseMin = null;
    private static final int evoPointsBufferOverflow = SRPMixinsConfigProvider.getLurePhaseMultiplier((byte)0) * SRPConfigSystems.luredValueOneCool;
    private static boolean recursionStarted = false;

    private boolean isOutsideCurrRange(int points) {
        return this.currPhaseMin != null && points < this.currPhaseMin || this.nextPhaseMin != null && points >= this.nextPhaseMin;
    }

    public CapabilityEvoPoints() {
        this(null, -9);
    }

    public CapabilityEvoPoints(Chunk chunk, byte startPhase) {
        this.chunk = chunk;
        if (chunk != null) {
            this.createData(chunk.func_177412_p(), startPhase);
        }
    }

    public void updateNearby(Consumer<ICapabilityEvoPoints> chunkCapFunction) {
        if (recursionStarted) {
            return;
        }
        recursionStarted = true;
        int chunkRadius = SRPMixinsConfigHandler.chunkphases.regionUpdateRadius;
        int chunkSpacing = ChunkPhaseConfigProvider.chunkPhasesSpacing;
        for (int i = -chunkRadius; i <= chunkRadius; ++i) {
            for (int j = -chunkRadius; j <= chunkRadius; ++j) {
                ICapabilityEvoPoints nearbyCap;
                Chunk chunkNearby;
                if (i == 0 && j == 0 || (chunkNearby = this.chunk.func_177412_p().func_72863_F().func_186026_b(this.chunk.field_76635_g + i * chunkSpacing, this.chunk.field_76647_h + j * chunkSpacing)) == null || (nearbyCap = (ICapabilityEvoPoints)chunkNearby.getCapability(CapabilityEvoPointsHandler.CAP_EVOPOINTS, null)) == null) continue;
                chunkCapFunction.accept(nearbyCap);
            }
        }
        recursionStarted = false;
    }

    @Override
    public boolean addEvoPoints(int addedPoints, long currentTime, boolean canChangePhase) {
        if (addedPoints == 0) {
            return false;
        }
        if (this.evoPhase == -2) {
            return false;
        }
        if (!(addedPoints <= 0 && SRPMixinsConfigHandler.lures.fixCarcassDuringCooldown || this.getCooldownTicks(currentTime) <= 0)) {
            return false;
        }
        boolean bufferDidOverFlow = false;
        if (!recursionStarted) {
            this.evoPointsBuffer += addedPoints;
            boolean wouldChangePhase = this.isOutsideCurrRange(this.evoPoints + this.evoPointsBuffer);
            if (Math.abs(this.evoPointsBuffer) >= evoPointsBufferOverflow || wouldChangePhase) {
                this.evoPoints += this.evoPointsBuffer;
                addedPoints = this.evoPointsBuffer;
                bufferDidOverFlow = true;
            }
        } else {
            this.evoPoints += addedPoints;
        }
        if (recursionStarted || bufferDidOverFlow) {
            this.evoPoints = Math.min(this.evoPoints, SRPConfigSystems.phaseTenTotalPoints);
            if (this.evoPhase >= 0) {
                this.evoPoints = Math.max(this.evoPoints, 0);
                if (SRPMixinsConfigHandler.phasepoints.limitPointReduction && !canChangePhase && addedPoints < 0) {
                    this.evoPoints = Math.max(this.evoPoints, SRPConfigProvider.getPhaseMinPoints(this.evoPhase));
                }
            }
            if (canChangePhase && (addedPoints >= 0 || this.evoPhase > 0) && (addedPoints <= 0 || this.evoPhase < SRPConfigProvider.getMaxPhase()) && this.isOutsideCurrRange(this.evoPoints)) {
                byte newPhase = -1;
                for (byte phase = 0; phase <= SRPConfigProvider.getMaxPhase() && this.evoPoints >= SRPConfigProvider.getPhaseMinPoints(phase); phase = (byte)(phase + 1)) {
                    newPhase = (byte)(newPhase + 1);
                }
                if (this.evoPhase != newPhase) {
                    this.setEvoPhase(newPhase);
                }
            }
            if (bufferDidOverFlow) {
                this.updateNearby(c -> c.addEvoPoints(this.evoPointsBuffer, currentTime, canChangePhase));
                this.evoPointsBuffer = 0;
            }
        }
        return true;
    }

    @Override
    public void setEvoPhase(byte phase) {
        this.evoPhase = phase;
        this.currPhaseMin = SRPConfigProvider.getPhaseMinPoints(this.evoPhase);
        this.nextPhaseMin = SRPConfigProvider.getPhaseMinPoints((byte)(this.evoPhase + 1));
        if (this.evoPhase < 0) {
            this.currPhaseMin = null;
        }
        if (this.evoPhase == -2) {
            this.nextPhaseMin = null;
        }
        if (this.evoPhase == SRPConfigProvider.getMaxPhase()) {
            this.nextPhaseMin = SRPConfigSystems.phaseTenTotalPoints + 1;
        }
        int phaseCooldownSeconds = SRPConfigProvider.getPhaseCooldown(this.evoPhase);
        this.setCooldown(20 * phaseCooldownSeconds, this.chunk.func_177412_p().func_72820_D(), false);
        SRPSaveDataAccessor data = this.instanceAccessor();
        if (data == null) {
            data = (SRPSaveDataAccessor)SRPSaveData.get((World)this.chunk.func_177412_p());
        }
        data.invokeCheckForUnlock(this.evoPhase, this.chunk.func_177412_p().field_73011_w.getDimension(), this.chunk.func_177412_p());
    }

    @Override
    public void setCooldown(int cooldown, long currentTime, boolean doUpdateNearby) {
        this.cooldownUntil = currentTime + (long)cooldown;
        if (doUpdateNearby) {
            this.updateNearby(c -> c.addCooldownTicks(cooldown, currentTime));
        }
    }

    @Override
    public void addCooldownTicks(int cooldown, long currentTime) {
        if (cooldown <= 0) {
            return;
        }
        if (this.getCooldownTicks(currentTime) <= 0) {
            this.cooldownUntil = currentTime;
        }
        this.cooldownUntil += (long)cooldown;
    }

    @Override
    public int getCooldownTicks(long currentTime) {
        return (int)(this.cooldownUntil - currentTime);
    }

    @Override
    public void setPointsToPhaseStart() {
        this.evoPoints = SRPConfigProvider.getPhaseMinPoints(this.evoPhase);
    }

    @Override
    public void setEvoPointsFromNBT(int points) {
        this.evoPoints = points;
    }

    @Override
    public int getEvoPoints() {
        return this.evoPoints;
    }

    @Override
    public void setEvoPointsBufferFromNBT(int pointsBuffer) {
        this.evoPointsBuffer = pointsBuffer;
    }

    @Override
    public int getEvoPointsBuffer() {
        return this.evoPointsBuffer;
    }

    @Override
    public void setEvoPhaseFromNBT(byte phase) {
        this.evoPhase = phase;
    }

    @Override
    public byte getEvoPhase() {
        return this.evoPhase;
    }

    @Override
    public void setCooldownUntilFromNBT(long cooldownUntilWorldTime) {
        this.cooldownUntil = cooldownUntilWorldTime;
    }

    @Override
    public long getCooldownUntil() {
        return this.cooldownUntil;
    }

    private void createData(World world, byte startPhase) {
        int currentDim = world.field_73011_w.getDimension();
        int phase = -2;
        int points = -100;
        if (startPhase != -9) {
            phase = startPhase;
            if (startPhase >= 0) {
                points = SRPConfigProvider.getPhaseMinPoints(startPhase);
            }
        } else {
            List<Integer> dimensionStartSettings = SRPConfigProvider.evolutionStartPerDimension.get(currentDim);
            if (dimensionStartSettings != null) {
                phase = dimensionStartSettings.get(0);
                points = dimensionStartSettings.get(1);
            }
            if (phase == -1 && points > 0) {
                points = -points;
            }
        }
        this.setEvolutionPhase(currentDim, (byte)phase, true, world, true);
        this.evoPoints = points;
    }

    public boolean setTotalKills(int dimId, int points, boolean isAddingNotSetting, World worldIn, boolean canChangePhase) {
        if (SRPConfigSystems.evolutionNoPlayerMultipler && worldIn.field_73010_i.isEmpty()) {
            return false;
        }
        if (isAddingNotSetting) {
            if (!this.getCanGain(dimId) && points > 0) {
                return false;
            }
            if (this.getCanLoss(dimId) && points < 0) {
                return false;
            }
            return this.addEvoPoints(points, worldIn.func_72820_D(), canChangePhase);
        }
        this.evoPoints = points;
        return true;
    }

    public int getTotalKills(int id) {
        return this.evoPoints + this.evoPointsBuffer;
    }

    public boolean setEvolutionPhase(int dimId, byte phase, boolean doRefreshPoints, World worldIn, boolean canChangePhase) {
        if (!canChangePhase) {
            this.setPointsToPhaseStart();
            return false;
        }
        this.setEvoPhase(phase);
        if (doRefreshPoints) {
            this.setPointsToPhaseStart();
        }
        return true;
    }

    public byte getEvolutionPhase(int id) {
        return this.evoPhase;
    }

    public void setCooldown(int cooldown, World worldIn, int dimId) {
        this.setCooldown(cooldown * 20, worldIn.func_72820_D(), true);
    }

    public int getCooldown(World worldIn, int dimId) {
        return Math.max(0, this.getCooldownTicks(worldIn.func_72820_D())) / 20;
    }

    private SRPSaveData instance() {
        return ((SRPSaveDataAccessor)((Object)this)).getInstance();
    }

    private SRPSaveDataAccessor instanceAccessor() {
        return (SRPSaveDataAccessor)this.instance();
    }

    private void markInstanceDirty() {
        this.instance().func_76185_a();
    }

    public boolean checkParasiteID(int parasiteId) {
        return this.getLockedList().contains(parasiteId);
    }

    public ArrayList<Integer> getLockedList() {
        return this.instanceAccessor().getLockedParasites();
    }

    public void resetLock() {
        this.getLockedList().clear();
        this.getLockedList().addAll(SRPConfigProvider.lockedParasites);
        this.markInstanceDirty();
    }

    public void setGaining(boolean canGain, int dimId) {
        int index = this.instanceAccessor().getDimEPid().indexOf(dimId);
        if (index != -1) {
            this.instanceAccessor().getDimEPcanGainPoints().set(index, canGain);
            this.markInstanceDirty();
        }
    }

    public boolean getCanGain(int id) {
        int index = this.instanceAccessor().getDimEPid().indexOf(id);
        if (index != -1) {
            return this.instanceAccessor().getDimEPcanGainPoints().get(index);
        }
        return false;
    }

    public void setLoss(boolean cantLose, int dimId) {
        int index = this.instanceAccessor().getDimEPid().indexOf(dimId);
        if (index != -1) {
            this.instanceAccessor().getDimEPcanLossPoints().set(index, cantLose);
            this.markInstanceDirty();
        }
    }

    public boolean getCanLoss(int id) {
        int index = this.instanceAccessor().getDimEPid().indexOf(id);
        if (index != -1) {
            return this.instanceAccessor().getDimEPcanLossPoints().get(index);
        }
        return false;
    }

    public int getNumberIDDataSpawn(int id) {
        int index = this.instanceAccessor().getSimRegId().indexOf((byte)id);
        if (index != -1) {
            return this.instanceAccessor().getSimRegIdTimes().get(index);
        }
        return SRPMixinsConfigHandler.coth.fixMinAssimilations ? 0 : -1;
    }

    public void addNumberIDDataSpawn(int id) {
        int index = this.instanceAccessor().getSimRegId().indexOf((byte)id);
        if (index != -1) {
            int currentValue = this.instanceAccessor().getSimRegIdTimes().get(index);
            this.instanceAccessor().getSimRegIdTimes().set(index, currentValue + 1);
        } else {
            this.instanceAccessor().getSimRegId().add((byte)id);
            this.instanceAccessor().getSimRegIdTimes().add(1);
        }
    }
}

