/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.capability.adaptation;

import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolArmorBase;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import srpmixins.SRPMixins;
import srpmixins.capability.adaptation.CapabilityAdaptation;
import srpmixins.capability.adaptation.ICapabilityAdaptation;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.SRPMixinsConfigProvider;

public class CapabilityAdaptationHandler {
    public static final ResourceLocation CAP_ADAPTATION_KEY = new ResourceLocation("srpmixins", "adaptation");
    @CapabilityInject(value=ICapabilityAdaptation.class)
    public static Capability<ICapabilityAdaptation> CAP_ADAPTATION;

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(ICapabilityAdaptation.class, (Capability.IStorage)new Storage(), CapabilityAdaptation::new);
    }

    public static class Storage
    implements Capability.IStorage<ICapabilityAdaptation> {
        public NBTBase writeNBT(Capability<ICapabilityAdaptation> capability, ICapabilityAdaptation instance, EnumFacing side) {
            return instance.writeToNBT();
        }

        public void readNBT(Capability<ICapabilityAdaptation> capability, ICapabilityAdaptation instance, EnumFacing side, NBTBase nbt) {
            instance.readFromNBT((NBTTagCompound)nbt);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final ICapabilityAdaptation instance;

        public Provider(ItemStack stack, List<String> oldNames, List<Integer> oldCounts) {
            this.instance = new CapabilityAdaptation(stack, oldNames, oldCounts);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAP_ADAPTATION;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAP_ADAPTATION ? CAP_ADAPTATION.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAP_ADAPTATION.writeNBT((Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAP_ADAPTATION.readNBT((Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
            NBTTagCompound nbt;
            ItemStack stack = (ItemStack)event.getObject();
            Item item = stack.func_77973_b();
            if (!(item instanceof WeaponToolArmorBase)) {
                return;
            }
            if (stack.func_77976_d() > 1 || stack.func_190916_E() != 1) {
                return;
            }
            if (!SRPMixins.completedLoading) {
                return;
            }
            if (stack.hasCapability(CAP_ADAPTATION, null)) {
                return;
            }
            ArrayList<String> oldNames = new ArrayList<String>();
            ArrayList<Integer> oldCounts = new ArrayList<Integer>();
            if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("sprresistances")) {
                NBTTagList allResS = nbt.func_150295_c("sprresistances", 10);
                NBTTagList allResI = nbt.func_150295_c("sprresistancei", 10);
                if (allResS.func_74745_c() > 0 && allResS.func_74745_c() == allResI.func_74745_c()) {
                    for (int i = 0; i < allResS.func_74745_c(); ++i) {
                        NBTTagCompound nameCmpnd = allResS.func_150305_b(i);
                        NBTTagCompound countCmpnd = allResI.func_150305_b(i);
                        String name = nameCmpnd.func_74779_i("resistance" + i);
                        int count = countCmpnd.func_74762_e("resistance" + i);
                        if (SRPMixinsConfigHandler.adaptation.fixNullAdaptation && name.isEmpty()) continue;
                        oldNames.add(name);
                        oldCounts.add(count);
                    }
                }
                nbt.func_82580_o("sprresistances");
                nbt.func_82580_o("sprresistancei");
                nbt.func_82580_o("sprresistanceb");
                stack.func_77982_d(nbt);
            }
            event.addCapability(CAP_ADAPTATION_KEY, (ICapabilityProvider)new Provider((ItemStack)event.getObject(), oldNames, oldCounts));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SubscribeEvent
        public static void onPlayerHurt(LivingHurtEvent event) {
            if (event.getSource() == null) {
                return;
            }
            if (!(event.getEntityLiving() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_71071_by.field_70460_b.stream().noneMatch(stack -> stack.func_77973_b() instanceof WeaponToolArmorBase)) {
                return;
            }
            float amount = event.getAmount();
            DamageSource source = event.getSource();
            Entity immediateSource = source.func_76364_f();
            if (SRPMixinsConfigProvider.fireMultiDmgTypes.contains(source.field_76373_n) || SRPMixinsConfigProvider.fireMultiDmgTypes.contains("isBurning") && player.func_70027_ad()) {
                event.setAmount(amount * SRPConfig.firemultyplier);
                return;
            }
            float reductionAmount = 0.0f;
            String damageTypeName = "";
            byte blackListType = 0;
            if (immediateSource != null || SRPMixinsConfigHandler.adaptation.fixNullAdaptation) {
                if (immediateSource instanceof EntityPlayer) {
                    damageTypeName = immediateSource.func_70005_c_();
                } else if (immediateSource instanceof EntityLivingBase) {
                    ResourceLocation loc = EntityList.func_191301_a((Entity)immediateSource);
                    if (loc == null) return;
                    damageTypeName = loc.toString();
                } else {
                    damageTypeName = source.field_76373_n;
                    blackListType = 2;
                }
            }
            if ((damageTypeName = SRPMixinsConfigProvider.adaptationOverrides.getOrDefault(damageTypeName, damageTypeName)).equals("NONE")) {
                return;
            }
            for (ItemStack stack2 : player.field_71071_by.field_70460_b) {
                ICapabilityAdaptation adaCap;
                if (!(stack2.func_77973_b() instanceof WeaponToolArmorBase) || (adaCap = (ICapabilityAdaptation)stack2.getCapability(CAP_ADAPTATION, null)) == null) continue;
                boolean hasAdaptation = adaCap.hasAdaptation(damageTypeName);
                if (!hasAdaptation) {
                    hasAdaptation = adaCap.tryAddAdaptation(damageTypeName, player.func_70681_au(), blackListType);
                }
                if (!hasAdaptation) continue;
                adaCap.tryIncreaseAdaptation(damageTypeName, player.func_70681_au());
                reductionAmount += adaCap.getReduction(damageTypeName);
            }
            event.setAmount(Math.max(amount * (1.0f - reductionAmount), 0.0f));
            if (!(immediateSource instanceof EntityLivingBase) || !SRPConfig.armorCoth) return;
            SRPPotions.applyStackPotion((Potion)SRPPotions.COTH_E, (EntityLivingBase)((EntityLivingBase)immediateSource), (int)400, (int)2);
        }
    }
}

