/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.capability.adaptation;

import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolArmorBase;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import srpmixins.capability.adaptation.ICapabilityAdaptation;
import srpmixins.config.SRPMixinsConfigHandler;

public class CapabilityAdaptation
implements ICapabilityAdaptation {
    private final Map<String, Integer> trackedTypes = new HashMap<String, Integer>();
    private byte isSentient;
    private NBTTagCompound cachedNBT = null;
    private static final int[] damageCaps = new int[]{SRPConfig.livingDamageCap, SRPConfig.sentientDamageCap};
    private static final int[] pointCaps = new int[]{SRPConfig.livingPointCap, SRPConfig.sentientPointCap};
    private static final float[] learnChances = new float[]{(float)SRPConfig.livingChanceLe, (float)SRPConfig.sentientChanceLe};
    private static final float[] reductionPerPoint = new float[]{SRPConfig.livingPointReduction, SRPConfig.sentientPointReduction};

    public CapabilityAdaptation() {
        this(ItemStack.field_190927_a, Collections.emptyList(), Collections.emptyList());
    }

    public CapabilityAdaptation(ItemStack stack, List<String> oldNames, List<Integer> oldCounts) {
        this.isSentient = !stack.func_190926_b() && stack.func_77973_b() instanceof WeaponToolArmorBase && ((WeaponToolArmorBase)stack.func_77973_b()).canCall() ? (byte)1 : 0;
        for (int i = 0; i < oldNames.size(); ++i) {
            this.addAdaptation(oldNames.get(i), oldCounts.get(i));
        }
    }

    @Override
    public int getTrackCount() {
        return this.trackedTypes.size();
    }

    @Override
    public boolean hasAdaptation(String damageTypeName) {
        return this.trackedTypes.containsKey(damageTypeName);
    }

    @Override
    public boolean tryAddAdaptation(String damageTypeName, Random rand, byte blacklistType) {
        if (this.trackedTypes.size() >= damageCaps[this.isSentient]) {
            return false;
        }
        if (rand.nextDouble() >= (double)learnChances[this.isSentient]) {
            return false;
        }
        if (CapabilityAdaptation.isBlacklisted(damageTypeName, blacklistType)) {
            return false;
        }
        this.addAdaptation(damageTypeName, 0);
        return true;
    }

    private void addAdaptation(String damageTypeName, int startCount) {
        this.trackedTypes.put(damageTypeName, startCount);
        this.invalidateCache();
    }

    @Override
    public float getReduction(String damageTypeName) {
        int dmgPointCap = pointCaps[this.isSentient];
        return reductionPerPoint[this.isSentient] * (float)Math.min(this.trackedTypes.get(damageTypeName), dmgPointCap);
    }

    @Override
    public void resetAdaptations() {
        this.trackedTypes.clear();
        this.invalidateCache();
    }

    @Override
    public void tryIncreaseAdaptation(String damageTypeName, Random rand) {
        if (rand.nextDouble() >= (double)learnChances[this.isSentient]) {
            return;
        }
        this.trackedTypes.put(damageTypeName, this.trackedTypes.get(damageTypeName) + 1);
        this.invalidateCache();
    }

    private static boolean isBlacklisted(String damage, byte type) {
        switch (type) {
            case 0: {
                if (ParasiteEventEntity.checkName((String)damage, (String[])SRPConfig.armorDamageTypeBlackListMob, (boolean)SRPConfig.armorDamageTypeBlackListWhite)) {
                    return true;
                }
                if (SRPMixinsConfigHandler.adaptation.fixBlacklistCheck) break;
            }
            case 2: {
                if (!ParasiteEventEntity.checkName((String)damage, (String[])SRPConfig.armorDamageTypeBlackListElse, (boolean)SRPConfig.armorDamageTypeBlackListWhite)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT() {
        if (this.cachedNBT == null) {
            this.cachedNBT = new NBTTagCompound();
            this.cachedNBT.func_74757_a("sent", this.isSentient == 1);
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, Integer> trackerEntry : this.trackedTypes.entrySet()) {
                NBTTagCompound entryTags = new NBTTagCompound();
                entryTags.func_74778_a("type", trackerEntry.getKey());
                entryTags.func_74768_a("count", trackerEntry.getValue().intValue());
                list.func_74742_a((NBTBase)entryTags);
            }
            this.cachedNBT.func_74782_a("list", (NBTBase)list);
        }
        return this.cachedNBT;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.isSentient = (byte)(nbt.func_74767_n("sent") ? 1 : 0);
        this.trackedTypes.clear();
        NBTTagList list = nbt.func_150295_c("list", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entryTags = list.func_150305_b(i);
            String dmgTypeName = entryTags.func_74779_i("type");
            int count = entryTags.func_74762_e("count");
            this.addAdaptation(dmgTypeName, count);
        }
    }

    private void invalidateCache() {
        this.cachedNBT = null;
    }

    @Override
    public List<String> getNames() {
        return new ArrayList<String>(this.trackedTypes.keySet());
    }

    @Override
    public List<Integer> getCounts() {
        return new ArrayList<Integer>(this.trackedTypes.values());
    }

    @Override
    public void copyAdaptationsFrom(ICapabilityAdaptation adaCap) {
        for (int i = 0; i < adaCap.getTrackCount(); ++i) {
            this.trackedTypes.put(adaCap.getNames().get(i), adaCap.getCounts().get(i));
        }
    }
}

