/*
 * Decompiled with CFR 0.152.
 */
package srpmixins;

import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSquid;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityLum;
import com.dhanantry.scapeandrunparasites.init.SRPItems;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import srpmixins.capability.adaptation.CapabilityAdaptationHandler;
import srpmixins.capability.chunkphases.CapabilityEvoPointsHandler;
import srpmixins.compat.AntiqueAtlasCompat;
import srpmixins.compat.CompatUtil;
import srpmixins.compat.LycanitesMobsCompat;
import srpmixins.compat.crafttweaker.CT_BlockInfestationEvent;
import srpmixins.compat.hordes.HordesCompat;
import srpmixins.config.SRPConfigProvider;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.SRPMixinsConfigProvider;
import srpmixins.config.providers.ChunkPhaseConfigProvider;
import srpmixins.config.providers.DimensionMultiConfigProvider;
import srpmixins.config.providers.LootPoolProvider;
import srpmixins.config.providers.MorePhasesConfigProvider;
import srpmixins.config.providers.SRPMobConfigProvider;
import srpmixins.handlers.CamouflageHandler;
import srpmixins.handlers.CothNoDropsOnConversion;
import srpmixins.handlers.NexusSpawnSounds;
import srpmixins.handlers.ParasiteDropChance;
import srpmixins.handlers.SRPArmorBowEvolutionHandler;
import srpmixins.handlers.SpawnPotentialsHandler;
import srpmixins.handlers.StatIncreaseRuleHandler;
import srpmixins.handlers.TendrilSyncHandler;
import srpmixins.handlers.WorldMobCapHandler;
import srpmixins.handlers.XpPerPhaseHandler;
import srpmixins.loot.SRPPhaseLootCondition;
import srpmixins.rules.ConversionPathways;
import srpmixins.rules.ruleset.DespawnTimerRuleSet;
import srpmixins.rules.ruleset.MinMaxDayPerPhaseRuleSet;
import srpmixins.rules.ruleset.MobCapRuleSet;
import srpmixins.rules.ruleset.StatIncreaseRuleSet;
import srpmixins.rules.ruleset.VariantDisableRuleSet;
import srpmixins.world.SRPWorldProvider;

@Mod(modid="srpmixins", version="2.9.2.2", name="SRPMixins", dependencies="required-after:fermiumbooter@[1.3.2,);required-after:srparasites", acceptableRemoteVersions="*")
public class SRPMixins {
    public static final String MODID = "srpmixins";
    public static final String VERSION = "2.9.2.2";
    public static final String NAME = "SRPMixins";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Configuration CONFIG;
    public static boolean completedLoading;

    public static void logInWorld(World world, String text) {
        world.field_73010_i.forEach(p -> p.func_145747_a((ITextComponent)new TextComponentString(text)));
        LOGGER.info("SRPMIXINS log: {}", (Object)text);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        CONFIG.load();
        SRPMobConfigProvider.registerMobs();
        SRPMixinsConfigProvider.init();
        ConversionPathways.init();
        MobCapRuleSet.INSTANCE = new MobCapRuleSet();
        MinMaxDayPerPhaseRuleSet.INSTANCE = new MinMaxDayPerPhaseRuleSet();
        VariantDisableRuleSet.INSTANCE = new VariantDisableRuleSet();
        DespawnTimerRuleSet.INSTANCE = new DespawnTimerRuleSet();
        StatIncreaseRuleSet.INSTANCE = new StatIncreaseRuleSet();
        ChunkPhaseConfigProvider.init();
        DimensionMultiConfigProvider.init();
        if (SRPMixinsConfigHandler.chunkphases.enabled && SRPConfigSystems.useEvolution) {
            CapabilityEvoPointsHandler.registerCapability();
            MinecraftForge.EVENT_BUS.register(CapabilityEvoPointsHandler.AttachCapabilityHandler.class);
        }
        if (SRPMixinsConfigHandler.adaptation.overhaulAdaptation) {
            CapabilityAdaptationHandler.registerCapability();
            MinecraftForge.EVENT_BUS.register(CapabilityAdaptationHandler.EventHandler.class);
        }
        SRPMixins.registerEventSubscriberIf(NexusSpawnSounds.class, SRPMixinsConfigHandler.deterrents.playsounds);
        SRPMixins.registerEventSubscriberIf(ParasiteDropChance.class, SRPMixinsConfigHandler.dimension.doMultipliers && SRPMixinsConfigHandler.dimension.dimensionDropMultipliers.length > 0);
        SRPMixins.registerEventSubscriberIf(CothNoDropsOnConversion.class, SRPMixinsConfigHandler.coth.fixCothOnDeath);
        SRPMixins.registerEventSubscriberIf(SRPArmorBowEvolutionHandler.class, SRPMixinsConfigHandler.weapons.addArmorBowEvolution);
        SRPMixins.registerEventSubscriberIf(ConversionPathways.class, SRPMixinsConfigHandler.spawns.autoFillConversionRules);
        SRPMixins.registerEventSubscriberIf(SpawnPotentialsHandler.class, SRPMixinsConfigHandler.spawns.fixSpawningEntirely);
        SRPMixins.registerEventSubscriberIf(WorldMobCapHandler.class, SRPMixinsConfigHandler.spawns.fixSpawningEntirely);
        SRPMixins.registerEventSubscriberIf(XpPerPhaseHandler.class, SRPMixinsConfigHandler.phasepoints.xpMultis.length > 0);
        SRPMixins.registerEventSubscriberIf(StatIncreaseRuleHandler.class, SRPMixinsConfigHandler.rules.statIncreaseRules.length > 0);
        SRPMixins.registerEventSubscriberIf(CamouflageHandler.class, SRPMixinsConfigHandler.coth.fixCamouflage);
        SRPMixins.registerEventSubscriberIf(TendrilSyncHandler.class, SRPMixinsConfigHandler.various.fixTendrilRegain);
        SRPMixins.registerEventSubscriberIf(CT_BlockInfestationEvent.CT_EventForwarder.class, Loader.isModLoaded((String)"crafttweaker"));
        LootConditionManager.func_186639_a((LootCondition.Serializer)new SRPPhaseLootCondition.Serializer());
        if (SRPMixinsConfigHandler.various.useLootTables) {
            LootPoolProvider.setupLootPoolFolders(event.getModConfigurationDirectory());
        }
    }

    private static void registerEventSubscriberIf(Object subscriber, boolean condition) {
        if (condition) {
            MinecraftForge.EVENT_BUS.register(subscriber);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        SRPConfigProvider.init();
        DimensionType.register((String)"The Source", (String)"_srpsource", (int)254, SRPWorldProvider.class, (boolean)false);
        DimensionManager.registerDimension((int)254, (DimensionType)DimensionType.func_186069_a((int)254));
        if (SRPMixinsConfigHandler.morephases.enableMorePhases && SRPMixinsConfigHandler.morephases.phaseKills.length == 0) {
            MorePhasesConfigProvider.initMorePhasesConfig();
        }
        if (SRPMixinsConfigHandler.mobConfig.enableMobConfig && SRPMixinsConfigHandler.mobConfig.mobConfig.length == 0) {
            SRPMobConfigProvider.initMobConfigs();
        }
        if (Loader.isModLoaded((String)"antiqueatlas") && SRPMixinsConfigHandler.modcompat.enableAntiqueAtlasCompat && event.getSide() == Side.CLIENT) {
            AntiqueAtlasCompat.initTiles();
        }
        if (Loader.isModLoaded((String)"hordes") && SRPMixinsConfigHandler.modcompat.enableHordesCompat) {
            HordesCompat.init();
        }
        if (SRPMixinsConfigHandler.weapons.repairableGear) {
            SRPItems.MATERIAL_LIVING.setRepairItem(new ItemStack(SRPItems.infblade));
            SRPItems.ARMOR_LIVING.setRepairItem(new ItemStack(SRPItems.vileshell));
            SRPItems.ARMOR_SENTIENT.setRepairItem(new ItemStack(SRPItems.vileshell));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (CompatUtil.lycanitesmobs.isLoaded()) {
            LycanitesMobsCompat.reloadLycaniteSpawnerManager();
        }
        SRPConfigProvider.postInit();
        if (SRPMixinsConfigHandler.various.useLootTables) {
            LootPoolProvider.getLootPoolsFromConfigOrFile();
        }
        MorePhasesConfigProvider.postInit();
        completedLoading = true;
        if (SRPMixinsConfigHandler.waterparas.enableWaterSpawns) {
            EntitySpawnPlacementRegistry.setPlacementType(EntityInfSquid.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
            EntitySpawnPlacementRegistry.setPlacementType(EntityLum.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        }
    }

    static {
        completedLoading = false;
    }
}

