/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.HorseManager;
import tschipp.callablehorses.common.capabilities.horseowner.HorseOwnerProvider;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.HorseProvider;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.config.CallableHorsesConfig;
import tschipp.callablehorses.common.helper.HorseHelper;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;

@Mod.EventBusSubscriber(modid="callablehorses")
public class EntityEvents {
    @SubscribeEvent
    public static void onAttachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("callablehorses", "horse_owner"), (ICapabilityProvider)new HorseOwnerProvider());
        }
        if (event.getObject() instanceof AbstractHorse) {
            event.addCapability(new ResourceLocation("callablehorses", "stored_horse"), (ICapabilityProvider)new HorseProvider());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            ClassInheritanceMultiMap[] entitylists;
            Chunk chk = event.getChunk();
            for (ClassInheritanceMultiMap list : entitylists = chk.func_177429_s()) {
                for (Entity e : list) {
                    IStoredHorse horse;
                    if (!(e instanceof AbstractHorse) || !(horse = HorseHelper.getHorseCap(e)).isOwned()) continue;
                    StoredHorsesWorldData data = HorseHelper.getWorldData(world);
                    if (data.isDisbanded(horse.getStorageUUID())) {
                        HorseManager.clearHorse(horse);
                        data.clearDisbanded(horse.getStorageUUID());
                        continue;
                    }
                    int globalNum = HorseHelper.getHorseNum(e.field_70170_p, horse.getStorageUUID());
                    if (globalNum <= horse.getHorseNum()) continue;
                    e.field_70163_u = -200.0;
                    e.func_70106_y();
                    CallableHorses.LOGGER.debug(e + " was instantly despawned because its number is " + horse.getHorseNum() + " and the global num is " + globalNum);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        EntityPlayer original = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        IHorseOwner oldHorse = HorseHelper.getOwnerCap(original);
        IHorseOwner newHorse = HorseHelper.getOwnerCap(newPlayer);
        newHorse.setHorseNBT(oldHorse.getHorseNBT());
        newHorse.setHorseNum(oldHorse.getHorseNum());
        newHorse.setStorageUUID(oldHorse.getStorageUUID());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            ClassInheritanceMultiMap[] entitylists;
            Chunk chk = event.getChunk();
            for (ClassInheritanceMultiMap list : entitylists = chk.func_177429_s()) {
                for (Entity e : list) {
                    HorseManager.saveHorse(e);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onStopTracking(PlayerEvent.StopTracking event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        Entity e = event.getTarget();
        if (!world.field_72995_K) {
            HorseManager.saveHorse(e);
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target;
        EntityPlayer player = event.getEntityPlayer();
        if (!player.field_70170_p.field_72995_K && (target = event.getTarget()) instanceof AbstractHorse) {
            HorseHelper.sendHorseUpdateToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase e;
        if ((CallableHorsesConfig.settings.enableDebug || CallableHorsesConfig.settings.continuousAntiDupeChecking) && (e = event.getEntityLiving()) instanceof AbstractHorse) {
            IStoredHorse horse = HorseHelper.getHorseCap((Entity)e);
            if (CallableHorsesConfig.settings.enableDebug) {
                e.func_96094_a("Is Owned: " + horse.isOwned() + ", Storage UUID: " + horse.getStorageUUID() + ", Horse Number: " + horse.getHorseNum() + ", Horse UUID: " + e.func_110124_au());
            }
            if (CallableHorsesConfig.settings.continuousAntiDupeChecking) {
                int thisNum = horse.getHorseNum();
                int globalNum = HorseHelper.getHorseNum(e.field_70170_p, horse.getStorageUUID());
                if (globalNum > thisNum) {
                    e.field_70163_u = -200.0;
                    e.func_70106_y();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        IStoredHorse horse;
        Entity e = event.getEntity();
        if (!e.field_70170_p.field_72995_K && e instanceof AbstractHorse && (horse = HorseHelper.getHorseCap(e)).isOwned()) {
            EntityPlayer owner = HorseHelper.getPlayerFromUUID(horse.getOwnerUUID(), e.field_70170_p);
            if (owner != null) {
                IHorseOwner horseOwner = HorseHelper.getOwnerCap(owner);
                if (CallableHorsesConfig.settings.deathIsPermanent) {
                    horseOwner.clearHorse();
                    owner.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.alert.death")));
                } else {
                    AbstractHorse deadHorse = horseOwner.getHorseEntity(owner.field_70170_p);
                    HorseManager.prepDeadHorseForRespawning((Entity)deadHorse);
                    horseOwner.setHorseNBT(deadHorse.serializeNBT());
                    horseOwner.setLastSeenPosition(BlockPos.field_177992_a);
                }
            } else {
                CallableHorses.LOGGER.debug(e + " was marked as killed.");
                HorseHelper.getWorldData(e.field_70170_p).markKilled(horse.getStorageUUID());
            }
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent event) {
        EntityPlayer player;
        IHorseOwner owner;
        String ownedHorse;
        Entity joiningEntity = event.getEntity();
        World world = event.getWorld();
        if (!world.field_72995_K && joiningEntity instanceof EntityPlayer && !(ownedHorse = (owner = HorseHelper.getOwnerCap(player = (EntityPlayer)joiningEntity)).getStorageUUID()).isEmpty()) {
            StoredHorsesWorldData data = HorseHelper.getWorldData(world);
            if (data.wasKilled(ownedHorse)) {
                data.clearKilled(ownedHorse);
                if (CallableHorsesConfig.settings.deathIsPermanent) {
                    owner.clearHorse();
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.alert.offlinedeath")));
                } else {
                    AbstractHorse deadHorse = owner.getHorseEntity(world);
                    HorseManager.prepDeadHorseForRespawning((Entity)deadHorse);
                    owner.setHorseNBT(deadHorse.serializeNBT());
                    owner.setLastSeenPosition(BlockPos.field_177992_a);
                }
            }
            if (data.wasOfflineSaved(ownedHorse)) {
                NBTTagCompound newNBT = data.getOfflineSavedHorse(ownedHorse);
                owner.setHorseNBT(newNBT);
                data.clearOfflineSavedHorse(ownedHorse);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        IStoredHorse horse;
        Entity e;
        if (CallableHorsesConfig.settings.disableHorseDrops && (e = event.getEntity()) instanceof AbstractHorse && (horse = HorseHelper.getHorseCap(e)).isOwned()) {
            event.getDrops().clear();
        }
    }
}

