/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.proxy;

import betterwithmods.module.gameplay.Gameplay;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import mirror.normalasm.NormalASM;
import mirror.normalasm.NormalLogger;
import mirror.normalasm.NormalReflector;
import mirror.normalasm.api.NormalStringPool;
import mirror.normalasm.api.datastructures.DummyMap;
import mirror.normalasm.api.datastructures.ResourceCache;
import mirror.normalasm.api.mixins.RegistrySimpleExtender;
import mirror.normalasm.client.NormalIncompatibilityHandler;
import mirror.normalasm.common.java.JavaFixes;
import mirror.normalasm.common.modfixes.betterwithmods.BWMBlastingOilOptimization;
import mirror.normalasm.common.modfixes.ebwizardry.ArcaneLocks;
import mirror.normalasm.config.NormalConfig;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CommonProxy {
    public void throwIncompatibility() {
        boolean texFix = Loader.isModLoaded((String)"texfix");
        boolean vanillaFix = Loader.isModLoaded((String)"vanillafix");
        if (texFix || vanillaFix) {
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("FermiumASM has replaced and improved upon functionalities from the following mods.");
            messages.add("Therefore, these mods are now incompatible with FermiumASM:");
            messages.add("");
            if (texFix) {
                messages.add(TextFormatting.BOLD + "TexFix");
            }
            if (vanillaFix) {
                messages.add(TextFormatting.BOLD + "VanillaFix");
            }
            NormalIncompatibilityHandler.normalHaetPizza(messages);
        }
    }

    public void construct(FMLConstructionEvent event) {
        if (NormalConfig.instance.cleanupLaunchClassLoaderEarly) {
            CommonProxy.cleanupLaunchClassLoader();
        }
        if (NormalConfig.instance.threadPriorityFix) {
            Thread.currentThread().setPriority(7);
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (NormalConfig.instance.skipCraftTweakerRecalculatingSearchTrees) {
            NormalReflector.getClass("crafttweaker.mc1120.CraftTweaker").ifPresent(c -> {
                try {
                    Field alreadyChangedThePlayer = c.getDeclaredField("alreadyChangedThePlayer");
                    alreadyChangedThePlayer.setAccessible(true);
                    alreadyChangedThePlayer.setBoolean(null, true);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            });
        }
        if (Loader.isModLoaded((String)"betterwithmods") && NormalConfig.instance.bwmBlastingOilOptimization && !Gameplay.disableBlastingOilEvents) {
            MinecraftForge.EVENT_BUS.register(BWMBlastingOilOptimization.class);
        }
        if (Loader.isModLoaded((String)"ebwizardry") && NormalConfig.instance.optimizeArcaneLockRendering) {
            NormalASM.customTileDataConsumer = ArcaneLocks.TRACK_ARCANE_TILES;
        }
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        NormalLogger.instance.info("Trimming simple registries");
        HttpUtil.field_180193_a.execute(() -> {
            NormalASM.simpleRegistryInstances.forEach(RegistrySimpleExtender::trim);
            NormalASM.simpleRegistryInstances = null;
        });
        if (NormalConfig.instance.cleanupLaunchClassLoaderEarly || NormalConfig.instance.cleanCachesOnGameLoad) {
            this.invalidateLaunchClassLoaderCaches();
        } else if (NormalConfig.instance.cleanupLaunchClassLoaderLate) {
            CommonProxy.cleanupLaunchClassLoader();
        }
        if (NormalStringPool.getSize() > 0) {
            MinecraftForge.EVENT_BUS.register(NormalStringPool.class);
            NormalLogger.instance.info("{} total strings processed. {} unique strings in NormalStringPool, {} strings deduplicated altogether during game load.", (Object)NormalStringPool.getDeduplicatedCount(), (Object)NormalStringPool.getSize(), (Object)(NormalStringPool.getDeduplicatedCount() - (long)NormalStringPool.getSize()));
        }
        if (NormalConfig.instance.filePermissionsCacheCanonicalization) {
            MinecraftForge.EVENT_BUS.register((Object)JavaFixes.INSTANCE);
        }
    }

    private void invalidateLaunchClassLoaderCaches() {
        try {
            NormalLogger.instance.info("Invalidating and Cleaning LaunchClassLoader caches");
            if (!NormalConfig.instance.noClassCache) {
                NormalReflector.resolveFieldGetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader).clear();
            }
            if (!NormalConfig.instance.noResourceCache) {
                NormalReflector.resolveFieldGetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader).clear();
                NormalReflector.resolveFieldGetter(LaunchClassLoader.class, "negativeResourceCache").invoke(Launch.classLoader).clear();
            }
            NormalReflector.resolveFieldGetter(LaunchClassLoader.class, "invalidClasses").invoke(Launch.classLoader).clear();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void cleanupLaunchClassLoader() {
        try {
            NormalLogger.instance.info("Cleaning up LaunchClassLoader");
            if (NormalConfig.instance.noClassCache) {
                NormalReflector.resolveFieldSetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader, DummyMap.of());
            } else if (NormalConfig.instance.weakClassCache) {
                Map oldClassCache = NormalReflector.resolveFieldGetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader);
                Cache newClassCache = CacheBuilder.newBuilder().concurrencyLevel(2).weakValues().build();
                newClassCache.putAll(oldClassCache);
                NormalReflector.resolveFieldSetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader, newClassCache.asMap());
            }
            if (NormalConfig.instance.noResourceCache) {
                NormalReflector.resolveFieldSetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader, new ResourceCache());
                NormalReflector.resolveFieldSetter(LaunchClassLoader.class, "negativeResourceCache").invokeExact(Launch.classLoader, DummyMap.asSet());
            } else if (NormalConfig.instance.weakResourceCache) {
                Map oldResourceCache = NormalReflector.resolveFieldGetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader);
                Cache newResourceCache = CacheBuilder.newBuilder().concurrencyLevel(2).weakValues().build();
                newResourceCache.putAll(oldResourceCache);
                NormalReflector.resolveFieldSetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader, newResourceCache.asMap());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

