/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.client.models.conditions;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import mirror.normalasm.proxy.ClientProxy;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.multipart.ICondition;
import org.apache.commons.lang3.tuple.Pair;

public class CanonicalConditions {
    public static final ICondition TRUE = state -> Predicates.alwaysTrue();
    public static final ICondition FALSE = state -> Predicates.alwaysFalse();
    private static final Object2ObjectOpenCustomHashMap<Predicate<IBlockState>[], Predicate<IBlockState>> OR_CACHE = new Object2ObjectOpenCustomHashMap(32, ObjectArrays.HASH_STRATEGY);
    private static final Object2ObjectOpenCustomHashMap<Predicate<IBlockState>[], Predicate<IBlockState>> AND_CACHE = new Object2ObjectOpenCustomHashMap(32, ObjectArrays.HASH_STRATEGY);
    private static final Object2ObjectOpenHashMap<Pair<IProperty<?>, Comparable<?>>, Predicate<IBlockState>> STATE_HAS_PROPERTY_CACHE = new Object2ObjectOpenHashMap(32);

    public static void clear() {
        OR_CACHE.clear();
        OR_CACHE.trim();
        AND_CACHE.clear();
        AND_CACHE.trim();
        STATE_HAS_PROPERTY_CACHE.clear();
        STATE_HAS_PROPERTY_CACHE.trim();
    }

    public static Predicate<IBlockState> orCache(Iterable<? extends ICondition> conditions, BlockStateContainer stateContainer) {
        return (Predicate)OR_CACHE.computeIfAbsent(CanonicalConditions.canonicalize(conditions, stateContainer), CanonicalConditions::orChain);
    }

    public static Predicate<IBlockState> orCache(Predicate<IBlockState>[] array) {
        return (Predicate)OR_CACHE.computeIfAbsent(array, CanonicalConditions::orChain);
    }

    public static Predicate<IBlockState> andCache(Iterable<? extends ICondition> conditions, BlockStateContainer stateContainer) {
        return (Predicate)AND_CACHE.computeIfAbsent(CanonicalConditions.canonicalize(conditions, stateContainer), CanonicalConditions::andChain);
    }

    public static Predicate<IBlockState> propertyValueCache(BlockStateContainer stateContainer, String key, String value, Splitter splitter) {
        List matchedStates;
        boolean invert;
        IProperty property = stateContainer.func_185920_a(key);
        if (property == null) {
            throw new RuntimeException(String.format("Unknown property '%s' on '%s'", key, stateContainer.func_177622_c().toString()));
        }
        String valueNoInvert = value;
        boolean bl = invert = !valueNoInvert.isEmpty() && valueNoInvert.charAt(0) == '!';
        if (invert) {
            valueNoInvert = valueNoInvert.substring(1);
        }
        if ((matchedStates = splitter.splitToList((CharSequence)valueNoInvert)).isEmpty()) {
            throw new RuntimeException(String.format("Empty value '%s' for property '%s' on '%s'", value, key, stateContainer.func_177622_c().toString()));
        }
        Predicate<IBlockState> isMatchedState = matchedStates.size() == 1 ? CanonicalConditions.makePropertyPredicate(stateContainer, property, valueNoInvert, key, value) : CanonicalConditions.orCache((Predicate[])matchedStates.stream().map(subValue -> CanonicalConditions.makePropertyPredicate(stateContainer, property, subValue, key, value)).sorted(Comparator.comparingInt(Object::hashCode)).toArray(Predicate[]::new));
        return invert ? Predicates.not(isMatchedState) : isMatchedState;
    }

    private static <T> Predicate<T> orChain(Predicate<T>[] array) {
        return state -> {
            for (Predicate predicate : array) {
                if (!predicate.test(state)) continue;
                return true;
            }
            return false;
        };
    }

    private static <T> Predicate<T> andChain(Predicate<T>[] array) {
        return state -> {
            for (Predicate predicate : array) {
                if (predicate.test(state)) continue;
                return false;
            }
            return true;
        };
    }

    private static Predicate<IBlockState>[] canonicalize(Iterable<? extends ICondition> conditions, BlockStateContainer stateContainer) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        for (ICondition iCondition : conditions) {
            list.add(iCondition.func_188118_a(stateContainer));
        }
        Predicate[] array = list.toArray(new Predicate[0]);
        Arrays.sort(array, Comparator.comparingInt(Object::hashCode));
        return array;
    }

    private static <T extends Comparable<T>> Predicate<IBlockState> makePropertyPredicate(BlockStateContainer container, IProperty<T> property, String subValue, String key, String value) {
        Optional optional = property.func_185929_b(subValue);
        if (!optional.isPresent()) {
            throw new RuntimeException(String.format("Unknown value '%s' for property '%s' on '%s' in '%s'", subValue, key, container.func_177622_c().toString(), value));
        }
        return (Predicate)STATE_HAS_PROPERTY_CACHE.computeIfAbsent((Object)Pair.of(property, (Object)optional.get()), p -> s -> s.func_177229_b((IProperty)p.getLeft()).equals(p.getRight()));
    }

    static {
        ClientProxy.refreshAfterModels.add(CanonicalConditions::clear);
    }
}

