/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.baubleye;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import baubles.client.gui.GuiBaublesButton;
import cofh.core.enchantment.EnchantmentSoulbound;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import git.jbredwards.baubleye.BaubleyElytra;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="baubleye")
public final class EventBaubleFixer {
    @GameRegistry.ObjectHolder(value="cofhcore:soulbound")
    public static Enchantment COFH_SOULBOUND = null;
    @GameRegistry.ObjectHolder(value="tombstone:soulbound")
    public static Enchantment TOMBSTONE_SOULBOUND = null;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleBaublesDeathDrops(@Nonnull PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        player.captureDrops = true;
        IBaublesItemHandler baublesInventory = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slot = 0; slot < baublesInventory.getSlots(); ++slot) {
            boolean hasAnySoulbound;
            ItemStack bauble = baublesInventory.getStackInSlot(slot);
            boolean hasVanishingCurse = EnchantmentHelper.func_190939_c((ItemStack)bauble);
            boolean bl = hasAnySoulbound = EnchantmentHelper.func_77506_a((Enchantment)COFH_SOULBOUND, (ItemStack)bauble) > 0 || EnchantmentHelper.func_77506_a((Enchantment)TOMBSTONE_SOULBOUND, (ItemStack)bauble) > 0;
            if (!(hasVanishingCurse || !(player instanceof FakePlayer) && hasAnySoulbound)) {
                player.func_146097_a(bauble, true, false);
            }
            if (!hasVanishingCurse && !(player instanceof FakePlayer) && hasAnySoulbound) continue;
            baublesInventory.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        player.captureDrops = false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void keepBaubleSoulboundOnDeath(@Nonnull PlayerEvent.Clone event) {
        if (event.isWasDeath() && COFH_SOULBOUND != null) {
            EntityPlayer newPlayer = event.getEntityPlayer();
            if (newPlayer instanceof FakePlayer || newPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                return;
            }
            IBaublesItemHandler oldBaubleInventory = BaublesApi.getBaublesHandler((EntityPlayer)event.getOriginal());
            for (int slot = 0; slot < oldBaubleInventory.getSlots(); ++slot) {
                ItemStack bauble = oldBaubleInventory.getStackInSlot(slot);
                int level = EnchantmentHelper.func_77506_a((Enchantment)COFH_SOULBOUND, (ItemStack)bauble);
                if (level <= 0) continue;
                CoFHCoreHelper.handleSoulboundEnchantment(bauble, level);
                oldBaubleInventory.setStackInSlot(slot, bauble);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    static void addCreativeBaublesButton(@Nonnull GuiScreenEvent.InitGuiEvent.Post event) {
        if (BaubleyElytra.ConfigHandler.creativeAccessibility && event.getGui() instanceof GuiContainerCreative) {
            final GuiContainerCreative gui = (GuiContainerCreative)event.getGui();
            event.getButtonList().add(new GuiBaublesButton(55, (GuiContainer)gui, 95, 6, 10, 10, I18n.func_135052_a((String)"button.baubles", (Object[])new Object[0])){

                public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                    this.field_146125_m = gui.func_147056_g() == CreativeTabs.field_78036_m.func_78021_a();
                    super.func_191745_a(mc, mouseX, mouseY, partialTicks);
                }
            });
        }
    }

    static final class CoFHCoreHelper {
        CoFHCoreHelper() {
        }

        static void handleSoulboundEnchantment(@Nonnull ItemStack stack, int level) {
            if (EnchantmentSoulbound.permanent) {
                if (level > 1) {
                    ItemHelper.removeEnchantment((ItemStack)stack, (Enchantment)COFH_SOULBOUND);
                    ItemHelper.addEnchantment((ItemStack)stack, (Enchantment)COFH_SOULBOUND, (int)1);
                }
            } else if (MathHelper.RANDOM.nextInt(level + 1) == 0) {
                ItemHelper.removeEnchantment((ItemStack)stack, (Enchantment)COFH_SOULBOUND);
                if (level > 1) {
                    ItemHelper.addEnchantment((ItemStack)stack, (Enchantment)COFH_SOULBOUND, (int)(level - 1));
                }
            }
        }
    }
}

