/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.baubleye;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import baubles.client.gui.GuiPlayerExpanded;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketOpenBaublesInventory;
import baubles.common.network.PacketOpenNormalInventory;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@IFMLLoadingPlugin.SortingIndex(value=1006)
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.Name(value="Baubley Elytra Plugin")
@Mod(modid="baubleye", name="Baubley Elytra", version="1.3.3", dependencies="required-after:baubles", acceptedMinecraftVersions="[1.12.2]")
public final class BaubleyElytra
implements IFMLLoadingPlugin,
Opcodes {
    @Nonnull
    public String[] getASMTransformerClass() {
        return new String[]{"git.jbredwards.baubleye.BaubleyElytra$Transformer"};
    }

    @Nullable
    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(@Nonnull Map<String, Object> map) {
    }

    @Nullable
    public String getAccessTransformerClass() {
        return null;
    }

    @Config(modid="baubleye")
    @Mod.EventBusSubscriber(modid="baubleye")
    public static final class ConfigHandler {
        @Config.LangKey(value="config.baubleye.creativeAccessibility")
        public static boolean creativeAccessibility = true;
        @Config.LangKey(value="config.baubleye.slot")
        @Nonnull
        public static BaubleType BAUBLE_TYPE = BaubleType.BODY;
        @Nonnull
        static final ResourceLocation CAPABILITY_ID = new ResourceLocation("baubleye", "elytra");

        @SubscribeEvent
        public static void sync(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
            if ("baubleye".equals(event.getModID())) {
                ConfigManager.sync((String)"baubleye", (Config.Type)Config.Type.INSTANCE);
            }
        }

        @SubscribeEvent
        public static void makeElytraBauble(@Nonnull AttachCapabilitiesEvent<ItemStack> event) {
            if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemElytra && !((ItemStack)event.getObject()).hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
                event.addCapability(CAPABILITY_ID, new ICapabilityProvider(){

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(this.hasCapability(capability, facing) ? BaublesCapabilities.CAPABILITY_ITEM_BAUBLE.cast(stack -> BAUBLE_TYPE) : null);
                    }
                });
            }
        }
    }

    private static class ButtonSoundPlayer {
        private ButtonSoundPlayer() {
        }

        @SideOnly(value=Side.CLIENT)
        static void playButtonClickSound() {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    public static final class Hooks {
        @Nonnull
        public static EnumActionResult equipElytraBauble(@Nonnull EntityPlayer player, @Nonnull ItemStack held) {
            IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i : ConfigHandler.BAUBLE_TYPE.getValidSlots()) {
                if (!handler.getStackInSlot(i).func_190926_b()) continue;
                handler.setStackInSlot(i, held.func_77946_l());
                player.func_184185_a(SoundEvents.field_191258_p, 1.0f, 1.0f);
                held.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }

        @Nonnull
        public static ItemStack getElytra(@Nonnull ItemStack armor, @Nonnull EntityLivingBase entity) {
            if (armor.func_77973_b() instanceof ItemElytra && ItemElytra.func_185069_d((ItemStack)armor)) {
                return armor;
            }
            if (entity instanceof EntityPlayer) {
                IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity));
                ItemStack ret = ItemStack.field_190927_a;
                for (int i : ConfigHandler.BAUBLE_TYPE.getValidSlots()) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof ItemElytra)) continue;
                    if (ItemElytra.func_185069_d((ItemStack)stack)) {
                        return stack;
                    }
                    if (!ret.func_190926_b()) continue;
                    ret = stack;
                }
                if (!ret.func_190926_b()) {
                    return ret;
                }
            }
            return armor;
        }

        public static void writeItemStack(@Nonnull ByteBuf to, @Nonnull ItemStack stack) {
            new PacketBuffer(to).func_150786_a(stack.serializeNBT());
        }

        @Nonnull
        public static ItemStack readItemStack(@Nonnull ByteBuf to) {
            try {
                return new ItemStack(Objects.requireNonNull(new PacketBuffer(to).func_150793_b()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static boolean isEmptyOrHasBindingCurse(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
            return stack.func_190926_b() || !player.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)stack);
        }

        @SideOnly(value=Side.CLIENT)
        public static void onBaublesButtonMouseReleased(@Nonnull GuiContainer parentGui) {
            ButtonSoundPlayer.playButtonClickSound();
            if (parentGui instanceof GuiPlayerExpanded) {
                ((GuiPlayerExpanded)parentGui).displayNormalInventory();
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenNormalInventory());
            } else {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenBaublesInventory());
            }
        }

        public static void handleEnchantedBaubles(@Nonnull Enchantment ench, @Nonnull EntityLivingBase entity, @Nonnull List<ItemStack> validItems) {
            IBaublesItemHandler handler;
            if (entity instanceof EntityPlayer && ench.field_77351_y != null && (handler = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity))) != null) {
                int[] slots = null;
                switch (ench.field_77351_y) {
                    case ARMOR_HEAD: {
                        slots = BaubleType.HEAD.getValidSlots();
                        break;
                    }
                    case ARMOR_CHEST: {
                        slots = new int[]{0, 5};
                        break;
                    }
                    case ARMOR_LEGS: {
                        slots = BaubleType.BELT.getValidSlots();
                        break;
                    }
                    case ALL: 
                    case ARMOR: 
                    case BREAKABLE: 
                    case WEARABLE: {
                        slots = BaubleType.TRINKET.getValidSlots();
                    }
                }
                if (slots != null) {
                    for (int slot : slots) {
                        ItemStack stack = handler.getStackInSlot(slot);
                        if (stack.func_190926_b()) continue;
                        validItems.add(stack);
                    }
                }
            }
        }
    }

    public static final class Transformer
    implements IClassTransformer {
        @Nonnull
        static final Map<String, Pair<String, String>> OBFUSCATION_MAP = ImmutableMap.builder().put((Object)"git.jbredwards.customizableelytra.mod.client.layer.LayerCustomizableElytra", (Object)Pair.of((Object)"doRenderLayer", (Object)"func_177141_a")).put((Object)"goblinbob.mobends.standard.client.renderer.entity.layers.LayerCustomCape", (Object)Pair.of((Object)"doRenderLayer", (Object)"func_177141_a")).put((Object)"goblinbob.mobends.standard.client.renderer.entity.layers.LayerCustomElytra", (Object)Pair.of((Object)"doRenderLayer", (Object)"func_177141_a")).put((Object)"vazkii.quark.vanity.client.layer.LayerBetterElytra", (Object)Pair.of((Object)"doRenderLayer", (Object)"doRenderLayer")).put((Object)"baubles.common.container.SlotBauble", (Object)Pair.of((Object)"canTakeStack", (Object)"func_82869_a")).put((Object)"baubles.common.network.PacketSync", (Object)Pair.of((Object)"toBytes", (Object)"toBytes")).put((Object)"net.minecraft.client.entity.EntityPlayerSP", (Object)Pair.of((Object)"onLivingUpdate", (Object)"func_70636_d")).put((Object)"net.minecraft.client.renderer.entity.layers.LayerCape", (Object)Pair.of((Object)"doRenderLayer", (Object)"func_177141_a")).put((Object)"net.minecraft.client.renderer.entity.layers.LayerElytra", (Object)Pair.of((Object)"doRenderLayer", (Object)"func_177141_a")).put((Object)"net.minecraft.enchantment.Enchantment", (Object)Pair.of((Object)"getEntityEquipment", (Object)"func_185260_a")).put((Object)"net.minecraft.entity.EntityLivingBase", (Object)Pair.of((Object)"updateElytra", (Object)"func_184616_r")).put((Object)"net.minecraft.item.ItemElytra", (Object)Pair.of((Object)"onItemRightClick", (Object)"func_77659_a")).put((Object)"net.minecraft.network.NetHandlerPlayServer", (Object)Pair.of((Object)"processEntityAction", (Object)"func_147357_a")).build();

        public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
            boolean isDropFix = "baubles.common.event.EventHandlerEntity".equals(transformedName);
            boolean isCreativeFix = "baubles.client.gui.GuiBaublesButton".equals(transformedName);
            if (isDropFix || isCreativeFix || OBFUSCATION_MAP.containsKey(transformedName)) {
                ClassNode classNode = new ClassNode();
                new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
                if (isDropFix) {
                    classNode.methods.removeIf(method -> method.name.equals("playerDeath"));
                } else if (isCreativeFix) {
                    classNode.methods.removeIf(methodIn -> methodIn.name.equals(FMLLaunchHandler.isDeobfuscatedEnvironment() ? "mousePressed" : "func_146116_c"));
                    MethodNode mousePressed = new MethodNode(1, FMLLaunchHandler.isDeobfuscatedEnvironment() ? "mousePressed" : "func_146116_c", "(Lnet/minecraft/client/Minecraft;II)Z", null, null);
                    GeneratorAdapter mousePressedGen = new GeneratorAdapter((MethodVisitor)mousePressed, mousePressed.access, mousePressed.name, mousePressed.desc);
                    mousePressedGen.visitVarInsn(25, 0);
                    mousePressedGen.visitVarInsn(25, 1);
                    mousePressedGen.visitVarInsn(21, 2);
                    mousePressedGen.visitVarInsn(25, 0);
                    mousePressedGen.visitFieldInsn(180, "baubles/client/gui/GuiBaublesButton", "parentGui", "Lnet/minecraft/client/gui/inventory/GuiContainer;");
                    mousePressedGen.visitMethodInsn(182, "net/minecraft/client/gui/inventory/GuiContainer", "getGuiLeft", "()I", false);
                    mousePressedGen.visitInsn(100);
                    mousePressedGen.visitVarInsn(21, 3);
                    mousePressedGen.visitMethodInsn(183, "net/minecraft/client/gui/GuiButton", FMLLaunchHandler.isDeobfuscatedEnvironment() ? "mousePressed" : "func_146116_c", "(Lnet/minecraft/client/Minecraft;II)Z", false);
                    mousePressedGen.visitInsn(172);
                    MethodNode mouseReleased = new MethodNode(1, FMLLaunchHandler.isDeobfuscatedEnvironment() ? "mouseReleased" : "func_146118_a", "(II)V", null, null);
                    GeneratorAdapter mouseReleasedGen = new GeneratorAdapter((MethodVisitor)mouseReleased, mouseReleased.access, mouseReleased.name, mouseReleased.desc);
                    mouseReleasedGen.visitVarInsn(25, 0);
                    mouseReleasedGen.visitFieldInsn(180, "baubles/client/gui/GuiBaublesButton", "parentGui", "Lnet/minecraft/client/gui/inventory/GuiContainer;");
                    mouseReleasedGen.visitMethodInsn(184, "git/jbredwards/baubleye/BaubleyElytra$Hooks", "onBaublesButtonMouseReleased", "(Lnet/minecraft/client/gui/inventory/GuiContainer;)V", false);
                    mouseReleasedGen.visitInsn(177);
                    MethodNode playPressSound = new MethodNode(1, FMLLaunchHandler.isDeobfuscatedEnvironment() ? "playPressSound" : "func_146113_a", "(Lnet/minecraft/client/audio/SoundHandler;)V", null, null);
                    playPressSound.visitInsn(177);
                    classNode.methods.add(mousePressed);
                    classNode.methods.add(mouseReleased);
                    classNode.methods.add(playPressSound);
                } else {
                    String methodName = FMLLaunchHandler.isDeobfuscatedEnvironment() ? (String)OBFUSCATION_MAP.get(transformedName).getLeft() : (String)OBFUSCATION_MAP.get(transformedName).getRight();
                    block0: for (MethodNode method2 : classNode.methods) {
                        if (!method2.name.equals(methodName)) continue;
                        for (AbstractInsnNode insn : method2.instructions.toArray()) {
                            if ("net.minecraft.item.ItemElytra".equals(transformedName)) {
                                if (insn.getOpcode() != 178 || !((FieldInsnNode)insn).name.equals("FAIL")) continue;
                                if (!FMLLaunchHandler.isDeobfuscatedEnvironment()) {
                                    AbstractInsnNode frame = insn.getPrevious().getPrevious().getPrevious();
                                    method2.instructions.insert(frame, (AbstractInsnNode)new FrameNode(1, 3, new Object[]{"net/minecraft/item/ItemStack", "net/minecraft/inventory/EntityEquipmentSlot", "net/minecraft/item/ItemStack"}, 0, null));
                                    method2.instructions.remove(frame);
                                }
                                method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                                method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 4));
                                method2.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/baubleye/BaubleyElytra$Hooks", "equipElytraBauble", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/util/EnumActionResult;", false));
                                method2.instructions.remove(insn);
                                break block0;
                            }
                            if ("baubles.common.network.PacketSync".equals(transformedName)) {
                                if (insn.getOpcode() != 184) continue;
                                if (((MethodInsnNode)insn).name.equals("writeItemStack")) {
                                    ((MethodInsnNode)insn).owner = "git/jbredwards/baubleye/BaubleyElytra$Hooks";
                                    methodName = "fromBytes";
                                    continue block0;
                                }
                                if (!((MethodInsnNode)insn).name.equals("readItemStack")) continue;
                                ((MethodInsnNode)insn).owner = "git/jbredwards/baubleye/BaubleyElytra$Hooks";
                                break block0;
                            }
                            if ("baubles.common.container.SlotBauble".equals(transformedName)) {
                                if (insn.getOpcode() != 182 || !((MethodInsnNode)insn).name.equals(FMLLaunchHandler.isDeobfuscatedEnvironment() ? "isEmpty" : "func_190926_b")) continue;
                                method2.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/baubleye/BaubleyElytra$Hooks", "isEmptyOrHasBindingCurse", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;)Z", false));
                                method2.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                                method2.instructions.remove(insn);
                                break block0;
                            }
                            if ("net.minecraft.enchantment.Enchantment".equals(transformedName)) {
                                if (insn.getOpcode() != 176) continue;
                                InsnList list = new InsnList();
                                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                                list.add((AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/baubleye/BaubleyElytra$Hooks", "handleEnchantedBaubles", "(Lnet/minecraft/enchantment/Enchantment;Lnet/minecraft/entity/EntityLivingBase;Ljava/util/List;)V", false));
                                method2.instructions.insertBefore(insn.getPrevious(), list);
                                break block0;
                            }
                            if (insn.getOpcode() != 182 || !((MethodInsnNode)insn).name.equals(FMLLaunchHandler.isDeobfuscatedEnvironment() ? "getItemStackFromSlot" : "func_184582_a")) continue;
                            method2.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/baubleye/BaubleyElytra$Hooks", "getElytra", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/item/ItemStack;", false));
                            Transformer.carryOverEntity(method2.instructions, insn, insn.getPrevious().getPrevious());
                            break block0;
                        }
                    }
                }
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            return basicClass;
        }

        static void carryOverEntity(@Nonnull InsnList instructions, @Nonnull AbstractInsnNode location, @Nonnull AbstractInsnNode entity) {
            if (entity instanceof VarInsnNode) {
                instructions.insert(location, (AbstractInsnNode)new VarInsnNode(entity.getOpcode(), ((VarInsnNode)entity).var));
            } else if (entity instanceof FieldInsnNode) {
                FieldInsnNode field = (FieldInsnNode)entity;
                instructions.insert(location, (AbstractInsnNode)new FieldInsnNode(field.getOpcode(), field.owner, field.name, field.desc));
                Transformer.carryOverEntity(instructions, location, field.getPrevious());
            }
        }
    }
}

