/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcreopargh.ctintegration.util;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import crafttweaker.mc1120.CraftTweaker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ctintegration.util.RecipePattern")
@ZenRegister
public class RecipePattern {
    private final String[] pattern;
    private final Map<Character, IIngredient> mapping = new HashMap<Character, IIngredient>();
    private boolean isMirrored = false;
    private boolean isShapeless = false;
    private String name;
    private IItemStack output;
    private IRecipeFunction recipeFunction;
    private IRecipeAction recipeAction;

    public RecipePattern(String[] pattern) {
        this.pattern = pattern;
    }

    public RecipePattern(IItemStack output, String[] pattern) {
        this.pattern = pattern;
        this.output = output;
    }

    public RecipePattern(String name, IItemStack output, String[] pattern) {
        this.pattern = pattern;
        this.output = output;
        this.name = name;
    }

    @ZenMethod
    public static RecipePattern init(String[] recipePattern) {
        return new RecipePattern(recipePattern);
    }

    public static IIngredient[][] listToArray2D(List<List<IIngredient>> arrayList) {
        IIngredient[][] array = new IIngredient[arrayList.size()][];
        for (int i = 0; i < arrayList.size(); ++i) {
            List<IIngredient> row = arrayList.get(i);
            array[i] = row.toArray(new IIngredient[0]);
        }
        return array;
    }

    @ZenMethod
    public static RecipePattern init(IItemStack output, String[] recipePattern) {
        return new RecipePattern(output, recipePattern);
    }

    @ZenMethod
    public static RecipePattern init(String name, IItemStack output, String[] recipePattern) {
        return new RecipePattern(name, output, recipePattern);
    }

    @ZenMethod
    public RecipePattern with(String character, IIngredient ingredient) {
        if (character.length() != 1) {
            CraftTweakerAPI.logError((String)"Mapping key must be one single character", (Throwable)new IllegalArgumentException());
        } else {
            char firstChar = character.charAt(0);
            if (Character.isWhitespace(firstChar)) {
                CraftTweakerAPI.logError((String)"You can't map a whitespace character!", (Throwable)new IllegalArgumentException());
            } else {
                this.mapping.put(Character.valueOf(firstChar), ingredient);
            }
        }
        return this;
    }

    @ZenMethod
    public RecipePattern withOutput(IItemStack output) {
        this.output = output;
        return this;
    }

    @ZenMethod
    public RecipePattern and(String character, IIngredient ingredient) {
        return this.with(character, ingredient);
    }

    @ZenMethod
    public RecipePattern setMirrored(boolean isMirrored) {
        this.isMirrored = isMirrored;
        return this;
    }

    @ZenMethod
    public RecipePattern setName(String name) {
        this.name = name;
        return this;
    }

    @ZenMethod
    public RecipePattern setShapeless(boolean isShapeless) {
        this.isShapeless = isShapeless;
        return this;
    }

    @ZenMethod
    public RecipePattern setFunction(IRecipeFunction function) {
        this.recipeFunction = function;
        return this;
    }

    @ZenMethod
    public RecipePattern setAction(IRecipeAction action) {
        this.recipeAction = action;
        return this;
    }

    @ZenGetter(value="ingredients")
    public IIngredient[][] getIngredients() {
        ArrayList<List<IIngredient>> grid = new ArrayList<List<IIngredient>>();
        for (String rowString : this.pattern) {
            ArrayList<IIngredient> row = new ArrayList<IIngredient>();
            for (char ch : rowString.toCharArray()) {
                if (Character.isWhitespace(ch)) {
                    row.add(null);
                    continue;
                }
                if (this.mapping.containsKey(Character.valueOf(ch))) {
                    row.add(this.mapping.get(Character.valueOf(ch)));
                    continue;
                }
                CraftTweakerAPI.logWarning((String)("Cannot find matching ingredient for character '" + ch + "', using null instead."));
            }
            grid.add(row);
        }
        return RecipePattern.listToArray2D(grid);
    }

    @ZenGetter(value="shapelessIngredients")
    public IIngredient[] getShapelessIngredients() {
        IIngredient[][] grid = this.getIngredients();
        ArrayList<IIngredient> shapelessRecipeList = new ArrayList<IIngredient>();
        IIngredient[][] iIngredientArray = grid;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] row;
            for (IIngredient ingredient : row = iIngredientArray[i]) {
                if (ingredient == null) continue;
                shapelessRecipeList.add(ingredient);
            }
        }
        return shapelessRecipeList.toArray(new IIngredient[0]);
    }

    @ZenMethod
    public RecipePattern map(Map<String, IIngredient> mapping) {
        for (Map.Entry<String, IIngredient> entry : mapping.entrySet()) {
            this.with(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @ZenMethod
    public void build() {
        IIngredient[][] grid = this.getIngredients();
        if (grid.length == 0) {
            CraftTweakerAPI.logError((String)"The pattern is empty", (Throwable)new IllegalArgumentException());
            return;
        }
        if (this.isShapeless) {
            IIngredient[] shapelessRecipe = this.getShapelessIngredients();
            if (this.name == null) {
                CraftTweaker.INSTANCE.recipes.addShapeless(this.output, shapelessRecipe, this.recipeFunction, this.recipeAction);
            } else {
                CraftTweaker.INSTANCE.recipes.addShapeless(this.name, this.output, shapelessRecipe, this.recipeFunction, this.recipeAction);
            }
        } else if (this.isMirrored) {
            if (this.name == null) {
                CraftTweaker.INSTANCE.recipes.addShapedMirrored(this.output, grid, this.recipeFunction, this.recipeAction);
            } else {
                CraftTweaker.INSTANCE.recipes.addShapedMirrored(this.name, this.output, grid, this.recipeFunction, this.recipeAction);
            }
        } else if (this.name == null) {
            CraftTweaker.INSTANCE.recipes.addShaped(this.output, grid, this.recipeFunction, this.recipeAction);
        } else {
            CraftTweaker.INSTANCE.recipes.addShaped(this.name, this.output, grid, this.recipeFunction, this.recipeAction);
        }
    }
}

