/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcreopargh.ctintegration.util;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import xyz.tcreopargh.ctintegration.date.CalendarDate;
import xyz.tcreopargh.ctintegration.date.IDate;

@ZenRegister
@ZenClass(value="mods.ctintegration.util.DateUtil")
public class DateUtil {
    @ZenMethod
    public static IDate now() {
        return new CalendarDate();
    }

    public static IDate fromDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new CalendarDate(cal);
    }

    @ZenMethod
    public static IDate fromTimeInMillis(long timeInMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeInMillis);
        return new CalendarDate(cal);
    }

    @ZenMethod
    public static IDate parse(String format, String dateString) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        try {
            Date date = simpleDateFormat.parse(dateString);
            return DateUtil.fromDate(date);
        }
        catch (ParseException e) {
            CraftTweakerAPI.logInfo((String)("Wrong date format: cannot format " + dateString + " with " + format));
            return null;
        }
    }

    @ZenMethod
    public static int ERA() {
        return 0;
    }

    @ZenMethod
    public static int YEAR() {
        return 1;
    }

    @ZenMethod
    public static int MONTH() {
        return 2;
    }

    @ZenMethod
    public static int WEEK_OF_YEAR() {
        return 3;
    }

    @ZenMethod
    public static int WEEK_OF_MONTH() {
        return 4;
    }

    @ZenMethod
    public static int DATE() {
        return 5;
    }

    @ZenMethod
    public static int DAY_OF_MONTH() {
        return 5;
    }

    @ZenMethod
    public static int DAY_OF_YEAR() {
        return 6;
    }

    @ZenMethod
    public static int DAY_OF_WEEK() {
        return 7;
    }

    @ZenMethod
    public static int DAY_OF_WEEK_IN_MONTH() {
        return 8;
    }

    @ZenMethod
    public static int AM_PM() {
        return 9;
    }

    @ZenMethod
    public static int HOUR() {
        return 10;
    }

    @ZenMethod
    public static int HOUR_OF_DAY() {
        return 11;
    }

    @ZenMethod
    public static int MINUTE() {
        return 12;
    }

    @ZenMethod
    public static int SECOND() {
        return 13;
    }

    @ZenMethod
    public static int MILLISECOND() {
        return 14;
    }

    @ZenMethod
    public static int ZONE_OFFSET() {
        return 15;
    }

    @ZenMethod
    public static int DST_OFFSET() {
        return 16;
    }

    @ZenMethod
    public static int FIELD_COUNT() {
        return 17;
    }

    @ZenMethod
    public static int SUNDAY() {
        return 1;
    }

    @ZenMethod
    public static int MONDAY() {
        return 2;
    }

    @ZenMethod
    public static int TUESDAY() {
        return 3;
    }

    @ZenMethod
    public static int WEDNESDAY() {
        return 4;
    }

    @ZenMethod
    public static int THURSDAY() {
        return 5;
    }

    @ZenMethod
    public static int FRIDAY() {
        return 6;
    }

    @ZenMethod
    public static int SATURDAY() {
        return 7;
    }

    @ZenMethod
    public static int JANUARY() {
        return 0;
    }

    @ZenMethod
    public static int FEBRUARY() {
        return 1;
    }

    @ZenMethod
    public static int MARCH() {
        return 2;
    }

    @ZenMethod
    public static int APRIL() {
        return 3;
    }

    @ZenMethod
    public static int MAY() {
        return 4;
    }

    @ZenMethod
    public static int JUNE() {
        return 5;
    }

    @ZenMethod
    public static int JULY() {
        return 6;
    }

    @ZenMethod
    public static int AUGUST() {
        return 7;
    }

    @ZenMethod
    public static int SEPTEMBER() {
        return 8;
    }

    @ZenMethod
    public static int OCTOBER() {
        return 9;
    }

    @ZenMethod
    public static int NOVEMBER() {
        return 10;
    }

    @ZenMethod
    public static int DECEMBER() {
        return 11;
    }

    @ZenMethod
    public static int UNDECIMBER() {
        return 12;
    }

    @ZenMethod
    public static int AM() {
        return 0;
    }

    @ZenMethod
    public static int PM() {
        return 1;
    }
}

