/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.elements;

import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xzeroair.trinkets.Registries;
import xzeroair.trinkets.traits.elements.AirElement;
import xzeroair.trinkets.traits.elements.DarkElement;
import xzeroair.trinkets.traits.elements.EarthElement;
import xzeroair.trinkets.traits.elements.FireElement;
import xzeroair.trinkets.traits.elements.IceElement;
import xzeroair.trinkets.traits.elements.LightElement;
import xzeroair.trinkets.traits.elements.LightningElement;
import xzeroair.trinkets.traits.elements.NeutralElement;
import xzeroair.trinkets.traits.elements.PoisonElement;
import xzeroair.trinkets.traits.elements.VoidElement;
import xzeroair.trinkets.traits.elements.WaterElement;

public class Element
extends IForgeRegistryEntry.Impl<Element> {
    public static final ForgeRegistry<Element> Registry = Registries.getElementRegistry();
    protected final String name;

    public Element(String name) {
        this.name = name;
        this.setRegistryName(name);
    }

    public String getName() {
        return this.name;
    }

    public Element[] getStrengths() {
        return new Element[0];
    }

    public Element[] getWeaknesses() {
        return new Element[0];
    }

    public int getID() {
        return Registry.getID((IForgeRegistryEntry)this);
    }

    public static int getIdFromElement(Element element) {
        return element == null ? 0 : Registry.getID((IForgeRegistryEntry)element);
    }

    public static Element getItemById(int id) {
        return (Element)Registry.getValue(id);
    }

    @Nullable
    public static Element getByNameOrId(String id) {
        Element item = (Element)Registry.getValue(new ResourceLocation(id));
        if (item == null) {
            try {
                return Element.getItemById(Integer.parseInt(id));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return item;
    }

    public static void registerElements() {
        Registry.register((IForgeRegistryEntry)new NeutralElement());
        Registry.register((IForgeRegistryEntry)new AirElement());
        Registry.register((IForgeRegistryEntry)new DarkElement());
        Registry.register((IForgeRegistryEntry)new EarthElement());
        Registry.register((IForgeRegistryEntry)new FireElement());
        Registry.register((IForgeRegistryEntry)new IceElement());
        Registry.register((IForgeRegistryEntry)new LightElement());
        Registry.register((IForgeRegistryEntry)new LightningElement());
        Registry.register((IForgeRegistryEntry)new PoisonElement());
        Registry.register((IForgeRegistryEntry)new VoidElement());
        Registry.register((IForgeRegistryEntry)new WaterElement());
    }
}

