/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities.other;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.entity.AlphaWolf;
import xzeroair.trinkets.races.goblin.config.GoblinConfig;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IInteractionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IKeyBindInterface;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.handlers.Counter;
import xzeroair.trinkets.util.helpers.RayTraceHelper;

public class AbilityWolfMount
extends Ability
implements ITickableAbility,
IKeyBindInterface,
IInteractionAbility {
    protected static final GoblinConfig serverConfig = TrinketsConfig.SERVER.races.goblin;

    public AbilityWolfMount() {
        super("mount_enhancement");
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        Counter counter = this.tickHandler.getCounter("mountAtkCooldown", 40, true, true, false, true, false);
        if (counter != null && counter.getTick() > 0) {
            counter.Tick();
        }
    }

    @Override
    public void interactEntity(EntityLivingBase entityLiving, World world, ItemStack itemStack, EnumHand hand, EnumFacing face, BlockPos pos, Entity target) {
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        if (entity instanceof EntityPlayer) {
            RayTraceResult result;
            EntityPlayer player = (EntityPlayer)entity;
            World world = player.func_130014_f_();
            boolean canRide = AbilityWolfMount.serverConfig.rider;
            if (!canRide) {
                return true;
            }
            double reachDistance = 5.0;
            IAttributeInstance reachAttribe = player.func_110148_a(EntityPlayer.REACH_DISTANCE);
            if (reachAttribe != null) {
                reachDistance = reachAttribe.func_111126_e();
            }
            if (player.func_184218_aH() && player.func_184187_bx() instanceof AlphaWolf) {
                Counter counter = this.tickHandler.getCounter("mountAtkCooldown", 40, true, true, false, true, false);
                AlphaWolf wolf = (AlphaWolf)player.func_184187_bx();
                if (counter.Tick()) {
                    wolf.MountedAttack(player, reachDistance);
                    counter.resetTick();
                }
            } else if (!player.func_184218_aH() && (result = RayTraceHelper.rayTrace(world, (EntityLivingBase)player, reachDistance * 0.5, true)) != null && result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g instanceof EntityWolf && !(result.field_72308_g instanceof AlphaWolf)) {
                this.MountWolf((EntityLivingBase)player, (EntityWolf)result.field_72308_g);
            }
        }
        return true;
    }

    @Override
    public boolean onKeyDown(Entity entity, boolean Aux) {
        return true;
    }

    @Override
    public boolean onKeyRelease(Entity entity, boolean Aux) {
        return true;
    }

    public boolean MountWolf(EntityLivingBase entity, EntityWolf wolf) {
        boolean isOwner;
        World world = entity.func_130014_f_();
        boolean canRide = AbilityWolfMount.serverConfig.rider;
        boolean bl = isOwner = wolf.func_70909_n() && wolf.func_152114_e(entity);
        if (!canRide || !isOwner || wolf.func_70631_g_()) {
            return false;
        }
        if (!world.field_72995_K && !entity.func_184218_aH()) {
            AlphaWolf newWolf = new AlphaWolf(world);
            newWolf.func_96094_a(wolf.func_95999_t());
            newWolf.func_70012_b(wolf.field_70165_t, wolf.field_70163_u, wolf.field_70161_v, wolf.field_70177_z, 0.0f);
            newWolf.setTamedBy(entity);
            newWolf.func_70606_j(wolf.func_110143_aJ());
            if (world.func_72838_d((Entity)newWolf)) {
                newWolf.getEntityData().func_74757_a("xat:summoned", true);
                if (entity.func_184220_m((Entity)newWolf)) {
                    NBTTagCompound tag = new NBTTagCompound();
                    wolf.func_189511_e(tag);
                    tag.func_74778_a("id", EntityList.func_191306_a(wolf.getClass()).toString());
                    newWolf.storeOldWolf(tag);
                    wolf.func_70106_y();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        return ModKeyBindings.RACE_ABILITY.getDisplayName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getAuxKey() {
        return ModKeyBindings.AUX_KEY.getDisplayName();
    }
}

