/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.trinkets.TrinketPolarized;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IHeldAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IKeyBindInterface;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableInventoryAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IToggleAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigPolarizedStone;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class AbilityMagnetic
extends Ability
implements ITickableAbility,
IHeldAbility,
ITickableInventoryAbility,
IToggleAbility,
IKeyBindInterface {
    private static final ConfigPolarizedStone serverConfig = TrinketsConfig.SERVER.Items.POLARIZED_STONE;

    public AbilityMagnetic() {
        super("magnetic");
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        if (this.abilityEnabled()) {
            this.collectDrops(entity);
        }
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int itemSlot, boolean inHand) {
        Capabilities.getTrinketProperties(stack, prop -> this.toggleAbility(prop.mainAbility()));
    }

    public void collectDrops(EntityLivingBase entity) {
        Predicate filter = Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)EntitySelectors.field_94557_a);
        boolean flag = filter.apply((Object)entity);
        if (flag) {
            AxisAlignedBB bBox = entity.func_174813_aQ();
            Predicate lootPredicate = Predicates.and((Predicate)EntitySelectors.field_94557_a, ent -> ent instanceof EntityItem || ent instanceof EntityXPOrb && AbilityMagnetic.serverConfig.collectXP);
            Predicate otherPlayerPredicate = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_188444_d, EntitySelectors.field_94557_a, ent -> {
                if (ent == null || entity == ent || entity.func_145782_y() == ent.func_145782_y()) {
                    return false;
                }
                return ent.func_184614_ca().func_77973_b() instanceof TrinketPolarized || TrinketHelper.AccessoryCheck((EntityLivingBase)ent, ModItems.trinkets.TrinketPolarized);
            }});
            List Loot = entity.field_70170_p.func_175647_a(Entity.class, bBox.func_72314_b((double)AbilityMagnetic.serverConfig.PR.HD, (double)AbilityMagnetic.serverConfig.PR.VD, (double)AbilityMagnetic.serverConfig.PR.HD), lootPredicate);
            List others = entity.field_70170_p.func_175647_a(EntityPlayer.class, bBox.func_72314_b((double)AbilityMagnetic.serverConfig.PR.HD, (double)AbilityMagnetic.serverConfig.PR.VD, (double)AbilityMagnetic.serverConfig.PR.HD), otherPlayerPredicate);
            for (Entity loot : Loot) {
                double distance = loot.func_70011_f(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                boolean someonesCloser = false;
                for (EntityPlayer otherP : others) {
                    float dist = loot.func_70032_d((Entity)otherP);
                    if (!((double)dist < distance)) continue;
                    someonesCloser = true;
                }
                if (someonesCloser) continue;
                this.handleLoot((Entity)entity, loot);
            }
        }
    }

    private void handleLoot(Entity entity, Entity drop) {
        if (drop instanceof EntityItem || AbilityMagnetic.serverConfig.collectXP && drop instanceof EntityXPOrb) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!player.field_70170_p.field_72995_K) {
                    if (drop instanceof EntityItem) {
                        if (AbilityMagnetic.serverConfig.instant_pickup) {
                            this.pickupItem(player, drop);
                        } else {
                            this.pull(drop, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        }
                    } else if (AbilityMagnetic.serverConfig.collectXP && drop instanceof EntityXPOrb) {
                        if (AbilityMagnetic.serverConfig.instant_xp) {
                            this.pickupXP(player, drop);
                        } else {
                            this.pull(drop, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        }
                    } else {
                        this.pull(drop, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    }
                }
            } else {
                this.pull(drop, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
        }
    }

    private void pickupItem(EntityPlayer player, Entity itemEntity) {
        EntityItem item;
        if (itemEntity instanceof EntityItem && !((item = (EntityItem)itemEntity).func_92059_d().func_77973_b() instanceof TrinketPolarized)) {
            item.func_70100_b_(player);
        }
    }

    private void pickupXP(EntityPlayer player, Entity xpOrb) {
        if (xpOrb instanceof EntityXPOrb) {
            EntityXPOrb xp = (EntityXPOrb)xpOrb;
            player.field_71090_bL = 0;
            xp.func_70100_b_(player);
        }
    }

    public ItemStack getEnchantedItem(Enchantment enchantment, EntityLivingBase entity) {
        List list = enchantment.func_185260_a(entity);
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ArrayList list1 = Lists.newArrayList();
        for (ItemStack itemstack : list) {
            if (itemstack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemstack) <= 0) continue;
            list1.add(itemstack);
        }
        return list1.isEmpty() ? ItemStack.field_190927_a : (ItemStack)list1.get(entity.func_70681_au().nextInt(list1.size()));
    }

    public List<ItemStack> getEnchantedItems(Enchantment enchantment, EntityLivingBase entity) {
        List list = enchantment.func_185260_a(entity);
        ArrayList list1 = Lists.newArrayList();
        for (ItemStack itemstack : list) {
            if (itemstack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemstack) <= 0) continue;
            list1.add(itemstack);
        }
        return list1;
    }

    protected int roundAverage(float value) {
        double floor = Math.floor(value);
        return (int)floor + (Math.random() < (double)value - floor ? 1 : 0);
    }

    protected void pull(Entity ent, double x, double y, double z) {
        double dZ;
        double dY;
        double spd = TrinketsConfig.SERVER.Items.POLARIZED_STONE.Polarized_Stone_Speed;
        double dX = x - 0.5 - (double)ent.func_180425_c().func_177958_n();
        double dist = Math.sqrt(dX * dX + (dY = y - (double)ent.func_180425_c().func_177956_o()) * dY + (dZ = z - 0.5 - (double)ent.func_180425_c().func_177952_p()) * dZ);
        double vel = 1.0 - dist / 15.0;
        if (vel > 0.0 && vel < 0.95) {
            vel *= vel;
            ent.field_70159_w += dX / dist * vel * (spd * MathHelper.func_151237_a((double)(dist - 0.5), (double)0.0, (double)1.0));
            ent.field_70181_x += dY / dist * vel * (spd * 1.25 * MathHelper.func_151237_a((double)(dist - 0.5), (double)0.0, (double)1.0));
            ent.field_70179_y += dZ / dist * vel * (spd * MathHelper.func_151237_a((double)(dist - 0.5), (double)0.0, (double)1.0));
        }
    }

    protected void push(Entity ent, double x, double y, double z) {
        double spd = TrinketsConfig.SERVER.Items.POLARIZED_STONE.Polarized_Stone_Speed;
        double dX = x - ent.field_70165_t;
        double dY = y - ent.field_70163_u;
        double dZ = z - ent.field_70161_v;
        double dist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double vel = 1.0 - dist / 15.0;
        if (vel > 0.0) {
            vel *= vel;
            ent.field_70159_w -= dX / dist * vel * spd;
            ent.field_70181_x -= dY / dist * vel * spd;
            ent.field_70179_y -= dZ / dist * vel * spd;
        }
    }

    @Override
    public boolean abilityEnabled() {
        return this.enabled;
    }

    @Override
    public IToggleAbility toggleAbility(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public IToggleAbility toggleAbility(int value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        if (!Aux) {
            boolean enabled = this.abilityEnabled();
            boolean client = entity.field_70170_p.field_72995_K;
            this.toggleAbility(!enabled);
            if (client && entity instanceof EntityPlayer) {
                TranslationHelper helper = TranslationHelper.INSTANCE;
                ItemStack s = new ItemStack(ModItems.trinkets.TrinketPolarized);
                String magnetMode = new TextComponentTranslation(s.func_77977_a() + ".magnetmode", new Object[0]).func_150254_d();
                TranslationHelper.OptionEntry key = new TranslationHelper.OptionEntry("collecttoggle", AbilityMagnetic.serverConfig.collectXP, helper.toggleCheckTranslation(!enabled));
                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(helper.formatAddVariables(magnetMode, key)), true);
            }
            Capabilities.getEntityProperties(entity, prop -> {
                ItemStack stack;
                TrinketHelper.SlotInformation info;
                AbilityHandler.AbilityHolder holder = prop.getAbilityHandler().getAbilityHolder(this.getRegistryName().toString());
                TrinketHelper.SlotInformation slotInformation = info = holder != null ? holder.getInfo() : null;
                if (info != null && entity instanceof EntityLivingBase && (stack = info.getStackFromHandler((EntityLivingBase)entity)).func_77973_b() instanceof TrinketPolarized) {
                    Capabilities.getTrinketProperties(stack, cap -> {
                        cap.toggleMainAbility(this.abilityEnabled());
                        cap.sendInformationToPlayer((EntityLivingBase)entity, (EntityLivingBase)((EntityPlayer)entity));
                    });
                }
            });
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        return ModKeyBindings.POLARIZED_STONE_ABILITY.getDisplayName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getAuxKey() {
        return ModKeyBindings.AUX_KEY.getDisplayName();
    }

    @Override
    public NBTTagCompound saveStorage(NBTTagCompound compound) {
        compound.func_74757_a("enabled", this.enabled);
        return compound;
    }

    @Override
    public void loadStorage(NBTTagCompound compound) {
        if (compound.func_74764_b("enabled")) {
            this.enabled = compound.func_74767_n("enabled");
        }
    }
}

