/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.handlers.Counter;
import xzeroair.trinkets.util.helpers.PotionHelper;

public class AbilityFlying
extends Ability
implements ITickableAbility,
IPotionAbility,
IMiningAbility {
    protected boolean flightEnabled = false;
    protected boolean speedModified = false;
    protected float speed = 0.05f;
    protected float currentSpeed = 0.05f;
    protected float cost = 0.0f;
    protected boolean selfAdded = false;
    protected boolean selfSpeedModified = false;

    public AbilityFlying() {
        super("creative_flight");
    }

    public AbilityFlying(boolean enabled, boolean speedmodified, float speed, float cost) {
        this();
        this.flightEnabled = enabled;
        this.speedModified = speedmodified;
        this.speed = speed;
        this.cost = cost;
    }

    public AbilityFlying setFlightEnabled(boolean enabled) {
        if (this.flightEnabled != enabled) {
            this.flightEnabled = enabled;
        }
        return this;
    }

    public AbilityFlying setSpeedEnabled(boolean enabled) {
        if (this.speedModified != enabled) {
            this.speedModified = enabled;
        }
        return this;
    }

    public AbilityFlying setFlightSpeed(float speed) {
        if (this.speed != speed) {
            this.speed = speed;
        }
        return this;
    }

    public AbilityFlying setFlightCost(float cost) {
        if (this.cost != cost) {
            this.cost = cost;
        }
        return this;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.isCreativePlayer(player)) {
                boolean flag = Capabilities.getEntityProperties((Entity)player, true, (prop, canFly) -> prop.getRaceHandler().canFly());
                if (this.flightEnabled && flag) {
                    this.addFlyingAbility(player);
                } else {
                    this.removeCreativeFlight(player);
                }
            }
            this.handleSpeed(player);
        }
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        if (effect.func_188419_a().getRegistryName().toString().contentEquals("minecraft:levitation")) {
            return true;
        }
        return cancel;
    }

    @Override
    public float breakingBlock(EntityLivingBase entity, IBlockState state, BlockPos pos, float originalSpeed, float newSpeed) {
        if (!entity.func_70055_a(Material.field_151586_h)) {
            float speed = originalSpeed;
            if (!entity.field_70122_E) {
                speed *= 5.0f;
            }
            if (newSpeed < speed) {
                return speed;
            }
        }
        return newSpeed;
    }

    protected boolean setFlyingSpeed(EntityPlayer player, float flightSpeed) {
        float flySpeed;
        if (player.field_70170_p.field_72995_K && (flySpeed = player.field_71075_bZ.func_75093_a()) != flightSpeed && !Float.isNaN(flightSpeed)) {
            player.field_71075_bZ.func_75092_a(flightSpeed);
            return true;
        }
        return false;
    }

    protected void handleSpeed(EntityPlayer player) {
        float newSpeed;
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        boolean flying = player.field_71075_bZ.field_75100_b;
        float defaultSpeed = 0.05f;
        if (!flying) {
            if (this.selfSpeedModified && this.setFlyingSpeed(player, 0.05f)) {
                this.selfSpeedModified = false;
            }
            return;
        }
        float flySpeed = player.field_71075_bZ.func_75093_a();
        if ((!this.selfSpeedModified || this.currentSpeed != flySpeed) && this.setFlyingSpeed(player, newSpeed = Math.max(flySpeed - 0.05f + this.speed, 0.0f))) {
            this.currentSpeed = newSpeed;
            if (!this.selfSpeedModified) {
                this.selfSpeedModified = true;
            }
        }
    }

    protected void addFlyingAbility(EntityPlayer player) {
        if (this.isCreativePlayer(player)) {
            return;
        }
        if (this.cost <= 0.0f) {
            this.giveCreativeFlight(player);
            if (this.selfAdded && player.field_71075_bZ.field_75100_b) {
                player.field_70143_R = 0.0f;
            }
        } else {
            MagicStats magic = Capabilities.getMagicStats((Entity)player);
            if (magic != null) {
                float mp = magic.getMana();
                if (mp >= this.cost) {
                    this.giveCreativeFlight(player);
                } else if (this.selfAdded) {
                    this.removeCreativeFlight(player);
                }
                if (PotionHelper.isModPotionActive((EntityLivingBase)player, "potioncore", "flight")) {
                    return;
                }
                if (this.selfAdded && player.field_71075_bZ.field_75100_b) {
                    Counter counter;
                    player.field_70143_R = 0.0f;
                    if (!player.func_184218_aH() && (counter = this.tickHandler.getCounter("fly_timer", 20, true, true, true, true)) != null && counter.Tick() && !magic.spendMana(this.cost)) {
                        this.removeCreativeFlight(player);
                    }
                }
            }
        }
    }

    @Override
    public void onAbilityRemoved(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.isCreativePlayer(player)) {
                this.removeCreativeFlight(player);
            }
            this.setFlyingSpeed(player, 0.05f);
        }
        this.tickHandler.removeCounter("fly_timer");
    }

    private void removeCreativeFlight(EntityPlayer player) {
        if (this.selfAdded) {
            this.selfAdded = false;
        }
        if (PotionHelper.isModPotionActive((EntityLivingBase)player, "potioncore", "flight")) {
            return;
        }
        if (player.field_71075_bZ.field_75101_c) {
            player.field_71075_bZ.field_75101_c = false;
            if (player.field_71075_bZ.field_75100_b) {
                player.field_70143_R = 0.0f;
                player.field_71075_bZ.field_75100_b = false;
            }
            if (player instanceof EntityPlayerMP) {
                player.func_71016_p();
            }
        }
    }

    private void giveCreativeFlight(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75101_c) {
            player.field_71075_bZ.field_75101_c = true;
            this.selfAdded = true;
            if (player instanceof EntityPlayerMP) {
                player.func_71016_p();
            }
        }
    }
}

