/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.client.particles.ParticleGreed;
import xzeroair.trinkets.enums.TargetOreType;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IKeyBindInterface;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IToggleAbility;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.OreDictionaryCompat;
import xzeroair.trinkets.util.config.ClientConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.config.trinkets.ConfigDragonsEye;
import xzeroair.trinkets.util.handlers.Counter;
import xzeroair.trinkets.util.helpers.RayTraceHelper;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class AbilityBlockFinder
extends Ability
implements ITickableAbility,
IToggleAbility,
IKeyBindInterface {
    protected final ConfigDragonsEye serverConfig;
    protected final ClientConfig.ClientConfigItems.ClientConfigDragonsEye clientConfig;
    protected boolean firstTick;
    private int targetValue;

    public AbilityBlockFinder() {
        super("block_detection");
        this.serverConfig = TrinketsConfig.SERVER.Items.DRAGON_EYE;
        this.clientConfig = TrinketsConfig.CLIENT.items.DRAGON_EYE;
        this.firstTick = false;
        this.targetValue = -1;
        this.firstTick = true;
    }

    public int getTargetValue() {
        return this.targetValue;
    }

    @Override
    public boolean abilityEnabled() {
        return this.targetValue > 0;
    }

    @Override
    public IToggleAbility toggleAbility(boolean enabled) {
        return this;
    }

    @Override
    public IToggleAbility toggleAbility(int value) {
        this.targetValue = value;
        return this;
    }

    protected void IterateBlocks(EntityLivingBase entity, Vec3d origin, World world, AxisAlignedBB aabb) {
        block16: {
            int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
            int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
            int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
            int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
            int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
            int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
            boolean closest = this.serverConfig.BLOCKS.closest;
            TreeMap<Double, Object> collection = new TreeMap<Double, Object>();
            ConfigHelper.TreasureEntry treasure = this.getTreasure();
            if (treasure == null) {
                return;
            }
            if (treasure.getObjectRegistryName().contentEquals("*:*")) {
                return;
            }
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        Vec3d pos = new Vec3d((double)k1, (double)l1, (double)i2);
                        BlockPos bPos = new BlockPos(pos);
                        IBlockState state = world.func_180495_p(bPos);
                        Block block = state.func_177230_c();
                        if (block.isAir(state, (IBlockAccess)world, bPos) || !treasure.doesBlockMatchEntry(state)) continue;
                        double blockDist = pos.func_72438_d(origin);
                        collection.put(blockDist, pos);
                    }
                }
            }
            try {
                List entList;
                Class e;
                ResourceLocation isEntityRegName = new ResourceLocation(treasure.getObjectRegistryName());
                if (EntityList.func_180125_b((ResourceLocation)isEntityRegName) && (e = EntityList.getClass((ResourceLocation)isEntityRegName)) != null && !(entList = world.func_72872_a(e, aabb)).isEmpty()) {
                    for (Entity targetEntity : entList) {
                        Vec3d pos = targetEntity.func_174791_d();
                        double chestDist = pos.func_72438_d(origin);
                        collection.put(chestDist, pos);
                    }
                }
            }
            catch (Exception isEntityRegName) {
                // empty catch block
            }
            if (collection.isEmpty() || !world.field_72995_K) break block16;
            Map.Entry first = collection.firstEntry();
            double distance = (Double)first.getKey();
            if ((Double)first.getKey() > 1.8) {
                this.playSound(entity, new BlockPos((Vec3d)first.getValue()), distance);
            }
            if (closest) {
                for (int p1 = 0; p1 < 3; ++p1) {
                    this.SpawnParticle(entity.func_130014_f_(), (Vec3d)first.getValue(), treasure.getColor());
                }
            } else {
                int particleCount = 0;
                for (Map.Entry e : collection.entrySet()) {
                    if (particleCount < this.clientConfig.Particles_Max) {
                        for (int p1 = 0; p1 < 3; ++p1) {
                            this.SpawnParticle(entity.func_130014_f_(), (Vec3d)e.getValue(), treasure.getColor());
                            ++particleCount;
                        }
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        if (this.serverConfig.oreFinder) {
            int length = this.serverConfig.BLOCKS.Blocks.length;
            World world = entity.func_130014_f_();
            if (this.targetValue > length) {
                this.targetValue = -1;
            }
            if (this.targetValue < 0) {
                return;
            }
            int vd = this.serverConfig.BLOCKS.DR.C00_VD;
            int hd = this.serverConfig.BLOCKS.DR.C001_HD;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_72314_b((double)hd, (double)vd, (double)hd);
            int rf = this.clientConfig.Render_Cooldown;
            Counter counter = this.tickHandler.getCounter("refresh_rate", rf, true, true, true, false);
            if (this.firstTick || counter.Tick()) {
                this.firstTick = false;
                this.IterateBlocks(entity, entity.func_174791_d(), world, aabb);
            }
        }
    }

    public ConfigHelper.TreasureEntry getTreasure() {
        TreeMap<Integer, ConfigHelper.TreasureEntry> TreasureBlocks = ConfigHelper.TrinketConfigStorage.TreasureBlocks;
        return TreasureBlocks.get(this.targetValue);
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawPath(EntityLivingBase player, Vec3d target, int color) {
        double d = player.func_70011_f(target.field_72450_a, target.field_72448_b, target.field_72449_c);
        if (d > 2.0) {
            RayTraceHelper.Beam beam = new RayTraceHelper.Beam(player.field_70170_p, player, d, 1.0, false);
            GlStateManager.func_179094_E();
            RayTraceHelper.drawPath(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e() * 0.8, 0.0), target, player.field_70170_p, beam, color, 2.0);
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void SpawnParticle(World world, Vec3d pos, int color) {
        double X = Reference.random.nextDouble() + pos.field_72450_a;
        double Y = Reference.random.nextDouble() + pos.field_72448_b;
        double Z = Reference.random.nextDouble() + pos.field_72449_c;
        GlStateManager.func_179094_E();
        ParticleGreed effect = new ParticleGreed(world, new Vec3d(X, Y, Z), color, 1.0f, false);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)effect);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    protected void playSound(EntityLivingBase entity, BlockPos pos, double distance) {
        if (this.clientConfig.Dragon_Growl && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean sneaking = this.clientConfig.Dragon_Growl_Sneak.contentEquals("SNEAK") && player.func_70093_af();
            boolean standing = this.clientConfig.Dragon_Growl_Sneak.contentEquals("STAND") && !player.func_70093_af();
            boolean both = this.clientConfig.Dragon_Growl_Sneak.contentEquals("BOTH");
            float configVolume = this.clientConfig.Dragon_Growl_Volume;
            float volume = configVolume / 100.0f;
            int drH = this.serverConfig.BLOCKS.DR.C001_HD;
            int drV = this.serverConfig.BLOCKS.DR.C00_VD;
            double test = MathHelper.func_76129_c((float)(drH * drH + drV * drV));
            if (test <= 0.0) {
                test = 1.0;
            }
            if (sneaking && !standing || standing && !sneaking || both) {
                float v = 1.0f;
                try {
                    v = (float)(1.0 - distance / test);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pos != null) {
                    player.field_70170_p.func_184133_a(player, pos, SoundEvents.field_187525_aO, SoundCategory.PLAYERS, v * volume, 1.0f);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        String kb = ModKeyBindings.DRAGONS_EYE_TARGET.getDisplayName();
        return kb;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getAuxKey() {
        return ModKeyBindings.AUX_KEY.getDisplayName();
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        if (TrinketsConfig.SERVER.Items.DRAGON_EYE.oreFinder) {
            int size = TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.Blocks.length;
            int off = -1;
            int max = size - 1;
            this.targetValue = !Aux ? ++this.targetValue : --this.targetValue;
            if (this.targetValue >= size) {
                this.targetValue = -1;
            } else if (this.targetValue < -1) {
                this.targetValue = max;
            }
            if (entity instanceof EntityPlayer && entity.field_70170_p.field_72995_K) {
                TranslationHelper helper = TranslationHelper.INSTANCE;
                ItemStack stack = new ItemStack(ModItems.trinkets.TrinketDragonsEye);
                EntityPlayer player = (EntityPlayer)entity;
                if (this.targetValue != -1) {
                    ConfigHelper.TreasureEntry entry = this.getTreasure();
                    String target = this.parseTargetName(entry).trim();
                    String entryRegName = entry == null ? "NULL" : entry.getObjectRegistryName();
                    String NotFound = helper.formatAddVariables(new TextComponentTranslation(stack.func_77977_a() + ".treasurefinder.notfound", new Object[0]).func_150254_d(), new TranslationHelper.OptionEntry("target", true, entryRegName), new TranslationHelper.OptionEntry("looking", true, helper.toggleCheckTranslation(true)));
                    String FoundTarget = helper.formatAddVariables(new TextComponentTranslation(stack.func_77977_a() + ".treasurefinder.on", new Object[0]).func_150254_d(), new TranslationHelper.OptionEntry("target", true, target), new TranslationHelper.OptionEntry("looking", true, helper.toggleCheckTranslation(true)));
                    String Message = target.isEmpty() ? NotFound : FoundTarget;
                    player.func_146105_b((ITextComponent)new TextComponentString(Message), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(helper.formatAddVariables(new TextComponentTranslation(stack.func_77977_a() + ".treasurefinder.off", new Object[0]).func_150254_d(), new TranslationHelper.OptionEntry("looking", true, helper.toggleCheckTranslation(false)))), true);
                }
            }
            return true;
        }
        return false;
    }

    public String parseTargetName(ConfigHelper.TreasureEntry treasure) {
        block16: {
            if (treasure == null) {
                return "";
            }
            try {
                String target = treasure.getObjectRegistryName();
                if (treasure.getObjectType() == ConfigHelper.EntryType.OREDICTIONARY) {
                    return target.replaceFirst("oreDict:", "").replaceAll("(([ ]?[oO][rR][eE])|([\\[\\]])|([tT][iI][lL][eE][\\.]))", "");
                }
                if (treasure.getObjectType() == ConfigHelper.EntryType.ENTITY) {
                    try {
                        ResourceLocation t = new ResourceLocation(target);
                        if (EntityList.func_180125_b((ResourceLocation)t)) {
                            return new TextComponentTranslation("entity." + EntityList.func_191302_a((ResourceLocation)t) + ".name", new Object[0]).func_150254_d();
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block16;
                }
                if (treasure.getObjectType() == ConfigHelper.EntryType.MATERIAL) {
                    return "";
                }
                String namespace = treasure.getModID();
                String pathID = treasure.getObjectID();
                boolean isWildSpace = namespace.contentEquals("*");
                boolean isWildPath = pathID.contentEquals("*");
                int meta = treasure.getMeta();
                if (isWildSpace) {
                    if (isWildPath) {
                        return "";
                    }
                    return pathID;
                }
                if (isWildPath) {
                    return namespace + " " + new TextComponentTranslation("stat.blocksButton", new Object[0]).func_150254_d();
                }
                Item itemTarget = Item.func_111206_d((String)target);
                ItemStack parseName = new ItemStack(itemTarget, 1);
                if (itemTarget == null && Block.func_149684_b((String)target) != null) {
                    target = Block.func_149684_b((String)target).getRegistryName().toString();
                }
                target = parseName.func_151000_E().func_150260_c();
                if (itemTarget != null && itemTarget.func_77614_k() && meta != OreDictionaryCompat.wildcard) {
                    NonNullList parseMeta = NonNullList.func_191196_a();
                    itemTarget.func_150895_a(CreativeTabs.field_78027_g, parseMeta);
                    for (ItemStack t : parseMeta) {
                        if (t.func_77960_j() != meta) continue;
                        parseName = new ItemStack(itemTarget, 1, meta);
                        target = parseName.func_151000_E().func_150260_c();
                        break;
                    }
                }
                if (target.equalsIgnoreCase("[air]")) {
                    return "";
                }
                return target.replaceAll("(([ ]?[oO][rR][eE])|([\\[\\]])|([tT][iI][lL][eE][\\.]))", "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    protected int getColor(String name) {
        return TargetOreType.Color(name);
    }
}

