/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.dragon;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.dragon.config.DragonConfig;
import xzeroair.trinkets.traits.abilities.AbilityBlockFinder;
import xzeroair.trinkets.traits.abilities.AbilityFireBreathing;
import xzeroair.trinkets.traits.abilities.AbilityFireImmunity;
import xzeroair.trinkets.traits.abilities.AbilityFlying;
import xzeroair.trinkets.traits.abilities.AbilityNightVision;
import xzeroair.trinkets.traits.abilities.compat.survival.AbilityHeatImmunity;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.ColorHelper;
import xzeroair.trinkets.util.helpers.DrawingHelper;

public class RaceDragon
extends EntityRacePropertiesHandler {
    public static final DragonConfig serverConfig = TrinketsConfig.SERVER.races.dragon;
    public static final ResourceLocation TEXTURE = new ResourceLocation("xat:textures/dragon_wings.png");
    public static final ResourceLocation TEXTURE_ARMS = new ResourceLocation("xat:textures/dragon_wings_arms.png");
    public static final ResourceLocation TEXTURE_LEATHER = new ResourceLocation("xat:textures/dragon_wings_leather.png");
    protected int tick;
    protected int lastTick = 0;
    protected float armSwing = 0.0f;
    protected int wingFrames = 0;

    public RaceDragon(@Nonnull EntityLivingBase e) {
        super(e, EntityRaces.dragon);
    }

    @Override
    public void startTransformation() {
        this.addAbility(new AbilityNightVision().toggleAbility(true));
        if (RaceDragon.serverConfig.breath_damage > 0.0f) {
            this.addAbility(new AbilityFireBreathing());
        }
        if ((Trinkets.ToughAsNails || Trinkets.SimpleDifficulty) && RaceDragon.serverConfig.compat.tan.immuneToHeat) {
            this.addAbility(new AbilityHeatImmunity());
        }
        this.addAbility(new AbilityFireImmunity());
        if (TrinketsConfig.SERVER.Items.DRAGON_EYE.oreFinder) {
            this.addAbility(new AbilityBlockFinder());
        }
        if (RaceDragon.serverConfig.creative_flight) {
            this.addAbility(new AbilityFlying().setFlightEnabled(RaceDragon.serverConfig.creative_flight).setSpeedEnabled(RaceDragon.serverConfig.creative_flight_speed).setFlightSpeed((float)RaceDragon.serverConfig.flight_speed).setFlightCost(RaceDragon.serverConfig.flight_cost));
        }
    }

    @Override
    public void whileTransformed() {
        if (this.entity.field_70170_p.field_72995_K) {
            if (!this.entity.field_70122_E) {
                this.lastTick = this.tick;
                this.tick += 48;
            }
            if (this.tick >= 1210 || this.entity.field_70122_E) {
                this.tick = 0;
                this.lastTick = 0;
            }
        }
    }

    @Override
    public boolean canFly() {
        return super.canFly() && this.showTraits();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderLayer(RenderLivingBase renderer, boolean isFake, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!TrinketsConfig.CLIENT.rendering || !this.showTraits()) {
            return;
        }
        GlStateManager.func_179094_E();
        if (this.entity.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        if (renderer instanceof RenderPlayer) {
            RenderPlayer rend = (RenderPlayer)renderer;
            rend.func_177087_b().field_78115_e.func_78794_c(scale);
        }
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-2.0f, (float)0.0f);
        if (this.entity.func_190630_a(EntityEquipmentSlot.CHEST)) {
            GlStateManager.func_179109_b((float)-0.4f, (float)-1.0f, (float)0.0f);
        }
        int solidVariant = 2;
        int base = this.entity.field_70122_E ? 40 : 50;
        int wing = 20;
        int tip = -20;
        boolean rotX = false;
        int rotZ = -10;
        double[][] frames = new double[121][10];
        this.wingFrames = frames.length;
        float tickT = (float)this.lastTick + (float)(this.tick - this.lastTick) * partialTicks;
        int angleTick = (int)(tickT * 0.1f);
        this.getWingFrames(angleTick, base, 20.0, -20.0, 0.0, -10.0, frames);
        if (angleTick >= frames.length) {
            angleTick = frames.length - 1;
        }
        double x = -12.0;
        double y = isSlim ? -19.0 : -20.0;
        double z = 0.0;
        int width = 8;
        int height = 32;
        int uWidth = 16;
        int vHeight = 64;
        int texWidth = 64;
        int texHeight = 64;
        int innerWidth = 16;
        int innerHeight = 32;
        int innerUWidth = 32;
        int innerVHeight = 64;
        int innerTexWidth = 64;
        int innerTexHeight = 64;
        int outerwidth = 8;
        int outHeight = 32;
        int outerUWidth = 16;
        int outerVHeight = 64;
        int outerTexWidth = 64;
        int outerTexHeight = 64;
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        float[] rgb = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getAltTraitColor() : this.getTraitColor());
        float[] rgb2 = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getTraitColor() : this.getAltTraitColor());
        float alpha = 1.0f;
        GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
        GlStateManager.func_179114_b((float)((float)frames[angleTick][0]), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, -12.0, y, 0.0, 48.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_ARMS, -12.0, y, 0.0, 48.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_LEATHER, -12.0, y, 0.0, 48.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179137_b((double)-12.0, (double)y, (double)0.0);
        GlStateManager.func_179114_b((float)((float)frames[angleTick][1]), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)12.0, (double)(-y), (double)-0.0);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, -28.0, y, 0.0, 16.0f, 0.0f, 32, 64, 16.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_ARMS, -28.0, y, 0.0, 16.0f, 0.0f, 32, 64, 16.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_LEATHER, -28.0, y, 0.0, 16.0f, 0.0f, 32, 64, 16.0, 32.0, 64.0f, 64.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179137_b((double)-28.0, (double)y, (double)0.0);
        GlStateManager.func_179114_b((float)((float)(frames[angleTick][1] + (double)((float)frames[angleTick][2]))), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)28.0, (double)(-y), (double)-0.0);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, -36.0, y, 0.0, 0.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_ARMS, -36.0, y, 0.0, 0.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_LEATHER, -36.0, y, 0.0, 0.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
        GlStateManager.func_179114_b((float)((float)(-frames[angleTick][0])), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, -12.0, y, 0.0, 48.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_ARMS, -12.0, y, 0.0, 48.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_LEATHER, -12.0, y, 0.0, 48.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179137_b((double)-12.0, (double)y, (double)0.0);
        GlStateManager.func_179114_b((float)((float)(-frames[angleTick][1])), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)12.0, (double)(-y), (double)-0.0);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, -28.0, y, 0.0, 16.0f, 0.0f, 32, 64, 16.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_ARMS, -28.0, y, 0.0, 16.0f, 0.0f, 32, 64, 16.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_LEATHER, -28.0, y, 0.0, 16.0f, 0.0f, 32, 64, 16.0, 32.0, 64.0f, 64.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179137_b((double)-28.0, (double)y, (double)0.0);
        GlStateManager.func_179114_b((float)((float)(-(frames[angleTick][1] + (double)((float)frames[angleTick][2])))), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)28.0, (double)(-y), (double)-0.0);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, -36.0, y, 0.0, 0.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_ARMS, -36.0, y, 0.0, 0.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_LEATHER, -36.0, y, 0.0, 0.0f, 0.0f, 16, 64, 8.0, 32.0, 64.0f, 64.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private double[][] getWingFrames(int tickPos, double base, double wing, double tip, double rotX, double rotZ, double[][] frames) {
        frames[0] = new double[]{base, wing, tip, rotX, rotZ};
        int position = 1;
        int s = this.frames(15);
        for (int i1 = 0; i1 < s; ++i1) {
            frames[position][0] = base - (double)i1;
            frames[position][1] = wing - (double)i1;
            frames[position][2] = tip;
            frames[position][3] = rotX;
            frames[position][4] = rotZ;
            ++position;
        }
        int pos1 = position;
        int s1 = this.frames(10);
        for (int i1 = 0; i1 < s1; ++i1) {
            frames[position][0] = frames[pos1 - 1][0] - (double)i1;
            frames[position][1] = frames[pos1 - 1][1] - (double)i1;
            frames[position][2] = frames[pos1 - 1][2];
            frames[position][3] = frames[pos1 - 1][3];
            frames[position][4] = frames[pos1 - 1][4];
            ++position;
        }
        int pos2 = position;
        int s2 = this.frames(10);
        for (int i1 = 0; i1 < s2; ++i1) {
            frames[position][0] = frames[pos2 - 1][0];
            frames[position][1] = frames[pos2 - 1][1] + (double)i1;
            frames[position][2] = frames[pos2 - 1][2];
            frames[position][3] = frames[pos2 - 1][3] + (double)i1;
            frames[position][4] = frames[pos2 - 1][4] - (double)i1;
            ++position;
        }
        int pos3 = position;
        int s3 = this.frames(10);
        for (int i1 = 0; i1 < s3; ++i1) {
            frames[position][0] = frames[pos3 - 1][0] + (double)i1;
            frames[position][1] = frames[pos3 - 1][1] + (double)i1;
            frames[position][2] = frames[pos3 - 1][2];
            frames[position][3] = frames[pos3 - 1][3] + (double)i1;
            frames[position][4] = frames[pos3 - 1][4];
            ++position;
        }
        int pos4 = position;
        int s4 = this.frames(10);
        for (int i1 = 0; i1 < s4; ++i1) {
            frames[position][0] = frames[pos4 - 1][0] + (double)i1;
            frames[position][1] = frames[pos4 - 1][1] + (double)i1;
            frames[position][2] = frames[pos4 - 1][2];
            frames[position][3] = frames[pos4 - 1][3] + (double)i1;
            frames[position][4] = frames[pos4 - 1][4];
            ++position;
        }
        int pos5 = position;
        int s5 = this.frames(10);
        for (int i1 = 0; i1 < s5; ++i1) {
            frames[position][0] = frames[pos5 - 1][0] + (double)i1;
            frames[position][1] = frames[pos5 - 1][1] + (double)i1;
            frames[position][2] = frames[pos5 - 1][2];
            frames[position][3] = frames[pos5 - 1][3];
            frames[position][4] = frames[pos5 - 1][4];
            ++position;
        }
        int pos6 = position;
        int s6 = this.frames(10);
        for (int i1 = 0; i1 < s6; ++i1) {
            frames[position][0] = frames[pos6 - 1][0];
            frames[position][1] = frames[pos6 - 1][1] + (double)i1;
            frames[position][2] = frames[pos6 - 1][2];
            frames[position][3] = frames[pos6 - 1][3];
            frames[position][4] = frames[pos6 - 1][4];
            ++position;
        }
        int pos7 = position;
        int s7 = this.frames(10);
        for (int i1 = 0; i1 < s7; ++i1) {
            frames[position][0] = frames[pos7 - 1][0];
            frames[position][1] = frames[pos7 - 1][1] + (double)i1;
            frames[position][2] = frames[pos7 - 1][2] - (double)i1;
            frames[position][3] = frames[pos7 - 1][3];
            frames[position][4] = frames[pos7 - 1][4];
            ++position;
        }
        int pos8 = position;
        int s8 = this.frames(10);
        for (int i1 = 0; i1 < s8; ++i1) {
            frames[position][0] = frames[pos8 - 1][0];
            frames[position][1] = frames[pos8 - 1][1] - (double)i1;
            frames[position][2] = frames[pos8 - 1][2];
            frames[position][3] = frames[pos8 - 1][3] - (double)i1;
            frames[position][4] = frames[pos8 - 1][4] + (double)i1;
            ++position;
        }
        int pos9 = position;
        int s9 = this.frames(15);
        for (int i1 = 0; i1 < s9; ++i1) {
            frames[position][0] = frames[pos9 - 1][0];
            frames[position][1] = frames[pos9 - 1][1] - (double)i1;
            frames[position][2] = frames[pos9 - 1][2] - (double)i1;
            frames[position][3] = frames[pos9 - 1][3] - (double)i1;
            frames[position][4] = frames[pos9 - 1][4];
            ++position;
        }
        int pos10 = position;
        int s10 = this.frames(10);
        for (int i1 = 0; i1 < s10; ++i1) {
            frames[position][0] = frames[pos10 - 1][0];
            frames[position][1] = frames[pos10 - 1][1] - (double)i1;
            frames[position][2] = frames[pos10 - 1][2] + (double)i1;
            frames[position][3] = frames[pos10 - 1][3];
            frames[position][4] = frames[pos10 - 1][4];
            ++position;
        }
        return frames;
    }

    private double[][] section(int length, int position, int savedPos, int incBase, int incWing, int incTip, int incRotX, int incRotY, double[][] frames) {
        int sL = this.frames(length);
        for (int i1 = 0; i1 < sL; ++i1) {
            frames[position][0] = frames[savedPos - 1][0] + (double)incBase;
            frames[position][1] = frames[savedPos - 1][1] + (double)incWing;
            frames[position][2] = frames[savedPos - 1][2] + (double)incTip;
            frames[position][3] = frames[savedPos - 1][3] + (double)incRotX;
            frames[position][4] = frames[savedPos - 1][4] + (double)incRotY;
        }
        return frames;
    }

    private int frames(int amount) {
        if (this.wingFrames - amount >= 0) {
            this.wingFrames -= amount;
            return amount;
        }
        if (this.wingFrames > 0) {
            return this.wingFrames;
        }
        return 0;
    }
}

