/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.handlers.SizeHandler;
import xzeroair.trinkets.util.helpers.AttributeHelper;

public class EmptyHandler
extends EntityRacePropertiesHandler {
    public EmptyHandler(EntityLivingBase e) {
        this(e, EntityRaces.none);
    }

    public EmptyHandler(EntityLivingBase e, EntityRace race) {
        super(e, race);
    }

    @Override
    public void startTransformation() {
    }

    @Override
    public void endTransformation() {
    }

    @Override
    protected void initAttributes() {
        String[] raceAttributes;
        EntityRace previous = this.getEntityProperties().getPreviousRace();
        double d = Double.parseDouble(Reference.DECIMALFORMAT.format(1.0 - this.TransformationProgress()));
        if (d != 0.0 && (raceAttributes = previous.getRaceAttributes().getAttributes()).length > 0) {
            for (String entry : raceAttributes) {
                ConfigHelper.AttributeEntry attributeShell = ConfigHelper.getAttributeEntry(entry);
                if (attributeShell == null) continue;
                String name = attributeShell.getAttribute();
                double amount = attributeShell.getAmount();
                int operation = attributeShell.getOperation();
                boolean isSaved = attributeShell.isSaved();
                UpdatingAttribute attribute = new UpdatingAttribute(previous.getName() + "." + name, previous.getUUID(), name).setSavedInNBT(false);
                attribute.addModifier(this.entity, amount * d, operation);
            }
        }
    }

    @Override
    public void onTick() {
        if (this.entity instanceof EntityPlayer) {
            if (this.isTransforming()) {
                SizeHandler.setSize(this.entity, this.getHeight(), this.getWidth());
                this.updateSize();
                this.initAttributes();
                this.eyeHeightHandler();
            } else if (this.firstTransformUpdate) {
                EntityRace previous = this.getEntityProperties().getPreviousRace();
                AttributeHelper.removeAttributesByUUID(this.entity, previous.getUUID());
                ((EntityPlayer)this.entity).eyeHeight = ((EntityPlayer)this.entity).getDefaultEyeHeight();
                this.firstTransformUpdate = false;
            }
        } else if (this.isTransforming()) {
            this.updateSize();
            this.eyeHeightHandler();
        } else if (this.firstTransformUpdate) {
            float height = this.getEntityProperties().getDefaultHeight();
            float width = this.getEntityProperties().getDefaultWidth();
            SizeHandler.setSize(this.entity, height, width);
            this.firstTransformUpdate = false;
        }
    }

    @Override
    public void interact(PlayerInteractEvent event) {
    }

    @Override
    public boolean isTransformed() {
        return false;
    }
}

