/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network.configsync;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import xzeroair.trinkets.network.ThreadSafePacket;
import xzeroair.trinkets.util.TrinketsConfig;

public class PacketConfigSync
extends ThreadSafePacket {
    Map<String, String> map;
    int size;

    public PacketConfigSync() {
    }

    public PacketConfigSync(Map<String, String> configMap) {
        if (configMap != null && !configMap.isEmpty()) {
            this.map = configMap;
            this.size = this.map.size();
        } else {
            this.map = new HashMap<String, String>();
            this.size = 0;
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.size);
        for (Map.Entry<String, String> config : this.map.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)config.getKey());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)config.getValue());
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.size = buffer.readInt();
        if (this.size > 0) {
            this.map = new HashMap<String, String>();
            for (int i = 0; i < this.size; ++i) {
                String key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                String value = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                this.map.put(key, value);
            }
        }
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient client) {
        TrinketsConfig.readConfigMap(this.map);
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer server) {
    }
}

