/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.AbilityMagnetic;
import xzeroair.trinkets.traits.abilities.AbilityRepel;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IToggleAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigPolarizedStone;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class TrinketPolarized
extends AccessoryBase {
    public static final ConfigPolarizedStone serverConfig = TrinketsConfig.SERVER.Items.POLARIZED_STONE;

    public TrinketPolarized(String name) {
        super(name);
        this.setUUID("1ed98d9e-3075-45e0-b6f7-fcdff24caed4");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String customItemInformation(ItemStack stack, World world, ITooltipFlag flagIn, int index, String translation) {
        TranslationHelper helper = TranslationHelper.INSTANCE;
        TranslationHelper.LangEntry key = new TranslationHelper.LangEntry(this.func_77667_c(stack), "collect");
        TranslationHelper.LangEntry key1 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "collectxp", TrinketPolarized.serverConfig.collectXP);
        TranslationHelper.LangEntry key2 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "repel", TrinketPolarized.serverConfig.repell);
        TrinketProperties prop = Capabilities.getTrinketProperties(stack);
        boolean main = prop == null ? false : prop.mainAbility();
        boolean alt = prop == null ? false : prop.altAbility();
        TranslationHelper.OptionEntry key3 = new TranslationHelper.OptionEntry("collecttoggle", TrinketPolarized.serverConfig.collectXP, helper.toggleCheckTranslation(main));
        TranslationHelper.OptionEntry key4 = new TranslationHelper.OptionEntry("repeltoggle", TrinketPolarized.serverConfig.repell, helper.toggleCheckTranslation(alt));
        TranslationHelper.KeyBindEntry key5 = new TranslationHelper.KeyBindEntry("magnetkb", ModKeyBindings.POLARIZED_STONE_ABILITY.getDisplayName());
        TranslationHelper.KeyBindEntry key6 = new TranslationHelper.KeyBindEntry("auxkb", ModKeyBindings.AUX_KEY.getDisplayName());
        return helper.formatAddVariables(translation, key, key1, key2, key3, key4, key5, key6);
    }

    @Override
    public String[] getAttributeConfig() {
        return TrinketPolarized.serverConfig.attributes;
    }

    @Override
    public void initAbilities(ItemStack stack, EntityLivingBase entity, List<IAbilityInterface> abilities) {
        abilities.add(new AbilityMagnetic());
        if (TrinketPolarized.serverConfig.repell) {
            abilities.add(new AbilityRepel());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        boolean client = player.field_70170_p.field_72995_K;
        boolean sneak = player.func_70093_af();
        TrinketProperties prop = Capabilities.getTrinketProperties(stack);
        if (prop != null) {
            EntityProperties entityProps = Capabilities.getEntityProperties((Entity)player);
            TranslationHelper helper = TranslationHelper.INSTANCE;
            if (!sneak) {
                boolean toggle = prop.mainAbility();
                if (client) {
                    String magnetMode = new TextComponentTranslation(stack.func_77977_a() + ".magnetmode", new Object[0]).func_150254_d();
                    TranslationHelper.OptionEntry key = new TranslationHelper.OptionEntry("collecttoggle", TrinketPolarized.serverConfig.collectXP, helper.toggleCheckTranslation(!toggle));
                    player.func_146105_b((ITextComponent)new TextComponentString(helper.formatAddVariables(magnetMode, key)), true);
                }
                Capabilities.getEntityProperties((Entity)player, props -> {
                    IAbilityInterface ability;
                    AbilityHandler.AbilityHolder magnet;
                    if (entityProps != null && (magnet = entityProps.getAbilityHandler().getAbilityHolder("xat:magnetic")) != null && this.getRegistryName().toString().contentEquals(magnet.getSourceID()) && (ability = magnet.getAbility()) instanceof IToggleAbility) {
                        ((IToggleAbility)ability).toggleAbility(!toggle);
                    }
                });
                prop.toggleMainAbility(!toggle);
            } else {
                boolean toggle = prop.altAbility();
                if (client) {
                    String repelMode = new TextComponentTranslation(stack.func_77977_a() + ".repelmode", new Object[0]).func_150254_d();
                    TranslationHelper.OptionEntry key = new TranslationHelper.OptionEntry("repeltoggle", TrinketPolarized.serverConfig.repell, helper.toggleCheckTranslation(!toggle));
                    player.func_146105_b((ITextComponent)new TextComponentString(helper.formatAddVariables(repelMode, key)), true);
                }
                Capabilities.getEntityProperties((Entity)player, props -> {
                    IAbilityInterface ability;
                    AbilityHandler.AbilityHolder repel;
                    if (entityProps != null && (repel = entityProps.getAbilityHandler().getAbilityHolder("xat:repel")) != null && this.getRegistryName().toString().contentEquals(repel.getSourceID()) && (ability = repel.getAbility()) instanceof IToggleAbility) {
                        ((IToggleAbility)ability).toggleAbility(!toggle);
                    }
                });
                prop.toggleAltAbility(!toggle);
            }
        }
        player.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(handIn));
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation normal = new ModelResourceLocation(this.getRegistryName().toString(), "inventory");
        ModelResourceLocation magnet = new ModelResourceLocation(this.getRegistryName().toString() + "_magnet", "inventory");
        ModelResourceLocation repel = new ModelResourceLocation(this.getRegistryName().toString() + "_repell", "inventory");
        ModelResourceLocation both = new ModelResourceLocation(this.getRegistryName().toString() + "_both", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{normal, magnet, repel, both});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            boolean alt;
            TrinketProperties prop = Capabilities.getTrinketProperties(stack);
            boolean main = prop != null && prop.mainAbility();
            boolean bl = alt = prop != null && prop.altAbility();
            if (main && alt) {
                return both;
            }
            if (main) {
                return magnet;
            }
            if (alt) {
                return repel;
            }
            return normal;
        });
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketPolarized.serverConfig.enabled;
    }
}

