/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.init;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.base.BasePotion;
import xzeroair.trinkets.items.potions.IceResistance;
import xzeroair.trinkets.items.potions.LightningResistance;
import xzeroair.trinkets.items.potions.PotionObject;
import xzeroair.trinkets.items.potions.TransformationPotion;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.StringUtils;

public class ModPotionTypes {
    public static final String baseSparkling = "sparkling";
    public static final String enhancedGlittering = "glittering";
    public static final String advancedGlowing = "glowing";
    public static final String restore = "restorative";
    public static final String iceResist = "ice_resistance";
    public static final String lightningResist = "lightning_resistance";
    public static HashMap<String, Potion> TrinketPotions = new HashMap();
    public static HashMap<String, PotionType> TrinketPotionTypes = new HashMap();
    public static HashMap<String, PotionObject> TrinketPotionObjects = new HashMap();
    public static HashMap<String, PotionObject> TrinketRacePotionObjects = new HashMap();

    protected static PotionObject createBasePotion(String potionName, int color, int duration, Ingredient craftingIngredient) {
        return ModPotionTypes.createBasePotion(potionName, color, duration, false, craftingIngredient);
    }

    protected static PotionObject createBasePotion(String potionName, int color, int duration, boolean isBadEffect, Ingredient craftingIngredient) {
        return ModPotionTypes.createBasePotion(potionName, color, duration, duration * 3, isBadEffect, craftingIngredient);
    }

    protected static PotionObject createBasePotion(String potionName, int color, int duration, int extendedDuration, Ingredient craftingIngredient) {
        return ModPotionTypes.createBasePotion(potionName, color, duration, extendedDuration, false, craftingIngredient);
    }

    protected static PotionObject createBasePotion(String potionName, int color, int duration, int extendedDuration, boolean isBadEffect, Ingredient craftingIngredient) {
        return ModPotionTypes.createBasePotion("xat", potionName, color, duration, extendedDuration, isBadEffect, craftingIngredient);
    }

    public static PotionObject createBasePotion(String modid, String potionName, int color, int duration, boolean isBadEffect, Ingredient craftingIngredient) {
        BasePotion potion = new BasePotion(potionName, color, duration, isBadEffect);
        return ModPotionTypes.getBasePotionObject(potion, modid, potionName, color, duration, craftingIngredient);
    }

    public static PotionObject createBasePotion(String modid, String potionName, int color, int duration, int extendedDuration, boolean isBadEffect, Ingredient craftingIngredient) {
        BasePotion potion = new BasePotion(potionName, color, duration, isBadEffect);
        return ModPotionTypes.getBasePotionObject(potion, modid, potionName, color, duration, extendedDuration, craftingIngredient);
    }

    public static PotionObject getBasePotionObject(Potion potionProduct, String modid, String potionName, int color, int duration, Ingredient craftingIngredient) {
        return ModPotionTypes.getBasePotionObject(potionProduct, modid, potionName, color, duration, duration * 3, craftingIngredient);
    }

    public static PotionObject getBasePotionObject(Potion potionProduct, String modid, String potionName, int color, int duration, int extendedDuration, Ingredient craftingIngredient) {
        PotionObject obj = new PotionObject(potionProduct, modid, potionName, color, duration, extendedDuration, craftingIngredient);
        boolean isInternal = modid.contentEquals("xat");
        if (isInternal) {
            TrinketPotionObjects.put(obj.getName(), obj);
        }
        return obj;
    }

    protected static PotionObject createCompoundPotion(PotionType craftingBase, String potionName, int color, int duration, Ingredient craftingIngredient) {
        BasePotion potion = new BasePotion(potionName, color, duration, false);
        return ModPotionTypes.createCompoundPotion(potion, craftingBase, "xat", potionName, color, duration, duration * 3, craftingIngredient);
    }

    protected static PotionObject createCompoundPotion(PotionType craftingBase, String potionName, int color, int duration, int extendedDuration, Ingredient craftingIngredient) {
        BasePotion potion = new BasePotion(potionName, color, duration, false);
        return ModPotionTypes.createCompoundPotion(potion, craftingBase, "xat", potionName, color, duration, extendedDuration, craftingIngredient);
    }

    protected static PotionObject createCompoundPotion(Potion potionProduct, PotionType craftingBase, String potionName, int color, int duration, Ingredient craftingIngredient) {
        return ModPotionTypes.createCompoundPotion(potionProduct, craftingBase, "xat", potionName, color, duration, duration * 3, craftingIngredient);
    }

    protected static PotionObject createCompoundPotion(Potion potionProduct, PotionType craftingBase, String potionName, int color, int duration, int extendedDuration, Ingredient craftingIngredient) {
        return ModPotionTypes.createCompoundPotion(potionProduct, craftingBase, "xat", potionName, color, duration, extendedDuration, craftingIngredient);
    }

    public static PotionObject createCompoundPotion(Potion potionProduct, PotionType craftingBase, String modid, String potionName, int color, int duration, Ingredient craftingIngredient) {
        return ModPotionTypes.createCompoundPotion(potionProduct, craftingBase, modid, potionName, color, duration, duration * 3, craftingIngredient);
    }

    public static PotionObject createCompoundPotion(Potion potionProduct, PotionType craftingBase, String modid, String potionName, int color, int duration, int extendedDuration, Ingredient craftingIngredient) {
        PotionObject obj = new PotionObject(potionProduct, craftingBase, modid, potionName, color, duration, extendedDuration, craftingIngredient);
        boolean isInternal = modid.contentEquals("xat");
        if (isInternal) {
            TrinketPotionObjects.put(obj.getName(), obj);
        }
        return obj;
    }

    public static PotionObject createRacePotion(EntityRace race, PotionType craftingBase, int duration, Ingredient craftingIngredient) {
        return ModPotionTypes.createRacePotion(race, craftingBase, duration, duration * 3, craftingIngredient);
    }

    public static PotionObject createRacePotion(EntityRace race, PotionType craftingBase, int duration, int extendedDuration, Ingredient craftingIngredient) {
        return ModPotionTypes.createRacePotion(race, craftingBase, duration, extendedDuration, false, craftingIngredient);
    }

    public static PotionObject createRacePotion(EntityRace race, PotionType craftingBase, int duration, int extendedDuration, boolean isBadEffect, Ingredient craftingIngredient) {
        String modid = race.getRegistryName().func_110624_b().toString().toLowerCase();
        String name = race.getRegistryName().func_110623_a().toString().toLowerCase();
        int color = race.getPrimaryColor();
        TransformationPotion potion = new TransformationPotion(modid, name, color, duration, race.getUUID().toString(), false);
        PotionObject obj = ModPotionTypes.createCompoundPotion(potion, craftingBase, modid, name, color, duration, extendedDuration, craftingIngredient);
        TrinketRacePotionObjects.put(obj.getName(), obj);
        return obj;
    }

    public static void registerPotionTypes() {
        Trinkets.log.info("Generating Potions");
        ModPotionTypes.createBasePotion(baseSparkling, 0xFFFFC8, 0, Ingredient.func_193367_a((Item)ModItems.crafting.glowing_powder)).registerWithPotion();
        ModPotionTypes.createCompoundPotion(TrinketPotionObjects.get(baseSparkling).getPotionType(), enhancedGlittering, 0xFFFFA0, 0, Ingredient.func_193367_a((Item)ModItems.crafting.glowing_ingot)).registerWithPotion();
        ModPotionTypes.createCompoundPotion(TrinketPotionObjects.get(enhancedGlittering).getPotionType(), advancedGlowing, 0xFFFF78, 0, Ingredient.func_193367_a((Item)ModItems.crafting.glowing_gem)).registerWithPotion();
        ModPotionTypes.createCompoundPotion((Potion)new IceResistance(iceResist, 3600, 0xE6E6E6, false), TrinketPotionObjects.get(baseSparkling).getPotionType(), iceResist, 0xE6E6E6, 3600, 9600, Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150433_aE))).registerWithPotion();
        ModPotionTypes.createCompoundPotion((Potion)new LightningResistance(lightningResist, 3600, 0xE6E6E6, false), TrinketPotionObjects.get(baseSparkling).getPotionType(), lightningResist, 0xE6E6E6, 3600, 9600, Ingredient.func_193367_a((Item)ModItems.foods.mana_crystal)).registerWithPotionWithoutRecipe();
        ModPotionTypes.createRacePotion(EntityRaces.human, TrinketPotionObjects.get(baseSparkling).getPotionType(), TrinketsConfig.SERVER.Potion.human.Duration, ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.human.catalyst)).registerWithPotion();
        ModPotionTypes.createRacePotion(EntityRaces.fairy, TrinketPotionObjects.get(advancedGlowing).getPotionType(), TrinketsConfig.SERVER.Potion.fairy.Duration, ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.fairy.catalyst)).registerWithPotion();
        ModPotionTypes.createRacePotion(EntityRaces.dwarf, TrinketPotionObjects.get(enhancedGlittering).getPotionType(), TrinketsConfig.SERVER.Potion.dwarf.Duration, ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.dwarf.catalyst)).registerWithPotion();
        ModPotionTypes.createRacePotion(EntityRaces.titan, TrinketPotionObjects.get(advancedGlowing).getPotionType(), TrinketsConfig.SERVER.Potion.titan.Duration, ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.titan.catalyst)).registerWithPotion();
        ModPotionTypes.createRacePotion(EntityRaces.goblin, TrinketPotionObjects.get(baseSparkling).getPotionType(), TrinketsConfig.SERVER.Potion.goblin.Duration, ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.goblin.catalyst)).registerWithPotion();
        ModPotionTypes.createRacePotion(EntityRaces.elf, TrinketPotionObjects.get(enhancedGlittering).getPotionType(), TrinketsConfig.SERVER.Potion.elf.Duration, ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.elf.catalyst)).registerWithPotion();
        ModPotionTypes.createRacePotion(EntityRaces.faelis, TrinketPotionObjects.get(enhancedGlittering).getPotionType(), TrinketsConfig.SERVER.Potion.faelis.Duration, ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.faelis.catalyst)).registerWithPotion();
        ModPotionTypes.createRacePotion(EntityRaces.dragon, TrinketPotionObjects.get(advancedGlowing).getPotionType(), TrinketsConfig.SERVER.Potion.dragon.Duration, ModPotionTypes.getCatalyst(TrinketsConfig.SERVER.Potion.dragon.catalyst)).registerWithPotion();
        Trinkets.log.info("Finished Generating Potions");
    }

    private static Ingredient getCatalyst(String catalyst) {
        String[] itemConfig = catalyst.replace(";", ":").split(":");
        String modIDString = StringUtils.getStringFromArray(itemConfig, 0);
        String itemIDString = StringUtils.getStringFromArray(itemConfig, 1);
        String metaString = StringUtils.getStringFromArray(itemConfig, 2).replaceAll("[^\\d]", "");
        int meta = Short.MAX_VALUE;
        try {
            if (!metaString.isEmpty()) {
                meta = Integer.parseInt(metaString);
            }
        }
        catch (Exception e) {
            Trinkets.log.warn("Invalid catalyst meta from | " + catalyst);
        }
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Item.func_111206_d((String)(modIDString + ":" + itemIDString)), 1, meta)});
    }
}

