/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.capabilities.statushandler.TrinketStatusEffect;
import xzeroair.trinkets.events.EventBaseHandler;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.faelis.config.FaelisConfig;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IItemUseAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.PotionHelper;
import xzeroair.trinkets.util.helpers.StringUtils;

public class EventHandler
extends EventBaseHandler {
    @SubscribeEvent
    public void playerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer entity = event.player;
        if (!entity.func_70089_S() || entity.func_130014_f_() == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            try {
                Capabilities.getEntityProperties((Entity)entity, EntityProperties::onUpdatePre);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (TrinketsConfig.SERVER.misc.retrieveVIP) {
                try {
                    Capabilities.getVipStatus((Entity)entity, VipStatus::onUpdate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.raceHandlerTick((EntityLivingBase)entity);
            this.effectHandlerTick((EntityLivingBase)entity);
            this.magicHandlerTick((EntityLivingBase)entity);
        }
    }

    @SubscribeEvent
    public void EntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof EntityPlayer)) {
            this.raceHandlerTick(entity);
            this.effectHandlerTick(entity);
            if (!TrinketsConfig.SERVER.mana.players_only) {
                this.magicHandlerTick(entity);
            }
        }
    }

    private void raceHandlerTick(EntityLivingBase entity) {
        try {
            Capabilities.getEntityProperties((Entity)entity, EntityProperties::onUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void magicHandlerTick(EntityLivingBase entity) {
        try {
            Capabilities.getMagicStats((Entity)entity, MagicStats::onUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void effectHandlerTick(EntityLivingBase entity) {
        try {
            Capabilities.getStatusHandler((Entity)entity, StatusHandler::onUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void makeNoise(PlaySoundAtEntityEvent event) {
        Entity entity = event.getEntity();
        if (event.getSound() != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean client = player.field_70170_p.field_72995_K;
            Capabilities.getEntityProperties((Entity)player, prop -> {
                if (!(prop.isNormalSize() || event.getSound() != SoundEvents.field_187902_gb && event.getSound() != SoundEvents.field_187579_bV && event.getSound() != SoundEvents.field_187554_ai && event.getSound() != SoundEvents.field_187897_gY && event.getSound() != SoundEvents.field_187668_ca && event.getSound() != SoundEvents.field_187815_fJ && event.getSound() != SoundEvents.field_187569_bQ && event.getSound() != SoundEvents.field_187778_dq && event.getSound() != SoundEvents.field_187695_h && event.getSound() != SoundEvents.field_187653_cW && event.getSound() != SoundEvents.field_187888_ft || client)) {
                    if (!event.getEntity().func_70051_ag()) {
                        event.setVolume(0.0f);
                    } else {
                        event.setVolume(0.1f);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void potionApply(PotionEvent.PotionApplicableEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.func_70089_S() || entity.func_130014_f_() == null) {
            return;
        }
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            boolean cancel = false;
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            if (prop.getRaceHandler().potionBeingApplied(event.getPotionEffect())) {
                cancel = true;
            }
            if (!cancel) {
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder holder = entry.getValue();
                    try {
                        IAbilityInterface handler = holder.getAbility();
                        if (!(handler instanceof IPotionAbility)) continue;
                        cancel = ((IPotionAbility)handler).potionApplied(entity, event.getPotionEffect(), cancel);
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Potion Ability:" + key);
                        e.printStackTrace();
                    }
                }
            }
            if (cancel) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        Capabilities.getEntityProperties((Entity)event.getEntityLiving(), prop -> {
            try {
                prop.getRaceHandler().interact(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public void playerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Capabilities.getEntityProperties((Entity)event.getEntityLiving(), prop -> prop.getRaceHandler().interactWithEntity(event));
    }

    @SubscribeEvent
    public void playerInteractEntitySpecific(PlayerInteractEvent.EntityInteractSpecific event) {
    }

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    @SubscribeEvent
    public void playerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
    }

    @SubscribeEvent
    public void playerRightClickItem(PlayerInteractEvent.RightClickItem event) {
    }

    @SubscribeEvent
    public void onMount(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntityMounting();
            Capabilities.getEntityProperties((Entity)entity, prop -> {
                EntityRacePropertiesHandler handler = prop.getRaceHandler();
                try {
                    boolean bool;
                    boolean bl = event.isMounting() ? !handler.mountEntity(event.getEntityBeingMounted()) : (bool = !handler.dismountedEntity(event.getEntityBeingMounted()));
                    if (bool) {
                        this.cancelEvent((Event)event);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @SubscribeEvent
    public void onItemStartUsingEvent(LivingEntityUseItemEvent.Start event) {
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            int duration;
            ItemStack stack = event.getItem();
            int dur = duration = event.getDuration();
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    IAbilityInterface handler = holder.getAbility();
                    if (!(handler instanceof IItemUseAbility)) continue;
                    if (dur < 0) break;
                    dur = ((IItemUseAbility)handler).onItemStartUse(entity, stack, dur);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            if (duration != dur) {
                event.setDuration(dur);
            }
        });
    }

    @SubscribeEvent
    public void onItemUsingTickEvent(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            int duration;
            ItemStack stack = event.getItem();
            int dur = duration = event.getDuration();
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    IAbilityInterface handler = holder.getAbility();
                    if (!(handler instanceof IItemUseAbility)) continue;
                    if (dur < 0) break;
                    dur = ((IItemUseAbility)handler).onItemUseTick(entity, stack, dur);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            prop.getRaceHandler().bowDrawing(stack, dur);
            if (duration != dur) {
                event.setDuration(dur);
            }
        });
    }

    @SubscribeEvent
    public void onItemStopUseEvent(LivingEntityUseItemEvent.Stop event) {
        EntityLivingBase entity = event.getEntityLiving();
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            ItemStack stack = event.getItem();
            int duration = event.getDuration();
            Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    IAbilityInterface handler = holder.getAbility();
                    if (!(handler instanceof IItemUseAbility)) continue;
                    ((IItemUseAbility)handler).onItemUseStop(entity, stack, duration);
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
        });
    }

    @SubscribeEvent
    public void onItemFinishUseEvent(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        Item item = stack.func_77973_b();
        String regName = item.getRegistryName().toString();
        String ModID = item.getRegistryName().func_110624_b();
        String ItemID = item.getRegistryName().func_110623_a();
        int duration = event.getDuration();
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            block9: {
                Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                    String key = entry.getKey();
                    AbilityHandler.AbilityHolder holder = entry.getValue();
                    try {
                        IAbilityInterface handler = holder.getAbility();
                        if (!(handler instanceof IItemUseAbility)) continue;
                        ((IItemUseAbility)handler).onItemUseFinish(entity, stack, duration);
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                        e.printStackTrace();
                    }
                }
                try {
                    String[] milkList;
                    StatusHandler status;
                    FaelisConfig faelisConfig = TrinketsConfig.SERVER.races.faelis;
                    if (!prop.getCurrentRace().equals(EntityRaces.faelis) || !faelisConfig.Invigorated || (status = Capabilities.getStatusHandler((Entity)entity)) == null) break block9;
                    for (String milk : milkList = faelisConfig.milk) {
                        int Iduration;
                        String[] itemConfig = milk.split(";");
                        String itemString = StringUtils.getStringFromArray(itemConfig, 0);
                        String metaString = StringUtils.getStringFromArray(itemConfig, 1);
                        String levelString = StringUtils.getStringFromArray(itemConfig, 2);
                        String durationString = StringUtils.getStringFromArray(itemConfig, 3);
                        if (!event.getItem().func_77973_b().getRegistryName().toString().equalsIgnoreCase(itemString)) continue;
                        int meta = metaString.isEmpty() ? Short.MAX_VALUE : Integer.parseInt(metaString);
                        int level = levelString.isEmpty() ? 0 : Integer.parseInt(levelString);
                        int n = Iduration = durationString.isEmpty() ? faelisConfig.Invigorated_Duration : Integer.parseInt(durationString);
                        if (meta == Short.MAX_VALUE || event.getItem().func_77960_j() == meta) {
                            status.apply(new TrinketStatusEffect("Invigorated", Iduration, level, null));
                            if (!entity.field_70170_p.field_72995_K) {
                                for (String potID : faelisConfig.buffs) {
                                    PotionHelper.PotionHolder potion = PotionHelper.getPotionHolder(potID);
                                    if (potion.getPotion() == null) continue;
                                    entity.func_70690_d(potion.getPotionEffect());
                                }
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (TrinketsConfig.SERVER.mana.mana_enabled) {
            try {
                TreeMap<String, ConfigHelper.MPRecoveryItem> MagicRecoveryItems = ConfigHelper.TrinketConfigStorage.MagicRecoveryItems;
                float amount = 0.0f;
                boolean multiplied = false;
                for (ConfigHelper.MPRecoveryItem entry : MagicRecoveryItems.values()) {
                    if (!entry.doesItemMatchEntry(stack)) continue;
                    amount = entry.getAmount();
                    multiplied = entry.isMultiplied();
                    break;
                }
                float finalAmount = amount;
                boolean finalMultiplied = multiplied;
                if (finalAmount > 0.0f || finalAmount < 0.0f) {
                    Capabilities.getMagicStats((Entity)entity, magic -> {
                        if (finalAmount > 0.0f) {
                            if (finalMultiplied) {
                                magic.addMana(magic.getMaxMana() * (finalAmount * 0.01f));
                            } else {
                                magic.addMana(finalAmount);
                            }
                        } else if (finalMultiplied) {
                            magic.spendMana(magic.getMaxMana() * (finalAmount * 0.01f));
                        } else {
                            magic.spendMana(finalAmount);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

