/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.entity.ai.EnderAiEdit;
import xzeroair.trinkets.entity.ai.EnderMoveAI;
import xzeroair.trinkets.entity.ai.EnderQueensKnightAI;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigEnderCrown;

public class EnderQueenHandler {
    private ConfigEnderCrown serverConfig;

    public EnderQueenHandler() {
        this.serverConfig = TrinketsConfig.SERVER.Items.ENDER_CROWN;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void soundEvent(PlaySoundEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p != null && (TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketEnderTiara) || TrinketHelper.getSlotInfoForArmor((EntityLivingBase)player, stack -> !stack.func_190926_b() && stack.func_77973_b().getRegistryName().toString().contentEquals(ModItems.trinkets.TrinketEnderTiara.toString())) != null || TrinketHelper.entityHasAbility("ender_queen".toString(), (EntityLivingBase)player)) && event.getSound().func_147650_b().toString().contentEquals("minecraft:entity.endermen.stare")) {
            event.setResultSound(null);
        }
    }

    @SubscribeEvent
    public void EndermanJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityEnderman) {
            EntityEnderman ender = (EntityEnderman)event.getEntity();
            for (Object a : ender.field_70715_bh.field_75782_a.toArray()) {
                EntityAIBase ai = ((EntityAITasks.EntityAITaskEntry)a).field_75733_a;
                if (!ai.toString().startsWith("net.minecraft.entity.monster.EntityEnderman$AIFindPlayer")) continue;
                ender.field_70715_bh.func_85156_a(ai);
            }
            ender.field_70715_bh.func_75776_a(1, (EntityAIBase)new EnderAiEdit(ender));
            ender.field_70715_bh.func_75776_a(2, (EntityAIBase)new EnderQueensKnightAI(ender));
            if (this.serverConfig.Follow) {
                ender.field_70715_bh.func_75776_a(3, (EntityAIBase)new EnderMoveAI(ender));
            }
        }
    }

    @SubscribeEvent
    public void EnderTeleportEvent(EnderTeleportEvent event) {
        if (!TrinketsConfig.SERVER.Items.ENDER_CROWN.teleport) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        boolean isPlayer = entity instanceof EntityPlayer;
        boolean pvpEnabled = false;
        if (isPlayer) {
            try {
                if (entity instanceof EntityPlayerMP) {
                    pvpEnabled = ((EntityPlayerMP)entity).func_184102_h().func_71219_W();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (entity instanceof EntityEnderman || isPlayer && pvpEnabled) {
            AxisAlignedBB bBox = entity.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0);
            List entLivList = entity.func_130014_f_().func_175647_a(EntityPlayer.class, bBox, Predicates.and((Predicate)EntitySelectors.field_180132_d, player -> player != null && TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketEnderTiara) || TrinketHelper.getSlotInfoForArmor((EntityLivingBase)player, stack -> !stack.func_190926_b() && stack.func_77973_b().getRegistryName().toString().contentEquals(ModItems.trinkets.TrinketEnderTiara.toString())) != null || TrinketHelper.entityHasAbility("ender_queen".toString(), (EntityLivingBase)player)));
            if (!(entLivList.isEmpty() || entLivList.contains(entity) || entity.func_70090_H())) {
                event.setCanceled(true);
            }
        }
    }
}

