/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.client.gui.entityPropertiesGui;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.client.gui.entityPropertiesGui.GuiAttributesScrollingList;
import xzeroair.trinkets.client.gui.entityPropertiesGui.GuiPropertiesButton;
import xzeroair.trinkets.client.gui.entityPropertiesGui.GuiPropertiesSlider;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.ColorHelper;

@SideOnly(value=Side.CLIENT)
public class GuiAttributesScreen
extends GuiScreen {
    public EntityPlayer player;
    public EntityProperties properties;
    protected GuiPropertiesSlider r;
    protected GuiPropertiesSlider g;
    protected GuiPropertiesSlider b;
    protected GuiPropertiesSlider a;
    public ColorHelper color;
    public int buttonPressed;
    public int redSlider = 5;
    public int greenSlider = 6;
    public int blueSlider = 7;
    public int alphaSlider = 8;
    protected boolean flip = false;
    public static ResourceLocation background = null;
    private float oldMouseX;
    private float oldMouseY;
    private GuiAttributesScrollingList abilitySelectionList;
    private GuiScrollingList abilityDescriptions;
    private GuiScrollingList raceAttributes;
    private GuiScrollingList raceBonuses;
    private int selected = -1;
    private AbilityHandler.AbilityHolder selectedAbility;
    private int listWidth;
    private ArrayList<AbilityHandler.AbilityHolder> abilities;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.##");

    public GuiAttributesScreen(EntityPlayer player) {
        this.player = player;
        this.color = new ColorHelper();
        this.properties = Capabilities.getEntityProperties((Entity)player);
    }

    public void selectAbilityIndex(int index) {
        if (index == this.selected) {
            return;
        }
        this.selected = index;
        this.selectedAbility = index >= 0 && index <= this.abilities.size() ? this.abilities.get(this.selected) : null;
        this.updateCache();
    }

    public boolean abilityIndexSelected(int index) {
        return index == this.selected;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.func_189646_b(new GuiPropertiesButton(1, 2, 2, 50, 20, "<--"));
        this.func_189646_b(new GuiPropertiesButton(2, this.field_146294_l - 16, 2, 14, 20, TextFormatting.RED + "X"));
        this.abilities = Lists.newArrayList(this.properties.getAbilityHandler().getActiveAbilities().values());
        int slotHeight = 20;
        if (this.abilities == null || this.abilities.isEmpty()) {
            return;
        }
        for (AbilityHandler.AbilityHolder ability : this.abilities) {
            String name = ability.getAbility().getDisplayName();
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(name) + 10);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.abilitySelectionList = new GuiAttributesScrollingList(0, this, this.abilities, this.listWidth, 20);
        this.updateCache();
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.buttonPressed = 0;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        if (keyCode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i()) {
            this.player.func_71053_j();
            this.displayNormalInventory();
        }
    }

    public void displayNormalInventory() {
        GuiInventory gui = new GuiInventory((EntityPlayer)this.field_146297_k.field_71439_g);
        this.field_146297_k.func_147108_a((GuiScreen)gui);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.buttonPressed = button.field_146127_k;
        super.func_146284_a(button);
        if (button.field_146127_k == 1) {
            this.field_146297_k.field_71439_g.openGui((Object)Trinkets.instance, 2, this.field_146297_k.field_71439_g.field_70170_p, 0, 0, 0);
        }
        if (button.field_146127_k == 2) {
            this.displayNormalInventory();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.properties == null) {
            return;
        }
        if (this.abilitySelectionList != null) {
            this.abilitySelectionList.drawScreen(mouseX, mouseY, partialTicks);
        }
        if (this.abilityDescriptions != null) {
            this.abilityDescriptions.drawScreen(mouseX, mouseY, partialTicks);
        }
        if (this.raceAttributes != null) {
            this.raceAttributes.drawScreen(mouseX, mouseY, partialTicks);
        }
        if (this.raceBonuses != null) {
            this.raceBonuses.drawScreen(mouseX, mouseY, partialTicks);
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        if (this.abilityDescriptions != null) {
            this.abilityDescriptions.handleMouseInput(mouseX, mouseY);
        }
        if (this.abilitySelectionList != null) {
            this.abilitySelectionList.handleMouseInput(mouseX, mouseY);
        }
    }

    public int drawLine(String line, int offset, int shifty) {
        this.field_146289_q.func_78276_b(line, offset, shifty, 14151146);
        return shifty + 10;
    }

    public Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    private void updateCache() {
        this.abilityDescriptions = null;
        this.raceAttributes = null;
        ResourceLocation logoPath2 = null;
        Dimension logoDims2 = new Dimension(0, 0);
        ArrayList<String> lines2 = new ArrayList<String>();
        try {
            String[] attributeConfig = this.properties.getCurrentRace().getRaceAttributes().getAttributes();
            if (attributeConfig != null && attributeConfig.length > 0) {
                for (String entry : attributeConfig) {
                    String s;
                    ConfigHelper.AttributeEntry attributeShell = ConfigHelper.getAttributeEntry(entry);
                    if (attributeShell == null) continue;
                    String name = attributeShell.getAttribute();
                    double amount = attributeShell.getAmount();
                    int operation = attributeShell.getOperation();
                    if (this.player == null || this.player.func_110140_aT().func_111152_a(name) == null) continue;
                    double d0 = amount;
                    boolean flag = false;
                    double d1 = operation != 1 && operation != 2 ? d0 : d0 * 100.0;
                    TextComponentTranslation AttrName = new TextComponentTranslation("attribute.name." + name, new Object[0]);
                    if (flag) {
                        TextComponentTranslation never = new TextComponentTranslation("attribute.modifier.equals." + operation, new Object[]{DECIMALFORMAT.format(d1), AttrName.func_150254_d()});
                        lines2.add(" " + never.func_150254_d());
                        continue;
                    }
                    if (d0 > 0.0) {
                        TextComponentTranslation addition = new TextComponentTranslation("attribute.modifier.plus." + operation, new Object[]{DECIMALFORMAT.format(d1), AttrName.func_150254_d()});
                        addition.func_150256_b().func_150238_a(TextFormatting.BLUE);
                        s = addition.func_150254_d();
                        lines2.add(" " + s);
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    TextComponentTranslation subtraction = new TextComponentTranslation("attribute.modifier.take." + operation, new Object[]{DECIMALFORMAT.format(d1 *= -1.0), AttrName.func_150254_d()});
                    subtraction.func_150256_b().func_150238_a(TextFormatting.RED);
                    s = subtraction.func_150254_d();
                    lines2.add(" " + s);
                }
            }
        }
        catch (Exception attributeConfig) {
            // empty catch block
        }
        this.raceAttributes = new Info(this.listWidth + 40, lines2, logoPath2, logoDims2, 32, this.field_146295_m - 18 + 4, this.field_146294_l - this.listWidth - 50);
        if (this.selectedAbility == null) {
            return;
        }
        ResourceLocation logoPath = null;
        Dimension logoDims = new Dimension(0, 0);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String source = this.selectedAbility.getSourceID();
            IAbilityInterface abilityInstance = this.selectedAbility.getAbility();
            TrinketHelper.SlotInformation slotInfo = this.selectedAbility.getInfo();
            lines.add(TextFormatting.GOLD + abilityInstance.getDisplayName());
            lines.add(TextFormatting.AQUA + source);
            lines.add(null);
            abilityInstance.getDescription(lines);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.abilityDescriptions = new Info(this.field_146294_l - this.listWidth - 50 - this.listWidth - 30, lines, logoPath, logoDims);
    }

    private class Info
    extends GuiScrollingList {
        @Nullable
        private ResourceLocation logoPath;
        private Dimension logoDims;
        private List<ITextComponent> lines;

        public Info(int width, @Nullable List<String> lines, ResourceLocation logoPath, Dimension logoDims, int top, int bottom, int left) {
            super(GuiAttributesScreen.this.getMinecraftInstance(), width, GuiAttributesScreen.this.field_146295_m, top, bottom, left, 60, GuiAttributesScreen.this.field_146294_l, GuiAttributesScreen.this.field_146295_m);
            this.lines = null;
            this.lines = this.resizeContent(lines);
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        public Info(int width, @Nullable List<String> lines, ResourceLocation logoPath, Dimension logoDims) {
            super(GuiAttributesScreen.this.getMinecraftInstance(), width, GuiAttributesScreen.this.field_146295_m, 32, GuiAttributesScreen.this.field_146295_m - 18 + 4, GuiAttributesScreen.this.listWidth + 20, 60, GuiAttributesScreen.this.field_146294_l, GuiAttributesScreen.this.field_146295_m);
            this.lines = null;
            this.lines = this.resizeContent(lines);
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        protected int getSize() {
            return 0;
        }

        protected void elementClicked(int index, boolean doubleClick) {
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        }

        private List<ITextComponent> resizeContent(List<String> lines) {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
                int maxTextLength = this.listWidth - 8;
                if (maxTextLength < 0) continue;
                ret.addAll(GuiUtilRenderComponents.func_178908_a((ITextComponent)chat, (int)maxTextLength, (FontRenderer)GuiAttributesScreen.this.getFontRenderer(), (boolean)false, (boolean)true));
            }
            return ret;
        }

        private int getHeaderHeight() {
            int height = 0;
            if (this.logoPath != null) {
                double scaleX = (double)this.logoDims.width / 200.0;
                double scaleY = (double)this.logoDims.height / 65.0;
                double scale = 1.0;
                if (scaleX > 1.0 || scaleY > 1.0) {
                    scale = 1.0 / Math.max(scaleX, scaleY);
                }
                this.logoDims.width = (int)((double)this.logoDims.width * scale);
                this.logoDims.height = (int)((double)this.logoDims.height * scale);
                height += this.logoDims.height;
                height += 10;
            }
            if ((height += this.lines.size() * 10) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
            int top = relativeY;
            if (this.logoPath != null) {
                GlStateManager.func_179147_l();
                GuiAttributesScreen.this.getMinecraftInstance().field_71446_o.func_110577_a(this.logoPath);
                BufferBuilder wr = tess.func_178180_c();
                int offset = this.left + this.listWidth / 2 - this.logoDims.width / 2;
                wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                wr.func_181662_b((double)offset, (double)(top + this.logoDims.height), (double)GuiAttributesScreen.this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
                wr.func_181662_b((double)(offset + this.logoDims.width), (double)(top + this.logoDims.height), (double)GuiAttributesScreen.this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
                wr.func_181662_b((double)(offset + this.logoDims.width), (double)top, (double)GuiAttributesScreen.this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
                wr.func_181662_b((double)offset, (double)top, (double)GuiAttributesScreen.this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179084_k();
                top += this.logoDims.height + 10;
            }
            for (ITextComponent line : this.lines) {
                if (line != null) {
                    GlStateManager.func_179147_l();
                    GuiAttributesScreen.this.getFontRenderer().func_175063_a(line.func_150254_d(), (float)(this.left + 4), (float)top, 0xFFFFFF);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                }
                top += 10;
            }
        }

        protected void clickHeader(int x, int y) {
            int offset = y;
            if (this.logoPath != null) {
                offset -= this.logoDims.height + 10;
            }
            if (offset <= 0) {
                return;
            }
            int lineIdx = offset / 10;
            if (lineIdx >= this.lines.size()) {
                return;
            }
            ITextComponent line = this.lines.get(lineIdx);
            if (line != null) {
                int k = -4;
                for (ITextComponent part : line) {
                    if (!(part instanceof TextComponentString) || (k += GuiAttributesScreen.this.field_146289_q.func_78256_a(((TextComponentString)part).func_150265_g())) < x) continue;
                    GuiAttributesScreen.this.func_175276_a(part);
                    break;
                }
            }
        }
    }

    private static enum SortType implements Comparator<IAbilityInterface>
    {
        NORMAL(24),
        A_TO_Z(25){

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A(26){

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        private int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        @Nullable
        public static SortType getTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.field_146127_k) continue;
                return t;
            }
            return null;
        }

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(IAbilityInterface o1, IAbilityInterface o2) {
            String name1 = StringUtils.func_76338_a((String)o1.getDisplayName()).toLowerCase();
            String name2 = StringUtils.func_76338_a((String)o2.getDisplayName()).toLowerCase();
            return this.compare(name1, name2);
        }
    }
}

