/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.client.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.init.Elements;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.trinkets.TrinketDragonsEye;
import xzeroair.trinkets.items.trinkets.TrinketSeaStone;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.util.TrinketsConfig;

public class PlayerCameraSetupEvents {
    private static Minecraft mc = Minecraft.func_71410_x();

    private CameraTranslation getVanillaTranslation(EntityRenderer renderer, double partialTicks) {
        Entity entity = mc.func_175606_aa();
        float f = entity.func_70047_e();
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * partialTicks + (double)f;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * partialTicks;
        int perspective = PlayerCameraSetupEvents.mc.field_71474_y.field_74320_O;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (perspective > 0) {
            double d3 = 4.0 + 0.0 * partialTicks;
            float f1 = entity.field_70177_z;
            float f2 = entity.field_70125_A;
            if (perspective == 2) {
                f2 += 180.0f;
            }
            float sq = (float)Math.PI / 180;
            double d4 = (double)(-MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
            double d5 = (double)(MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
            double d6 = (double)(-MathHelper.func_76126_a((float)(f2 * ((float)Math.PI / 180)))) * d3;
            for (int i = 0; i < 8; ++i) {
                double d7;
                double endZ;
                double endY;
                double endX;
                Vec3d end;
                RayTraceResult raytraceresult;
                float f3 = (i & 1) * 2 - 1;
                float f4 = (i >> 1 & 1) * 2 - 1;
                float f5 = (i >> 2 & 1) * 2 - 1;
                double startX = d0 + (double)(f3 *= 0.1f);
                double startY = d1 + (double)(f4 *= 0.1f);
                double startZ = d2 + (double)(f5 *= 0.1f);
                Vec3d start = new Vec3d(startX, startY, startZ);
                if ((raytraceresult = PlayerCameraSetupEvents.mc.field_71441_e.func_72933_a(start, end = new Vec3d(endX = d0 - d4 + (double)f3 + (double)f5, endY = d1 - d6 + (double)f4, endZ = d2 - d5 + (double)f5))) == null || !((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(d0, d1, d2))) < d3)) continue;
                d3 = d7;
            }
            z = (float)d3;
        } else {
            z = 0.05f;
        }
        return new CameraTranslation(x, y, perspective == 2 ? -z : z);
    }

    public CameraTranslation updatedOffset(EntityRenderer renderer, double multiplier, double partialTicks) {
        Entity entity = mc.func_175606_aa();
        float f = entity.func_70047_e();
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * partialTicks + (double)f;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * partialTicks;
        int perspective = PlayerCameraSetupEvents.mc.field_71474_y.field_74320_O;
        double d = 4.0 * multiplier;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (perspective > 0) {
            double d3 = d + (d - d) * partialTicks;
            float f1 = entity.field_70177_z;
            float f2 = entity.field_70125_A;
            if (perspective == 2) {
                f2 += 180.0f;
            }
            float sq = (float)Math.PI / 180;
            double d4 = (double)(-MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
            double d5 = (double)(MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
            double d6 = (double)(-MathHelper.func_76126_a((float)(f2 * ((float)Math.PI / 180)))) * d3;
            for (int i = 0; i < 8; ++i) {
                double d7;
                double endZ;
                double endY;
                double endX;
                Vec3d end;
                RayTraceResult raytraceresult;
                float f3 = (i & 1) * 2 - 1;
                float f4 = (i >> 1 & 1) * 2 - 1;
                float f5 = (i >> 2 & 1) * 2 - 1;
                double startX = d0 + (double)(f3 *= 0.1f);
                double startY = d1 + (double)(f4 *= 0.1f);
                double startZ = d2 + (double)(f5 *= 0.1f);
                Vec3d start = new Vec3d(startX, startY, startZ);
                if ((raytraceresult = PlayerCameraSetupEvents.mc.field_71441_e.func_72933_a(start, end = new Vec3d(endX = d0 - d4 + (double)f3 + (double)f5, endY = d1 - d6 + (double)f4, endZ = d2 - d5 + (double)f5))) == null || !((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(d0, d1, d2))) < d3)) continue;
                d3 = multiplier <= 1.0 ? d7 * multiplier : d7;
            }
            if (perspective == 2) {
                // empty if block
            }
            z = (float)d3;
        } else {
            z = 0.05f;
        }
        return new CameraTranslation(x, y, perspective == 2 ? z : -z);
    }

    private void applyBobbing(float partialTicks) {
        if (mc.func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)mc.func_175606_aa();
            float f = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f1 = -(entityplayer.field_70140_Q + f * partialTicks);
            float f2 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * partialTicks;
            float f3 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * partialTicks;
            GlStateManager.func_179109_b((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.15f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2) * 0.0f), (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void CameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (!TrinketsConfig.CLIENT.cameraHeight) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            Capabilities.getEntityProperties((Entity)player, prop -> {
                EntityRacePropertiesHandler handler = prop.getRaceHandler();
                if (!prop.isNormalSize() || handler.isTransforming()) {
                    float defaultHeight = prop.getDefaultHeight();
                    float height = handler.getHeight();
                    int perspective = PlayerCameraSetupEvents.mc.field_71474_y.field_74320_O;
                    if (perspective > 0) {
                        CameraTranslation vanilla = this.getVanillaTranslation(event.getRenderer(), event.getRenderPartialTicks());
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)vanilla.getZ());
                        CameraTranslation offset = this.updatedOffset(event.getRenderer(), height / defaultHeight, event.getRenderPartialTicks());
                        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)offset.getZ());
                    }
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderFogDensityEvent(EntityViewRenderEvent.FogDensity event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_70090_H()) {
            boolean hasSeaStone = !TrinketHelper.getAccessory((EntityLivingBase)player, acc -> acc.func_77973_b() instanceof TrinketSeaStone).func_190926_b();
            boolean hasAffinity = TrinketHelper.entityHasAbility("water_affinity".toString(), (EntityLivingBase)player);
            if (hasSeaStone || hasAffinity) {
                if (event.isCancelable() && !event.isCanceled()) {
                    event.setCanceled(true);
                }
                event.setDensity(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void renderBlockOverlay(RenderBlockOverlayEvent event) {
        RenderBlockOverlayEvent.OverlayType overlay = event.getOverlayType();
        if (overlay == RenderBlockOverlayEvent.OverlayType.FIRE || overlay == RenderBlockOverlayEvent.OverlayType.WATER) {
            boolean hasWaterAffinity;
            boolean cancel = !TrinketHelper.getAccessory((EntityLivingBase)event.getPlayer(), acc -> {
                if (overlay == RenderBlockOverlayEvent.OverlayType.FIRE && (acc.func_77973_b() instanceof TrinketDragonsEye && ((TrinketDragonsEye)acc.func_77973_b()).getPrimaryElement() == Elements.FIRE || acc.func_77973_b().getRegistryName().toString().equalsIgnoreCase(ModItems.RaceTrinkets.TrinketDragonRing.getRegistryName().toString()))) {
                    return true;
                }
                return overlay == RenderBlockOverlayEvent.OverlayType.WATER && acc.func_77973_b() instanceof TrinketSeaStone;
            }).func_190926_b();
            boolean hasFireAffinity = overlay == RenderBlockOverlayEvent.OverlayType.FIRE && TrinketHelper.entityHasAbility("fire_immunity".toString(), (EntityLivingBase)event.getPlayer());
            boolean bl = hasWaterAffinity = overlay == RenderBlockOverlayEvent.OverlayType.WATER && TrinketHelper.entityHasAbility("water_affinity".toString(), (EntityLivingBase)event.getPlayer());
            if ((cancel || hasFireAffinity || hasWaterAffinity) && event.isCancelable() && !event.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    private static class CameraTranslation {
        private float x;
        private float y;
        private float z;

        public CameraTranslation(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public final float getZ() {
            return this.z;
        }
    }
}

