/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.race;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import xzeroair.trinkets.init.Elements;
import xzeroair.trinkets.traits.elements.Element;

public class ElementalAttributes {
    protected Element primary = Elements.NEUTRAL;
    protected Element secondary = Elements.NEUTRAL;
    protected Element temporary = Elements.NEUTRAL;
    protected Map<ResourceLocation, Element> subElements = new TreeMap<ResourceLocation, Element>();

    public ElementalAttributes setPrimaryElement(Element element) {
        if (element != null && element != this.primary) {
            this.primary = element;
        }
        return this;
    }

    public ElementalAttributes setSecendaryElement(Element element) {
        if (element != null && element != this.secondary) {
            this.secondary = element;
        }
        return this;
    }

    public ElementalAttributes setTemporaryElement(Element element) {
        if (element != null && element != this.temporary) {
            this.temporary = element;
        }
        return this;
    }

    public ElementalAttributes addSubElements(Element ... elements) {
        for (Element element : elements) {
            if (this.getPrimaryElement() == element || this.getSecondaryElement() == element) continue;
            this.subElements.put(element.getRegistryName(), element);
        }
        return this;
    }

    @Nullable
    public Element removeSubElement(Element element) {
        if (element != null) {
            return this.subElements.remove(element.getRegistryName());
        }
        return null;
    }

    public Element getPrimaryElement() {
        return this.primary;
    }

    public Element getSecondaryElement() {
        return this.secondary;
    }

    public Element getTemporaryElement() {
        return this.temporary;
    }

    public Map<ResourceLocation, Element> getSubElements() {
        return this.subElements;
    }

    public NBTTagCompound saveToNBT(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("primary", this.getPrimaryElement().getRegistryName().toString());
        tag.func_74778_a("secondary", this.getSecondaryElement().getRegistryName().toString());
        NBTTagCompound subs = new NBTTagCompound();
        for (Element subEle : this.getSubElements().values()) {
            subs.func_74778_a(subEle.getID() + "", subEle.getRegistryName().toString());
        }
        if (!subs.func_82582_d()) {
            tag.func_74782_a("sub", (NBTBase)subs);
        }
        compound.func_74782_a("Elements", (NBTBase)tag);
        return compound;
    }

    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Elements")) {
            NBTTagCompound tag = compound.func_74775_l("Elements");
            if (tag.func_74764_b("primary")) {
                this.primary = Element.getByNameOrId(tag.func_74779_i("primary"));
            }
            if (tag.func_74764_b("secondary")) {
                this.secondary = Element.getByNameOrId(tag.func_74779_i("secondary"));
            }
            if (tag.func_74764_b("sub")) {
                NBTTagCompound subs = tag.func_74775_l("sub");
                for (String entry : subs.func_150296_c()) {
                    String ele = subs.func_74779_i(entry);
                    this.addSubElements(Element.getByNameOrId(ele));
                }
            }
        }
    }
}

