/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.magic;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xzeroair.trinkets.attributes.MagicAttributes;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.mana.SyncManaCostToHudPacket;
import xzeroair.trinkets.network.mana.SyncManaStatsPacket;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.mana.EntityManaConfig;

public class MagicStats
extends CapabilityBase<MagicStats, EntityLivingBase> {
    private static final EntityManaConfig manaConfig = TrinketsConfig.SERVER.mana;
    private float mana = 100.0f;
    private float maxMana = 100.0f;
    private double bonusMana = 0.0;
    private boolean sync = false;
    private double manaUpdateTickRate = 0.0;
    private double manaRegenTimeout = 0.0;
    private UpdatingAttribute MANA_BONUS = new UpdatingAttribute("BonusMax", UUID.fromString("a3b8802c-e521-45c0-b126-eb45692f68eb"), MagicAttributes.MAX_MANA).setSavedInNBT(true);

    public MagicStats(EntityLivingBase e) {
        super(e);
    }

    @Override
    public NBTTagCompound getTag() {
        NBTTagCompound tag = ((EntityLivingBase)this.object).getEntityData();
        if (tag != null) {
            NBTTagCompound persistentData;
            if (this.object instanceof EntityPlayer) {
                if (!tag.func_74764_b("PlayerPersisted")) {
                    tag.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
                }
                persistentData = tag.func_74775_l("PlayerPersisted");
            } else {
                persistentData = tag;
            }
            String capTag = "xat.magicstats";
            if (!persistentData.func_74764_b("xat.magicstats")) {
                persistentData.func_74782_a("xat.magicstats", (NBTBase)new NBTTagCompound());
            }
            return persistentData.func_74775_l("xat.magicstats");
        }
        return super.getTag();
    }

    public boolean onRegenCooldown() {
        boolean manaEnabled = TrinketsConfig.SERVER.mana.mana_enabled;
        if (!manaEnabled || this.manaRegenTimeout <= 0.0) {
            this.manaRegenTimeout = 0.0;
            return false;
        }
        this.manaRegenTimeout -= 1.0;
        return true;
    }

    @Override
    public void onUpdate() {
        boolean isCreative;
        if (this.MANA_BONUS != null) {
            float bonusPerPoint = TrinketsConfig.SERVER.mana.bonus;
            if (bonusPerPoint > 0.0f) {
                double bonus = this.getBonusMana();
                float maxBonus = TrinketsConfig.SERVER.mana.cap_bonus;
                double amount = maxBonus > 0.0f ? Math.min((double)bonusPerPoint * bonus, (double)maxBonus) : (double)bonusPerPoint * bonus;
                this.MANA_BONUS.addModifier((EntityLivingBase)this.object, amount, 0);
            } else {
                this.MANA_BONUS.removeModifier((EntityLivingBase)this.object);
            }
        }
        if (((EntityLivingBase)this.object).func_130014_f_().field_72995_K) {
            this.sync = false;
            return;
        }
        boolean bl = isCreative = this.object instanceof EntityPlayer && ((EntityPlayer)this.object).func_184812_l_();
        if (!TrinketsConfig.SERVER.mana.mana_enabled || isCreative) {
            this.refillMana();
            return;
        }
        if (this.onRegenCooldown()) {
            return;
        }
        if (this.getMana() > this.getMaxMana()) {
            this.setMana(this.getMaxMana());
        } else if (this.getMana() < this.getMaxMana()) {
            double cooldownMulti;
            this.manaUpdateTickRate += 1.0;
            IAttributeInstance cooldown = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(MagicAttributes.regenCooldown);
            double d = cooldownMulti = cooldown != null ? cooldown.func_111126_e() : 1.0;
            if (this.manaUpdateTickRate > (double)MagicStats.manaConfig.mana_update_ticks * cooldownMulti) {
                IAttributeInstance attribute = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(MagicAttributes.regen);
                this.addMana(attribute != null ? (float)attribute.func_111126_e() : 1.0f);
                this.manaUpdateTickRate = 0.0;
            }
        }
        if (this.sync) {
            this.sync = false;
            this.refillMana();
        }
    }

    public void refillMana() {
        if (this.getMana() != this.getMaxMana()) {
            this.setMana(this.getMaxMana());
        }
    }

    public float getMana() {
        return this.mana;
    }

    public void setMana(float mana) {
        if (!((EntityLivingBase)this.object).field_70170_p.field_72995_K) {
            this.mana = Math.min(Math.max(mana, 0.0f), this.getMaxMana());
            this.sendManaToPlayer((EntityLivingBase)this.object);
        }
    }

    public void addMana(float mana) {
        this.setMana(this.mana + mana);
    }

    public boolean spendMana(float cost) {
        boolean isCreative = this.object instanceof EntityPlayer && ((EntityPlayer)this.object).func_184812_l_();
        boolean manaEnabled = TrinketsConfig.SERVER.mana.mana_enabled;
        if (!manaEnabled || isCreative) {
            return true;
        }
        if (cost > 0.0f && cost <= this.getMana()) {
            this.setMana(this.mana - cost);
            this.setManaRegenTimeout();
            return true;
        }
        if (cost > this.getMana() && this.object instanceof EntityPlayer && ((EntityLivingBase)this.object).field_70170_p.field_72995_K) {
            ((EntityPlayer)this.object).func_146105_b((ITextComponent)new TextComponentString("No MP"), true);
        }
        return false;
    }

    public float getMaxMana() {
        IAttributeInstance maxMana = ((EntityLivingBase)this.object).func_110148_a(MagicAttributes.MAX_MANA);
        if (maxMana != null) {
            float max = (float)maxMana.func_111126_e();
            float maxAffinityBonus = (float)(maxMana.func_111125_b() * (double)((float)this.getRacialAffinity() * 0.01f) - maxMana.func_111125_b());
            if (MagicStats.manaConfig.mana_cap) {
                if (MagicStats.manaConfig.cap_affinity) {
                    return MathHelper.func_76131_a((float)max, (float)0.0f, (float)MagicStats.manaConfig.mana_max);
                }
                return MathHelper.func_76131_a((float)max, (float)0.0f, (float)MagicStats.manaConfig.mana_max) + maxAffinityBonus;
            }
            return Math.max(max + maxAffinityBonus, 0.0f);
        }
        return 100.0f;
    }

    public double getBonusMana() {
        return this.bonusMana;
    }

    public boolean needMana() {
        return this.mana < this.getMaxMana();
    }

    public void setBonusMana(double bonus) {
        this.bonusMana = bonus < 0.0 ? 0.0 : bonus;
        this.sendManaToPlayer((EntityLivingBase)this.object);
    }

    public void setManaRegenTimeout() {
        IAttributeInstance attribute = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(MagicAttributes.regenCooldown);
        double cooldownMulti = attribute != null ? attribute.func_111126_e() : 1.0;
        this.setManaRegenTimeout((int)((double)MagicStats.manaConfig.mana_regen_timeout * cooldownMulti));
    }

    public void setManaRegenTimeout(int timeout) {
        this.manaRegenTimeout = timeout;
    }

    public int getMagicAffinity() {
        IAttributeInstance affinity = ((EntityLivingBase)this.object).func_110148_a(MagicAttributes.affinity);
        if (affinity != null) {
            int amount = (int)affinity.func_111126_e();
            return amount += this.getRacialAffinity() - 100;
        }
        return 100;
    }

    public int getRacialAffinity() {
        return Capabilities.getEntityProperties((Entity)this.object, EntityRaces.none, (prop, r) -> prop.getCurrentRace()).getMagicAffinity();
    }

    public void sendManaToPlayer(EntityLivingBase e) {
        if (e instanceof EntityPlayerMP) {
            NetworkHandler.sendTo(new SyncManaStatsPacket((EntityLivingBase)this.object, this), (EntityPlayerMP)e);
        }
    }

    public void syncToManaCostToHud(float cost) {
        if (this.object instanceof EntityPlayer && !((EntityLivingBase)this.object).field_70170_p.field_72995_K) {
            NetworkHandler.sendTo(new SyncManaCostToHudPacket(cost), (EntityPlayerMP)this.object);
        }
    }

    @Override
    public void copyFrom(MagicStats stats, boolean wasDeath, boolean keepInv) {
        this.bonusMana = stats.bonusMana;
        this.mana = wasDeath ? (keepInv ? stats.mana : this.getMaxMana()) : stats.mana;
        this.sync = true;
    }

    @Override
    public NBTTagCompound saveToNBT(NBTTagCompound tag) {
        tag.func_74776_a("mana", this.getMana());
        tag.func_74776_a("max_mana", this.getMaxMana());
        tag.func_74780_a("bonus_mana", this.getBonusMana());
        return tag;
    }

    @Override
    public void loadFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("mana")) {
            this.mana = tag.func_74760_g("mana");
        }
        if (tag.func_74764_b("max_mana")) {
            this.maxMana = tag.func_74760_g("max_mana");
        }
        if (tag.func_74764_b("bonus_mana")) {
            this.bonusMana = tag.func_74769_h("bonus_mana");
        }
    }
}

