/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.Trinket;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.capabilities.race.ElementalAttributes;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.SyncItemDataPacket;
import xzeroair.trinkets.traits.abilities.base.ItemAbilityProvider;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IHeldAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableInventoryAbility;
import xzeroair.trinkets.util.handlers.Counter;

public class TrinketProperties
extends CapabilityBase<TrinketProperties, ItemStack> {
    protected int variant = 0;
    protected int exp = 0;
    protected float mana = 0.0f;
    protected boolean mainAbility = false;
    protected boolean altAbility = false;
    protected TrinketHelper.SlotInformation slotInfo;
    protected boolean sync;
    protected String crafter = "";
    protected String crafterUUID = "";
    protected ElementalAttributes elements = new ElementalAttributes();

    public TrinketProperties(ItemStack stack) {
        super(stack);
        this.slotInfo = new TrinketHelper.SlotInformation(stack, TrinketHelper.SlotInformation.ItemHandlerType.NONE.getName(), -1);
    }

    public ElementalAttributes getElementAttributes() {
        return this.elements;
    }

    @Override
    public NBTTagCompound getTag() {
        if (((ItemStack)this.object).func_77978_p() == null) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.saveToNBT(itemTag);
            ((ItemStack)this.object).func_77982_d(itemTag);
        }
        return ((ItemStack)this.object).func_77978_p();
    }

    public TrinketHelper.SlotInformation getSlotInfo() {
        return this.slotInfo;
    }

    public void itemRightClicked() {
    }

    public void itemLeftClicked() {
    }

    public void itemUsed() {
    }

    public void onCrafted(ItemStack stack, World world, EntityPlayer player) {
        if (player == null) {
            return;
        }
        try {
            if (player.func_110124_au() != null) {
                this.setCrafterUUID(player.func_110124_au().toString());
            }
            this.setCrafter(player.getDisplayNameString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCrafter() {
        return this.crafter;
    }

    public String getCrafterUUID() {
        return this.crafterUUID;
    }

    public void setCrafter(String crafter) {
        if (!crafter.isEmpty() && !this.crafter.contentEquals(crafter)) {
            this.crafter = crafter;
            this.saveToNBT(this.getTag());
        }
    }

    public void setCrafterUUID(String crafterUUID) {
        if (!crafterUUID.isEmpty() && !this.crafterUUID.contentEquals(crafterUUID)) {
            this.crafterUUID = crafterUUID;
            this.saveToNBT(this.getTag());
        }
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityLivingBase) {
            boolean selected;
            boolean onHotBar = !isSelected && entity instanceof EntityPlayer && InventoryPlayer.func_184435_e((int)itemSlot);
            boolean moved = this.slotInfo.getSlot() != itemSlot;
            boolean notSelected = this.slotInfo.getHandlerType().equals((Object)TrinketHelper.SlotInformation.ItemHandlerType.MAINHAND) && !isSelected;
            boolean bl = selected = !this.slotInfo.getHandlerType().equals((Object)TrinketHelper.SlotInformation.ItemHandlerType.MAINHAND) && isSelected;
            if (moved || notSelected || selected) {
                TrinketHelper.SlotInformation.ItemHandlerType type = TrinketHelper.SlotInformation.ItemHandlerType.INVENTORY;
                if (onHotBar && !isSelected) {
                    type = TrinketHelper.SlotInformation.ItemHandlerType.HOTBAR;
                }
                if (itemSlot <= 3) {
                    TrinketHelper.SlotInformation hands = TrinketHelper.getSlotInfoForItemFromHeldEquipment((EntityLivingBase)entity, s -> this.compareStacks((ItemStack)s, stack, false));
                    if (hands != null) {
                        type = hands.getHandlerType();
                    } else {
                        TrinketHelper.SlotInformation armor = TrinketHelper.getSlotInfoForItemFromEquipment((EntityLivingBase)entity, s -> this.compareStacks((ItemStack)s, stack, false));
                        if (armor != null) {
                            type = armor.getHandlerType();
                        }
                    }
                }
                this.slotInfo.setHandler(type);
                this.slotInfo.setSlot(itemSlot);
            }
            if (stack.func_77973_b() instanceof ItemAbilityProvider) {
                TrinketHelper.SlotInformation.ItemHandlerType cacheType = this.slotInfo.getHandlerType();
                ArrayList<IAbilityInterface> abilities = new ArrayList<IAbilityInterface>();
                ItemAbilityProvider provider = (ItemAbilityProvider)stack.func_77973_b();
                provider.initAbilities(stack, (EntityLivingBase)entity, abilities);
                if (!abilities.isEmpty()) {
                    ArrayList<IAbilityInterface> abilitiesToAdd = new ArrayList<IAbilityInterface>();
                    for (IAbilityInterface attachedAbility : abilities) {
                        if ((cacheType == TrinketHelper.SlotInformation.ItemHandlerType.INVENTORY || cacheType == TrinketHelper.SlotInformation.ItemHandlerType.HOTBAR) && attachedAbility instanceof ITickableInventoryAbility) {
                            abilitiesToAdd.add(attachedAbility);
                        }
                        if (cacheType != TrinketHelper.SlotInformation.ItemHandlerType.MAINHAND && cacheType != TrinketHelper.SlotInformation.ItemHandlerType.OFFHAND || !(attachedAbility instanceof IHeldAbility)) continue;
                        abilitiesToAdd.add(attachedAbility);
                    }
                    if (!abilitiesToAdd.isEmpty()) {
                        Capabilities.getEntityProperties(entity, prop -> prop.getAbilityHandler().registerAbilities(stack.func_77973_b().getRegistryName().toString(), new TrinketHelper.SlotInformation(stack, cacheType, itemSlot), abilitiesToAdd));
                    }
                }
            }
            if (!this.tickHandler.getCounters().isEmpty()) {
                for (Map.Entry<String, Counter> counter : this.tickHandler.getCounters().entrySet()) {
                    counter.getValue().Tick();
                }
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
    }

    public void onEntityTick(ItemStack stack, EntityLivingBase entity) {
        ItemStack logicCheck = this.slotInfo.getStackFromHandler(entity);
        if (!this.compareStacks(stack, logicCheck, true)) {
            TrinketHelper.SlotInformation info = TrinketHelper.getSlotInfoForItemFromAccessory(entity, s -> this.compareStacks((ItemStack)s, stack, false));
            if (info == null && (info = TrinketHelper.getSlotInfoForItemFromEquipment(entity, s -> this.compareStacks((ItemStack)s, stack, false))) == null) {
                info = TrinketHelper.getSlotInfoForItemFromHeldEquipment(entity, s -> this.compareStacks((ItemStack)s, stack, false));
            }
            if (info != null) {
                TrinketHelper.SlotInformation.ItemHandlerType handler = info.getHandlerType();
                int slot = info.getSlot();
                this.slotInfo.setHandler(handler);
                this.slotInfo.setSlot(slot);
            }
        }
        if (stack.func_77973_b() instanceof ItemAbilityProvider) {
            ArrayList<IAbilityInterface> abilities = new ArrayList<IAbilityInterface>();
            ItemAbilityProvider provider = (ItemAbilityProvider)stack.func_77973_b();
            provider.initAbilities(stack, entity, abilities);
            if (!abilities.isEmpty()) {
                Capabilities.getEntityProperties((Entity)entity, prop -> prop.getAbilityHandler().registerAbilities(stack.func_77973_b().getRegistryName().toString(), new TrinketHelper.SlotInformation(stack, this.slotInfo.getHandlerType(), this.slotInfo.getSlot()), abilities));
                abilities.clear();
            }
        }
        if (this.sync) {
            this.sendInformationToTracking(entity);
            this.sync = false;
        }
    }

    private boolean compareStacks(ItemStack first, ItemStack second, boolean ignoreDurability) {
        String secondItemID;
        if (first == null || second == null) {
            return false;
        }
        if (first.func_190926_b() && !second.func_190926_b() || !first.func_190926_b() && second.func_190926_b()) {
            return false;
        }
        Item firstItem = first.func_77973_b();
        Item secondItem = second.func_77973_b();
        String firstItemID = firstItem.getRegistryName().toString();
        if (!firstItemID.contentEquals(secondItemID = secondItem.getRegistryName().toString())) {
            return false;
        }
        if (first.func_77969_a(second)) {
            return true;
        }
        return first.func_185136_b(second) && ignoreDurability;
    }

    public void itemEquipped(ItemStack stack, EntityLivingBase entity) {
        TrinketHelper.SlotInformation info;
        boolean isClient = entity.field_70170_p.field_72995_K;
        if (!isClient && (info = TrinketHelper.getSlotInfoForItemFromAccessory(entity, s -> s.func_77969_a(stack))) != null) {
            int slot = info.getSlot();
            int handler = info.getHandlerType().getId();
            this.slotInfo.setHandler(info.getHandlerType());
            this.slotInfo.setSlot(slot);
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            if (entity instanceof EntityPlayer) {
                NetworkHandler.sendTo(new SyncItemDataPacket(entity, (ItemStack)this.object, tag, slot, handler, handler == TrinketHelper.SlotInformation.ItemHandlerType.BAUBLES.getId(), false), (EntityPlayerMP)entity);
            }
        }
    }

    public void itemUnequipped(ItemStack stack, EntityLivingBase entity) {
        boolean isClient = entity.field_70170_p.field_72995_K;
        if (!isClient) {
            int slot = this.slotInfo.getSlot();
            int handler = this.slotInfo.getHandlerType().getId();
            this.slotInfo.setHandler(TrinketHelper.SlotInformation.ItemHandlerType.NONE);
            this.slotInfo.setSlot(-1);
            this.turnOff();
            this.tickHandler.clearCounters();
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            if (entity instanceof EntityPlayer) {
                NetworkHandler.sendTo(new SyncItemDataPacket(entity, (ItemStack)this.object, tag, slot, handler, handler == TrinketHelper.SlotInformation.ItemHandlerType.BAUBLES.getId(), false), (EntityPlayerMP)entity);
            }
        }
    }

    public void turnOff() {
        this.toggleMainAbility(false);
        this.toggleAltAbility(false);
    }

    public boolean isEquipped() {
        return (this.slotInfo.getHandlerType().equals((Object)TrinketHelper.SlotInformation.ItemHandlerType.TRINKETS) || this.slotInfo.getHandlerType().equals((Object)TrinketHelper.SlotInformation.ItemHandlerType.BAUBLES)) && this.slotInfo.getSlot() > -1;
    }

    public void sendInformationToPlayer(EntityLivingBase e, EntityLivingBase receiver) {
        if (!e.func_130014_f_().field_72995_K && receiver instanceof EntityPlayer) {
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            NetworkHandler.sendTo(new SyncItemDataPacket(e, (ItemStack)this.object, tag, this.slotInfo.getSlot(), this.slotInfo.getHandlerType().getId()), (EntityPlayerMP)receiver);
        }
    }

    public void sendInformationToServer(EntityLivingBase e) {
        if (e.func_130014_f_().field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            NetworkHandler.sendToServer(new SyncItemDataPacket(e, (ItemStack)this.object, tag, this.slotInfo.getSlot(), this.slotInfo.getHandlerType().getId()));
        }
    }

    public void sendInformationToTracking(EntityLivingBase e) {
        World world = e.func_130014_f_();
        if (!world.field_72995_K && world instanceof WorldServer) {
            WorldServer w = (WorldServer)world;
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            int slot = this.slotInfo.getSlot();
            int handler = this.slotInfo.getHandlerType().getId();
            SyncItemDataPacket packet = new SyncItemDataPacket(e, (ItemStack)this.object, tag, slot, handler, handler == TrinketHelper.SlotInformation.ItemHandlerType.BAUBLES.getId(), this.isEquipped());
            NetworkHandler.sendToTracking(packet, (Entity)e);
        }
    }

    public void scheduleResync() {
        this.sync = true;
    }

    public boolean mainAbility() {
        return this.mainAbility;
    }

    public void toggleMainAbility(boolean bool) {
        if (this.mainAbility != bool) {
            this.mainAbility = bool;
            this.saveToNBT(this.getTag());
        }
    }

    public boolean altAbility() {
        return this.altAbility;
    }

    public void toggleAltAbility(boolean bool) {
        if (this.altAbility != bool) {
            this.altAbility = bool;
            this.saveToNBT(this.getTag());
        }
    }

    public int StoredExp() {
        return this.exp;
    }

    public void setStoredExp(int integer) {
        if (this.exp != integer) {
            this.exp = integer;
            this.saveToNBT(this.getTag());
        }
    }

    public int getSlot() {
        return this.slotInfo.getSlot();
    }

    public float StoredMana() {
        return this.mana;
    }

    public void setStoredMana(float mana) {
        if (this.mana != mana) {
            this.mana = mana;
            this.saveToNBT(this.getTag());
        }
    }

    public final int getVariant() {
        return this.variant;
    }

    public final void setVariant(int variant) {
        if (this.variant != variant) {
            this.variant = variant;
            this.saveToNBT(this.getTag());
        }
    }

    @Override
    public NBTTagCompound saveToNBT(NBTTagCompound compound) {
        String capTag = "xat:Trinket";
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("variant", this.variant);
        tag.func_74768_a("slot", this.slotInfo.getSlot());
        tag.func_74778_a("handler", this.slotInfo.getHandler());
        tag.func_74768_a("exp", this.exp);
        tag.func_74776_a("mana", this.mana);
        tag.func_74757_a("main.ability", this.mainAbility);
        tag.func_74757_a("alt.ability", this.altAbility);
        tag.func_74778_a("crafter.name", this.crafter);
        tag.func_74778_a("crafter.uuid", this.crafterUUID);
        try {
            this.tickHandler.saveCountersToNBT(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.elements.saveToNBT(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        compound.func_74782_a("xat:Trinket", (NBTBase)tag);
        return compound;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        String capTag = "xat:Trinket";
        if (compound.func_74764_b("xat:Trinket")) {
            NBTTagCompound tag = compound.func_74775_l("xat:Trinket");
            if (tag.func_74764_b("variant")) {
                this.variant = tag.func_74762_e("variant");
            }
            if (tag.func_74764_b("slot")) {
                this.slotInfo.setSlot(tag.func_74762_e("slot"));
            }
            if (tag.func_74764_b("handler")) {
                this.slotInfo.setHandler(tag.func_74779_i("handler"));
            }
            if (tag.func_74764_b("exp")) {
                this.exp = tag.func_74762_e("exp");
            }
            if (tag.func_74764_b("mana")) {
                this.mana = tag.func_74760_g("mana");
            }
            if (tag.func_74764_b("main.ability")) {
                this.mainAbility = tag.func_74767_n("main.ability");
            }
            if (tag.func_74764_b("alt.ability")) {
                this.altAbility = tag.func_74767_n("alt.ability");
            }
            if (tag.func_74764_b("crafter.name")) {
                this.crafter = tag.func_74779_i("crafter.name");
            }
            if (tag.func_74764_b("crafter.uuid")) {
                this.crafterUUID = tag.func_74779_i("crafter.uuid");
            }
            try {
                this.tickHandler.loadCountersFromNBT(tag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.elements.loadFromNBT(tag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

