/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.Collection;
import java.util.Set;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.search.IBuildable;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.ISearchable;
import mezz.jei.search.PrefixInfo;
import net.minecraft.util.NonNullList;

public class PrefixedSearchable
implements ISearchable<IIngredientListElement<?>>,
IBuildable {
    protected final ISearchStorage<IIngredientListElement<?>> searchStorage;
    protected final PrefixInfo prefixInfo;

    public PrefixedSearchable(ISearchStorage<IIngredientListElement<?>> searchStorage, PrefixInfo prefixInfo) {
        this.searchStorage = searchStorage;
        this.prefixInfo = prefixInfo;
    }

    public ISearchStorage<IIngredientListElement<?>> getSearchStorage() {
        return this.searchStorage;
    }

    public Collection<String> getStrings(IIngredientListElement<?> element) {
        return this.prefixInfo.getStrings(element);
    }

    @Override
    public Config.SearchMode getMode() {
        return this.prefixInfo.getMode();
    }

    @Override
    public void submit(IIngredientListElement<?> ingredient) {
        if (this.prefixInfo.getMode() == Config.SearchMode.DISABLED) {
            return;
        }
        Collection<String> strings = this.prefixInfo.getStrings(ingredient);
        for (String string : strings) {
            this.searchStorage.put(string, ingredient);
        }
    }

    @Override
    public void submitAll(NonNullList<IIngredientListElement> ingredients) {
    }

    @Override
    public void getSearchResults(String token, Set<IIngredientListElement<?>> results) {
        this.searchStorage.getSearchResults(token, results);
    }

    @Override
    public void getAllElements(Set<IIngredientListElement<?>> results) {
        this.searchStorage.getAllElements(results);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

