/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.config.client;

import net.minecraftforge.common.config.Config;

public class ClientConfig {
    @Config.Name(value="1. Enable Tooltips")
    @Config.LangKey(value="setbonus.config.enableTooltips")
    @Config.Comment(value={"Whether or not to show set bonus information in discovered set item tooltips"})
    public boolean enableTooltips = true;
    @Config.Name(value="1a. Item Tooltip Blacklist")
    @Config.LangKey(value="setbonus.config.itemTooltipBlacklist")
    @Config.Comment(value={"These items will not display Set Bonus tooltips", "", "Each of the domain, name, and meta can be regex: .*:.*:.* will match all items, .* will match all vanilla items with 0 meta", "", "Of course, you can also still use normal syntax, eg. minecraft:elytra", " "})
    public String[] itemTooltipBlacklist = new String[0];
    @Config.Name(value="2. Dynamic Tooltip Searching (JEI/HEI)")
    @Config.LangKey(value="setbonus.config.dynamicTooltipSearch")
    @Config.Comment(value={"FILLSCREEN When to reload the tooltip cache for JEI/HEI", "", "0 - Never", "This is the default JEI / HEI behavior; searchable parts of tooltips generally won't update, so if you discover a new bonus, you might not be able to search for it until restart", "No performance impact", "", "1 - On new bonus discovery", "This will reload the tooltip cache when you discover a new bonus.  You should get accurate results when searching bonus names", "Potential performance impact, but only when discovering new bonuses", "", "2 - On set item equip / unequip", "This will reload the tooltip cache when you equip or unequip a set item.  You should get accurate results when searching bonus names or bonus requirements", "Highest potential performance impact, NOT RECOMMENDED!", " "})
    @Config.RangeInt(min=0, max=2)
    public int dynamicTooltipSearch = 1;
    @Config.Name(value="3. Enable Attribute Modifier Tooltips")
    @Config.LangKey(value="setbonus.config.enableAttributeModifierTooltips")
    @Config.Comment(value={"Whether or not to show attribute modifier information in discovered set item tooltips"})
    public boolean enableAttributeModifierTooltips = true;
    @Config.Name(value="4. Enable Potion Effect Tooltips")
    @Config.LangKey(value="setbonus.config.enablePotionEffectTooltips")
    @Config.Comment(value={"Whether or not to show potion effect information in discovered set item tooltips"})
    public boolean enablePotionEffectTooltips = true;
    @Config.Name(value="5. Enable Enchantment Tooltips")
    @Config.LangKey(value="setbonus.config.enableEnchantmentTooltips")
    @Config.Comment(value={"Whether or not to show enchantment information in discovered set item tooltips"})
    public boolean enableEnchantmentTooltips = true;
}

