/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonusrequirements.setrequirement;

import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SlotData;
import com.fantasticsource.tools.datastructures.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;

public class Set {
    public String id;
    public String name;
    public ArrayList<SlotData> slotData = new ArrayList();
    protected LinkedHashMap<EntityPlayer, Pair<Integer, Long>> numEquipped = new LinkedHashMap();
    protected ArrayList<Integer> blocked = new ArrayList();

    private Set() {
    }

    public static Set getInstance(String parsableSet, SetBonusData data) {
        Set result = new Set();
        String[] tokens = parsableSet.split(",");
        if (tokens.length < 3) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughSetArgs", (Object[])new Object[]{parsableSet}));
            return null;
        }
        result.id = tokens[0].trim();
        if (result.id.equals("")) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.noSetID", (Object[])new Object[]{parsableSet}));
            return null;
        }
        result.name = tokens[1].trim();
        for (String string : Arrays.copyOfRange(tokens, 2, tokens.length)) {
            SlotData slotData = SlotData.getInstance(string, data);
            if (slotData == null) {
                return null;
            }
            result.slotData.add(slotData);
        }
        if (result.slotData.size() == 0) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.noSetReqs", (Object[])new Object[]{parsableSet}));
            return null;
        }
        return result;
    }

    public int getNumberEquipped(EntityPlayer player) {
        long tick = player.field_70170_p.func_82737_E();
        Pair pair = this.numEquipped.computeIfAbsent(player, k -> new Pair((Object)0, (Object)(tick - 1L)));
        if ((Long)pair.getValue() != tick) {
            int result = this.getNumberEquippedInternal(player);
            pair.set((Object)result, (Object)tick);
            return result;
        }
        return (Integer)pair.getKey();
    }

    private int getNumberEquippedInternal(EntityPlayer player) {
        int result = 0;
        this.blocked.clear();
        for (SlotData data : this.slotData) {
            int slot = data.equipped(player, this.blocked, true, true);
            if (slot == Integer.MIN_VALUE) continue;
            this.blocked.add(slot);
            ++result;
        }
        return result;
    }

    public int getMaxNumber() {
        return this.slotData.size();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        return ((Set)obj).id.equals(this.id);
    }

    public Set clone(SetBonusData data) {
        Set other = new Set();
        other.id = this.id;
        other.name = this.name;
        for (SlotData slotData : this.slotData) {
            other.slotData.add(slotData.clone(data));
        }
        return other;
    }

    public String toString() {
        String result = this.id + ", " + this.name;
        for (SlotData slotData : this.slotData) {
            result = result + ", " + slotData;
        }
        return result;
    }
}

