/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonuselements;

import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.mctools.component.CFantasticPotionEffect;
import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import com.fantasticsource.mctools.potions.Potions;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.client.ClientBonus;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.Network;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BonusElementPotionEffect
extends ABonusElement {
    public ArrayList<FantasticPotionEffect> potions;

    public BonusElementPotionEffect() {
        this.potions = new ArrayList();
    }

    protected BonusElementPotionEffect(Bonus bonus, ArrayList<FantasticPotionEffect> potions) {
        super(bonus);
        this.potions = potions;
    }

    public static BonusElementPotionEffect getInstance(String parsablePotionBonus, SetBonusData data) {
        String[] tokens = parsablePotionBonus.split(",");
        if (tokens.length < 2) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughPotionBonusArgs", (Object[])new Object[]{parsablePotionBonus}));
            return null;
        }
        String id = tokens[0].trim();
        Bonus bonus = null;
        for (Bonus bonus2 : data.bonuses) {
            if (!bonus2.id.equals(id)) continue;
            bonus = bonus2;
            break;
        }
        if (bonus == null) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.potionBonusIDNotFound", (Object[])new Object[]{tokens[0].trim(), parsablePotionBonus}));
            return null;
        }
        ArrayList potions = Potions.parsePotions((String[])Arrays.copyOfRange(tokens, 1, tokens.length), (boolean)true);
        if (potions.size() == 0) {
            return null;
        }
        return new BonusElementPotionEffect(bonus, potions);
    }

    @Override
    public void activate(EntityPlayer player) {
        long tick = ServerTickTimer.currentTick();
        for (FantasticPotionEffect potion : this.potions) {
            PotionEffect active;
            if (potion.interval != 0 && tick % (long)potion.interval != 0L) continue;
            player.func_70690_d((PotionEffect)new FantasticPotionEffect((PotionEffect)potion));
            if (potion.func_76459_b() < Short.MAX_VALUE || (active = player.func_70660_b(potion.func_188419_a())) == null || active.func_76458_c() > potion.func_76458_c()) continue;
            Network.WRAPPER.sendTo((IMessage)new Network.PotionFixPacket(potion.func_188419_a()), (EntityPlayerMP)player);
        }
    }

    @Override
    public void deactivate(EntityPlayer player) {
        for (FantasticPotionEffect potion : this.potions) {
            PotionEffect active = player.func_70660_b(potion.func_188419_a());
            if (active == null || active.func_76458_c() != potion.func_76458_c() || active.func_76459_b() > potion.func_76459_b()) continue;
            player.func_184589_d(potion.func_188419_a());
        }
    }

    @Override
    public void updateActive(EntityPlayer player) {
        long tick = ServerTickTimer.currentTick();
        for (FantasticPotionEffect potion : this.potions) {
            PotionEffect active;
            if (potion.interval == 0 || tick % (long)potion.interval == 0L) {
                boolean needFix = player.func_70660_b(potion.func_188419_a()) != null;
                player.func_70690_d(new PotionEffect((PotionEffect)potion));
                if (needFix) {
                    Network.WRAPPER.sendTo((IMessage)new Network.PotionFixPacket(potion.func_188419_a()), (EntityPlayerMP)player);
                }
            }
            if (!(this.bonus instanceof ClientBonus) || (active = player.func_70660_b(potion.func_188419_a())) == null || active.func_76459_b() >= Short.MAX_VALUE) continue;
            active.func_100012_b(false);
        }
    }

    @Override
    public String[] tooltips() {
        String[] result = new String[this.potions.size()];
        int i = 0;
        for (FantasticPotionEffect potion : this.potions) {
            result[i++] = (potion.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.GREEN) + potion.toString(false);
        }
        return result;
    }

    public BonusElementPotionEffect clone() {
        BonusElementPotionEffect other = new BonusElementPotionEffect();
        CFantasticPotionEffect fantasticPotionEffect = new CFantasticPotionEffect();
        for (FantasticPotionEffect potionEffect : this.potions) {
            other.potions.add(((CFantasticPotionEffect)fantasticPotionEffect.set((FantasticPotionEffect)potionEffect).copy()).value);
        }
        return other;
    }

    @Override
    public BonusElementPotionEffect clone(SetBonusData data) {
        return BonusElementPotionEffect.getInstance(this.toString(), data);
    }

    @Override
    public String toString() {
        String result = this.bonus.id;
        for (FantasticPotionEffect potionEffect : this.potions) {
            result = result + ", " + potionEffect.func_188419_a().getRegistryName();
            int amp = potionEffect.func_76458_c();
            int duration = potionEffect.func_76459_b();
            int interval = potionEffect.interval;
            int argCount = 3;
            if (interval == 0) {
                --argCount;
                if (duration == Integer.MAX_VALUE) {
                    --argCount;
                    if (amp == 0) {
                        --argCount;
                    }
                }
            }
            if (argCount == 3) {
                result = result + "." + amp + "." + duration + "." + interval;
                continue;
            }
            if (argCount == 2) {
                result = result + "." + amp + "." + duration;
                continue;
            }
            if (argCount != 1) continue;
            result = result + "." + amp;
        }
        return result;
    }
}

