/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonuselements;

import com.fantasticsource.mctools.GlobalInventory;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.mctools.enchantments.Enchantments;
import com.fantasticsource.mctools.event.InventoryChangedEvent;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.client.ClientBonus;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Equip;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SlotData;
import com.fantasticsource.setbonus.server.ServerBonus;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class BonusElementEnchantment
extends ABonusElement {
    public SlotData slotDataToEnchant;
    public HashMap<Pair<Enchantment, Integer>, Integer> enchantments;
    public HashMap<EntityPlayer, ItemStack> affectedItemStacks = new HashMap();

    public BonusElementEnchantment() {
        this.slotDataToEnchant = SlotData.getEmpty();
        this.enchantments = new HashMap();
    }

    protected BonusElementEnchantment(Bonus bonus, SlotData slotDataToEnchant, HashMap<Pair<Enchantment, Integer>, Integer> enchantments) {
        super(bonus);
        this.slotDataToEnchant = slotDataToEnchant;
        this.enchantments = enchantments;
    }

    public static BonusElementEnchantment getInstance(String parsableEnchantmentBonus, SetBonusData data) {
        String[] tokens = parsableEnchantmentBonus.split(",");
        if (tokens.length < 3) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughEnchantmentBonusArgs", (Object[])new Object[]{parsableEnchantmentBonus}));
            return null;
        }
        String id = tokens[0].trim();
        Bonus bonus = null;
        for (Bonus bonus2 : data.bonuses) {
            if (!bonus2.id.equals(id)) continue;
            bonus = bonus2;
            break;
        }
        if (bonus == null) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.enchantmentBonusIDNotFound", (Object[])new Object[]{tokens[0].trim(), parsableEnchantmentBonus}));
            return null;
        }
        SlotData slotDataToEnchant = SlotData.getInstance(tokens[1].trim(), data);
        LinkedHashMap enchantments = Enchantments.parseEnchantments((String[])Arrays.copyOfRange(tokens, 2, tokens.length));
        if (enchantments.size() == 0) {
            return null;
        }
        return new BonusElementEnchantment(bonus, slotDataToEnchant, enchantments);
    }

    @Override
    public void activate(EntityPlayer player) {
        int equippedInSlot = this.slotDataToEnchant.equipped(player, null, false, false);
        if (equippedInSlot != Integer.MIN_VALUE) {
            this.addToStack(player, SlotData.getStackInSlot(player, equippedInSlot), equippedInSlot);
        }
    }

    @Override
    public void deactivate(EntityPlayer player) {
        ItemStack stack = this.affectedItemStacks.remove(player);
        if (stack != null) {
            this.removeFromStack(player, stack);
        }
    }

    @Override
    public void updateActive(EntityPlayer player) {
        ItemStack stack = this.affectedItemStacks.get(player);
        if (stack != null) {
            boolean found = false;
            block0: for (String slotName : this.slotDataToEnchant.slotNames) {
                for (int slot : SlotData.getSlotIDs(slotName)) {
                    if (SlotData.getStackInSlot(player, slot) != stack) continue;
                    found = true;
                    stack.func_77978_p().func_74768_a("SBSlot", slot);
                    continue block0;
                }
            }
            if (found) {
                return;
            }
            this.removeFromStack(player, stack);
        }
        this.activate(player);
    }

    public void addToStack(EntityPlayer player, ItemStack stack, int slot) {
        NBTTagCompound c;
        NBTTagList oldEnchants;
        NBTTagCompound ids;
        ItemStack old = this.affectedItemStacks.get(player);
        if (old == stack) {
            return;
        }
        if (old != null) {
            this.removeFromStack(player, old);
        }
        this.affectedItemStacks.put(player, stack);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        if (compound.func_74764_b("SBIDs")) {
            ids = compound.func_74775_l("SBIDs");
        } else {
            ids = new NBTTagCompound();
            compound.func_74782_a("SBIDs", (NBTBase)ids);
        }
        String bonusHash = "" + this.hashCode();
        if (ids.func_74764_b(bonusHash)) {
            return;
        }
        ids.func_74782_a(bonusHash, (NBTBase)new NBTTagInt(0));
        compound.func_186854_a("SBOwner", player.func_110124_au());
        compound.func_74768_a("SBSlot", slot);
        HashMap<Integer, Integer> data = new HashMap<Integer, Integer>();
        if (!compound.func_74764_b("OldEnchants")) {
            if (!compound.func_74764_b("ench")) {
                compound.func_74782_a("OldEnchants", (NBTBase)new NBTTagList());
            } else {
                oldEnchants = compound.func_150295_c("ench", 10);
                compound.func_74782_a("OldEnchants", (NBTBase)oldEnchants);
                for (NBTBase oldEnchant : oldEnchants) {
                    c = (NBTTagCompound)oldEnchant;
                    data.put(Integer.valueOf(c.func_74765_d("id")), Integer.valueOf(c.func_74765_d("lvl")));
                }
            }
        } else {
            oldEnchants = compound.func_150295_c("ench", 10);
            for (NBTBase oldEnchant : oldEnchants) {
                c = (NBTTagCompound)oldEnchant;
                data.put(Integer.valueOf(c.func_74765_d("id")), Integer.valueOf(c.func_74765_d("lvl")));
            }
        }
        for (Map.Entry<Pair<Enchantment, Integer>, Integer> entry : this.enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey().getKey();
            int id = Enchantment.func_185258_b((Enchantment)enchantment);
            int level = entry.getValue();
            int oldLevel = data.getOrDefault(id, 0);
            switch ((Integer)entry.getKey().getValue()) {
                case 0: {
                    if (level != oldLevel) {
                        level = Tools.max((int[])new int[]{level, oldLevel});
                    }
                    level = Tools.min((int[])new int[]{Tools.max((int[])new int[]{++level, 0}), enchantment.func_77325_b()});
                    break;
                }
                case 1: {
                    if (level == oldLevel) {
                        ++level;
                        break;
                    }
                    level = Tools.max((int[])new int[]{level, oldLevel});
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    level = Tools.min((int[])new int[]{Tools.max((int[])new int[]{level += oldLevel, 0}), enchantment.func_77325_b()});
                    break;
                }
                case 4: {
                    level += oldLevel;
                }
            }
            if (level == 0) {
                data.remove(id);
                continue;
            }
            data.put(id, level);
        }
        if (data.size() == 0) {
            compound.func_82580_o("ench");
        } else {
            NBTTagList enchants = new NBTTagList();
            for (Map.Entry entry : data.entrySet()) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74777_a("id", (short)((Integer)entry.getKey()).intValue());
                nbttagcompound.func_74777_a("lvl", (short)((Integer)entry.getValue()).intValue());
                enchants.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("ench", (NBTBase)enchants);
        }
    }

    public void removeFromStack(EntityPlayer player, ItemStack stack) {
        this.affectedItemStacks.remove(player, stack);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return;
        }
        if (compound.func_74764_b("OldEnchants")) {
            NBTTagList oldEnchants = compound.func_150295_c("OldEnchants", 10);
            if (oldEnchants.func_74745_c() == 0) {
                compound.func_82580_o("ench");
            } else {
                compound.func_74782_a("ench", compound.func_74781_a("OldEnchants"));
            }
        }
        boolean otherApplied = false;
        if (this.bonus instanceof ServerBonus) {
            for (Bonus bonus : SetBonusData.SERVER_DATA.bonuses) {
                ServerBonus.BonusInstance bonusInstance = ((ServerBonus)bonus).getBonusInstance((EntityPlayerMP)player);
                if (!bonusInstance.active) continue;
                for (ABonusElement bonusElement : bonus.bonusElements) {
                    if (!(bonusElement instanceof BonusElementEnchantment) || bonusElement == this) continue;
                    bonusElement.activate(player);
                    if (((BonusElementEnchantment)bonusElement).affectedItemStacks.get(player) != stack) continue;
                    otherApplied = true;
                }
            }
        } else {
            for (Bonus bonus : SetBonusData.CLIENT_DATA.bonuses) {
                ClientBonus.BonusInstance bonusInstance = ((ClientBonus)bonus).getBonusInstance(player);
                if (!bonusInstance.active) continue;
                for (ABonusElement bonusElement : bonus.bonusElements) {
                    if (!(bonusElement instanceof BonusElementEnchantment) || bonusElement == this) continue;
                    bonusElement.activate(player);
                    if (((BonusElementEnchantment)bonusElement).affectedItemStacks.get(player) != stack) continue;
                    otherApplied = true;
                }
            }
        }
        if (!otherApplied) {
            compound.func_82580_o("OldEnchants");
            compound.func_82580_o("SBOwnerMost");
            compound.func_82580_o("SBOwnerLeast");
            compound.func_82580_o("SBSlot");
            compound.func_82580_o("SBIDs");
            if (compound.func_186856_d() == 0) {
                stack.func_77982_d(null);
            }
        }
    }

    @SubscribeEvent
    public static void inventoryChanged(InventoryChangedEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        for (ItemStack stack : GlobalInventory.getAllNonSkinItems((Entity)player)) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null || !compound.func_74764_b("SBSlot") || stack.func_77969_a(SlotData.getStackInSlot(player, compound.func_74762_e("SBSlot")))) continue;
            if (compound.func_150295_c("OldEnchants", 10).func_74745_c() == 0) {
                compound.func_82580_o("ench");
            } else {
                compound.func_74782_a("ench", compound.func_74781_a("OldEnchants"));
            }
            compound.func_82580_o("OldEnchants");
            compound.func_82580_o("SBOwnerMost");
            compound.func_82580_o("SBOwnerLeast");
            compound.func_82580_o("SBSlot");
            compound.func_82580_o("SBIDs");
            if (compound.func_186856_d() != 0) continue;
            stack.func_77982_d(null);
        }
        MCTools.syncInventory((EntityPlayerMP)((EntityPlayerMP)player));
    }

    @SubscribeEvent
    public static void itemStackCreation(AttachCapabilitiesEvent<ItemStack> event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ServerTickTimer.schedule((int)1, () -> {
                ItemStack stack = (ItemStack)event.getObject();
                NBTTagCompound compound = stack.func_77978_p();
                if (compound != null) {
                    EntityPlayerMP player;
                    compound.func_82580_o("SBRandom");
                    if (compound.func_74764_b("SBSlot") && ((player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(compound.func_186857_a("SBOwner"))) == null || !stack.func_77969_a(SlotData.getStackInSlot((EntityPlayer)player, compound.func_74762_e("SBSlot"))))) {
                        if (compound.func_150295_c("OldEnchants", 10).func_74745_c() == 0) {
                            compound.func_82580_o("ench");
                        } else {
                            compound.func_74782_a("ench", compound.func_74781_a("OldEnchants"));
                        }
                        compound.func_82580_o("OldEnchants");
                        compound.func_82580_o("SBOwnerMost");
                        compound.func_82580_o("SBOwnerLeast");
                        compound.func_82580_o("SBSlot");
                        compound.func_82580_o("SBIDs");
                        if (compound.func_186856_d() == 0) {
                            stack.func_77982_d(null);
                        }
                        if (player != null) {
                            MCTools.syncInventory((EntityPlayerMP)player);
                        }
                    }
                }
            });
        }
    }

    @Override
    public String[] tooltips() {
        String[] result = new String[this.enchantments.size()];
        int i = 0;
        for (Map.Entry<Pair<Enchantment, Integer>, Integer> entry : this.enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey().getKey();
            int mode = (Integer)entry.getKey().getValue();
            int level = entry.getValue();
            result[i++] = (enchantment.func_190936_d() ? TextFormatting.RED : TextFormatting.GREEN) + "" + enchantment.func_77316_c(level) + " (" + I18n.func_74838_a((String)("setbonus.enchantmode." + mode)) + ")";
        }
        return result;
    }

    public BonusElementEnchantment clone() {
        BonusElementEnchantment other = new BonusElementEnchantment();
        other.slotDataToEnchant = SlotData.getEmpty();
        other.slotDataToEnchant.slotNames.addAll(this.slotDataToEnchant.slotNames);
        other.slotDataToEnchant.involvedEquips.addAll(this.slotDataToEnchant.involvedEquips);
        for (Map.Entry<Pair<Enchantment, Integer>, Integer> entry : this.enchantments.entrySet()) {
            other.enchantments.put((Pair<Enchantment, Integer>)new Pair(entry.getKey().getKey(), entry.getKey().getValue()), entry.getValue());
        }
        return other;
    }

    @Override
    public BonusElementEnchantment clone(SetBonusData data) {
        return BonusElementEnchantment.getInstance(this.toString(), data);
    }

    @Override
    public String toString() {
        String result = this.bonus.id + ", ";
        Iterator iterator = this.slotDataToEnchant.slotNames.iterator();
        result = result + (String)iterator.next();
        while (iterator.hasNext()) {
            result = result + " | " + (String)iterator.next();
        }
        result = result + " = ";
        Iterator iterator2 = this.slotDataToEnchant.involvedEquips.iterator();
        result = result + ((Equip)iterator2.next()).id;
        while (iterator2.hasNext()) {
            result = result + " | " + ((Equip)iterator2.next()).id;
        }
        for (Map.Entry<Pair<Enchantment, Integer>, Integer> entry : this.enchantments.entrySet()) {
            int level = entry.getValue();
            int mode = (Integer)entry.getKey().getValue();
            if (level != 1 && mode != 0) {
                result = result + ", " + ((Enchantment)entry.getKey().getKey()).getRegistryName() + "." + level + "." + mode;
                continue;
            }
            if (level != 1) {
                result = result + ", " + ((Enchantment)entry.getKey().getKey()).getRegistryName() + "." + level;
                continue;
            }
            result = result + ", " + ((Enchantment)entry.getKey().getKey()).getRegistryName();
        }
        return result;
    }

    static {
        InventoryChangedEvent.watchedClasses.add(EntityPlayer.class);
        MinecraftForge.EVENT_BUS.register(BonusElementEnchantment.class);
    }
}

