/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.screen.MessageGUI;
import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import com.fantasticsource.setbonus.Compat;
import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.client.gui.ServerConfigGUI;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementAttributeModifier;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementEnchantment;
import com.fantasticsource.setbonus.common.bonuselements.BonusElementPotionEffect;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Equip;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.Set;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SetRequirement;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SlotData;
import com.fantasticsource.setbonus.config.SetBonusConfig;
import com.fantasticsource.setbonus.server.ServerBonus;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Network {
    public static final SimpleNetworkWrapper WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("setbonus");
    private static int discriminator = 0;

    public static void init() {
        WRAPPER.registerMessage(AllDiscoveredBonusesPacketHandler.class, AllDiscoveredBonusesPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(DiscoverBonusPacketHandler.class, DiscoverBonusPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(HPFixPacketHandler.class, HPFixPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(PotionFixPacketHandler.class, PotionFixPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(RequestServerDataPacketHandler.class, RequestServerDataPacket.class, discriminator++, Side.SERVER);
        WRAPPER.registerMessage(ServerDataPacketHandler.class, ServerDataPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(ServerGUIMessagePacketHandler.class, ServerGUIMessagePacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(SetServerDataPacketHandler.class, SetServerDataPacket.class, discriminator++, Side.SERVER);
    }

    public static void updateConfig(EntityPlayerMP player) {
        ServerBonus.updateBonuses(player, true);
        ServerBonus.loadDiscoveries(player);
        WRAPPER.sendTo((IMessage)new AllDiscoveredBonusesPacket(player), player);
    }

    public static class SetServerDataPacketHandler
    implements IMessageHandler<SetServerDataPacket, IMessage> {
        public IMessage onMessage(SetServerDataPacket packet, MessageContext ctx) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (MCTools.isOP((EntityPlayerMP)player)) {
                    packet.data.applyToConfig();
                    WRAPPER.sendTo((IMessage)new ServerGUIMessagePacket("setbonus.requestAccepted", "setbonus.requestAccepted.applied"), player);
                } else {
                    WRAPPER.sendTo((IMessage)new ServerGUIMessagePacket("setbonus.requestDenied", "setbonus.requestDenied.needOP"), player);
                }
            });
            return null;
        }
    }

    public static class SetServerDataPacket
    implements IMessage {
        public SetBonusData data;

        public SetServerDataPacket() {
        }

        public SetServerDataPacket(SetBonusData data) {
            this.data = data.clone();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.data.equipment.size());
            for (Equip equip : this.data.equipment) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)equip.toString());
            }
            buf.writeInt(this.data.sets.size());
            for (Set set : this.data.sets) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)set.toString());
            }
            ArrayList<BonusElementAttributeModifier> attributeMods = new ArrayList<BonusElementAttributeModifier>();
            ArrayList<BonusElementPotionEffect> potions = new ArrayList<BonusElementPotionEffect>();
            ArrayList<BonusElementEnchantment> enchantments = new ArrayList<BonusElementEnchantment>();
            buf.writeInt(this.data.bonuses.size());
            for (Bonus bonus : this.data.bonuses) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bonus.toString());
                for (ABonusElement element : bonus.bonusElements) {
                    if (element instanceof BonusElementAttributeModifier) {
                        attributeMods.add((BonusElementAttributeModifier)element);
                    }
                    if (element instanceof BonusElementPotionEffect) {
                        potions.add((BonusElementPotionEffect)element);
                    }
                    if (!(element instanceof BonusElementEnchantment)) continue;
                    enchantments.add((BonusElementEnchantment)element);
                }
            }
            buf.writeInt(attributeMods.size());
            for (BonusElementAttributeModifier bonusElementAttributeModifier : attributeMods) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bonusElementAttributeModifier.toString());
            }
            buf.writeInt(potions.size());
            for (BonusElementPotionEffect bonusElementPotionEffect : potions) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bonusElementPotionEffect.toString());
            }
            buf.writeInt(enchantments.size());
            for (BonusElementEnchantment bonusElementEnchantment : enchantments) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bonusElementEnchantment.toString());
            }
        }

        public void fromBytes(ByteBuf buf) {
            int i;
            this.data = new SetBonusData();
            for (i = buf.readInt(); i > 0; --i) {
                this.data.equipment.add(Equip.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf)));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.data.sets.add(Set.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.data.bonuses.add(Bonus.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data));
            }
            for (i = buf.readInt(); i > 0; --i) {
                BonusElementAttributeModifier.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data);
            }
            for (i = buf.readInt(); i > 0; --i) {
                BonusElementPotionEffect.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data);
            }
            for (i = buf.readInt(); i > 0; --i) {
                BonusElementEnchantment.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data);
            }
        }
    }

    public static class ServerGUIMessagePacketHandler
    implements IMessageHandler<ServerGUIMessagePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ServerGUIMessagePacket packet, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof ServerConfigGUI) {
                    new MessageGUI(GUIScreen.reformat((String)packet.title), GUIScreen.reformat((String)packet.message));
                }
            });
            return null;
        }
    }

    public static class ServerGUIMessagePacket
    implements IMessage {
        String title;
        String message;

        public ServerGUIMessagePacket() {
        }

        public ServerGUIMessagePacket(String title, String message) {
            this.title = title;
            this.message = message;
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.title);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
        }

        public void fromBytes(ByteBuf buf) {
            this.title = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.message = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public static class ServerDataPacketHandler
    implements IMessageHandler<ServerDataPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ServerDataPacket packet, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (screen instanceof ServerConfigGUI) {
                    ServerConfigGUI gui = (ServerConfigGUI)screen;
                    gui.addPostClosedActions(new Runnable[]{() -> new ServerConfigGUI(packet.data)});
                    gui.close();
                }
            });
            return null;
        }
    }

    public static class ServerDataPacket
    implements IMessage {
        public SetBonusData data;

        public ServerDataPacket() {
        }

        public ServerDataPacket(SetBonusData data) {
            this.data = data.clone();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.data.equipment.size());
            for (Equip equip : this.data.equipment) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)equip.toString());
            }
            buf.writeInt(this.data.sets.size());
            for (Set set : this.data.sets) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)set.toString());
            }
            ArrayList<BonusElementAttributeModifier> attributeMods = new ArrayList<BonusElementAttributeModifier>();
            ArrayList<BonusElementPotionEffect> potions = new ArrayList<BonusElementPotionEffect>();
            ArrayList<BonusElementEnchantment> enchantments = new ArrayList<BonusElementEnchantment>();
            buf.writeInt(this.data.bonuses.size());
            for (Bonus bonus : this.data.bonuses) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bonus.toString());
                for (ABonusElement element : bonus.bonusElements) {
                    if (element instanceof BonusElementAttributeModifier) {
                        attributeMods.add((BonusElementAttributeModifier)element);
                    }
                    if (element instanceof BonusElementPotionEffect) {
                        potions.add((BonusElementPotionEffect)element);
                    }
                    if (!(element instanceof BonusElementEnchantment)) continue;
                    enchantments.add((BonusElementEnchantment)element);
                }
            }
            buf.writeInt(attributeMods.size());
            for (BonusElementAttributeModifier bonusElementAttributeModifier : attributeMods) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bonusElementAttributeModifier.toString());
            }
            buf.writeInt(potions.size());
            for (BonusElementPotionEffect bonusElementPotionEffect : potions) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bonusElementPotionEffect.toString());
            }
            buf.writeInt(enchantments.size());
            for (BonusElementEnchantment bonusElementEnchantment : enchantments) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bonusElementEnchantment.toString());
            }
        }

        public void fromBytes(ByteBuf buf) {
            int i;
            this.data = new SetBonusData();
            for (i = buf.readInt(); i > 0; --i) {
                this.data.equipment.add(Equip.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf)));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.data.sets.add(Set.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.data.bonuses.add(Bonus.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data));
            }
            for (i = buf.readInt(); i > 0; --i) {
                BonusElementAttributeModifier.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data);
            }
            for (i = buf.readInt(); i > 0; --i) {
                BonusElementPotionEffect.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data);
            }
            for (i = buf.readInt(); i > 0; --i) {
                BonusElementEnchantment.getInstance(ByteBufUtils.readUTF8String((ByteBuf)buf), this.data);
            }
        }
    }

    public static class RequestServerDataPacketHandler
    implements IMessageHandler<RequestServerDataPacket, IMessage> {
        public IMessage onMessage(RequestServerDataPacket packet, MessageContext ctx) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (MCTools.isOP((EntityPlayerMP)player)) {
                    WRAPPER.sendTo((IMessage)new ServerDataPacket(SetBonusData.SERVER_DATA), player);
                } else {
                    WRAPPER.sendTo((IMessage)new ServerGUIMessagePacket("setbonus.requestDenied", "setbonus.requestDenied.needOP"), player);
                }
            });
            return null;
        }
    }

    public static class RequestServerDataPacket
    implements IMessage {
        public void toBytes(ByteBuf buf) {
        }

        public void fromBytes(ByteBuf buf) {
        }
    }

    public static class PotionFixPacketHandler
    implements IMessageHandler<PotionFixPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PotionFixPacket packet, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                PotionEffect potionEffect = player.func_70660_b(packet.potion);
                if (potionEffect != null) {
                    player.func_184589_d(potionEffect.func_188419_a());
                    potionEffect = new FantasticPotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b(), potionEffect.func_76458_c(), potionEffect.func_82720_e(), potionEffect.func_188418_e());
                    potionEffect.func_100012_b(potionEffect.func_76459_b() >= Short.MAX_VALUE);
                    player.func_70690_d(potionEffect);
                }
            });
            return null;
        }
    }

    public static class PotionFixPacket
    implements IMessage {
        public Potion potion;

        public PotionFixPacket() {
        }

        public PotionFixPacket(Potion potion) {
            this.potion = potion;
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.potion.getRegistryName().toString());
        }

        public void fromBytes(ByteBuf buf) {
            this.potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        }
    }

    public static class HPFixPacketHandler
    implements IMessageHandler<HPFixPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(HPFixPacket packet, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().field_71439_g.func_70606_j(packet.hp));
            return null;
        }
    }

    public static class HPFixPacket
    implements IMessage {
        public float hp;

        public HPFixPacket() {
        }

        public HPFixPacket(EntityPlayerMP player) {
            this.hp = player.func_110143_aJ();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeFloat(this.hp);
        }

        public void fromBytes(ByteBuf buf) {
            this.hp = buf.readFloat();
        }
    }

    public static class AllDiscoveredBonusesPacketHandler
    implements IMessageHandler<AllDiscoveredBonusesPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(AllDiscoveredBonusesPacket packet, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> SetBonusData.setClientFromPacket(packet));
            return null;
        }
    }

    public static class AllDiscoveredBonusesPacket
    implements IMessage {
        public HashSet<String> equipment = new HashSet();
        public HashSet<String> sets = new HashSet();
        public HashSet<String> bonuses = new HashSet();
        public HashSet<String> attributeMods = new HashSet();
        public HashSet<String> potions = new HashSet();
        public HashSet<String> enchantments = new HashSet();
        private EntityPlayerMP player;

        public AllDiscoveredBonusesPacket() {
        }

        private AllDiscoveredBonusesPacket(EntityPlayerMP player) {
            this.player = player;
        }

        public void toBytes(ByteBuf buf) {
            for (Bonus bonus : SetBonusData.SERVER_DATA.bonuses) {
                if (bonus.discoveryMode != 1 && (bonus.discoveryMode != 0 || !((ServerBonus)bonus).getBonusInstance((EntityPlayerMP)this.player).discovered)) continue;
                this.bonuses.add(bonus.toString());
                for (ABonusRequirement bonusRequirement : bonus.requirements) {
                    if (!(bonusRequirement instanceof SetRequirement)) continue;
                    Set set = ((SetRequirement)bonusRequirement).set;
                    this.sets.add(set.toString());
                    for (SlotData slotData : set.slotData) {
                        for (Equip equip : slotData.involvedEquips) {
                            this.equipment.add(equip.toString());
                        }
                    }
                }
                for (ABonusElement element : bonus.bonusElements) {
                    if (element instanceof BonusElementAttributeModifier) {
                        this.attributeMods.add(element.toString());
                        continue;
                    }
                    if (element instanceof BonusElementPotionEffect) {
                        this.potions.add(element.toString());
                        continue;
                    }
                    if (!(element instanceof BonusElementEnchantment)) continue;
                    this.enchantments.add(element.toString());
                    for (Equip equip : ((BonusElementEnchantment)element).slotDataToEnchant.involvedEquips) {
                        this.equipment.add(equip.toString());
                    }
                }
            }
            buf.writeInt(this.equipment.size());
            for (String string : this.equipment) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.sets.size());
            for (String string : this.sets) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.bonuses.size());
            for (String string : this.bonuses) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.attributeMods.size());
            for (String string : this.attributeMods) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.potions.size());
            for (String string : this.potions) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.enchantments.size());
            for (String string : this.enchantments) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
        }

        public void fromBytes(ByteBuf buf) {
            int i;
            for (i = buf.readInt(); i > 0; --i) {
                this.equipment.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.sets.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.bonuses.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.attributeMods.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.potions.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.enchantments.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }
    }

    public static class DiscoverBonusPacketHandler
    implements IMessageHandler<DiscoverBonusPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(DiscoverBonusPacket packet, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                SetBonusData.CLIENT_DATA.addFromPacket(packet);
                if (SetBonusConfig.clientSettings.dynamicTooltipSearch > 0) {
                    Compat.refreshTooltips();
                }
            });
            return null;
        }
    }

    public static class DiscoverBonusPacket
    implements IMessage {
        public HashSet<String> equipment = new HashSet();
        public HashSet<String> sets = new HashSet();
        public String bonusString;
        public HashSet<String> attributeMods = new HashSet();
        public HashSet<String> potions = new HashSet();
        public HashSet<String> enchants = new HashSet();
        private ServerBonus bonus;

        public DiscoverBonusPacket() {
        }

        public DiscoverBonusPacket(ServerBonus bonus) {
            this.bonus = bonus;
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.bonus.toString());
            for (ABonusRequirement bonusRequirement : this.bonus.requirements) {
                if (!(bonusRequirement instanceof SetRequirement)) continue;
                Set set = ((SetRequirement)bonusRequirement).set;
                this.sets.add(set.toString());
                for (SlotData slotData : set.slotData) {
                    for (Equip equip : slotData.involvedEquips) {
                        this.equipment.add(equip.toString());
                    }
                }
            }
            for (ABonusElement element : this.bonus.bonusElements) {
                if (element instanceof BonusElementAttributeModifier) {
                    this.attributeMods.add(element.toString());
                    continue;
                }
                if (element instanceof BonusElementPotionEffect) {
                    this.potions.add(element.toString());
                    continue;
                }
                if (!(element instanceof BonusElementEnchantment)) continue;
                this.enchants.add(element.toString());
                for (Equip equip : ((BonusElementEnchantment)element).slotDataToEnchant.involvedEquips) {
                    this.equipment.add(equip.toString());
                }
            }
            buf.writeInt(this.equipment.size());
            for (String string : this.equipment) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.sets.size());
            for (String string : this.sets) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.attributeMods.size());
            for (String string : this.attributeMods) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.potions.size());
            for (String string : this.potions) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
            buf.writeInt(this.enchants.size());
            for (String string : this.enchants) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string);
            }
        }

        public void fromBytes(ByteBuf buf) {
            int i;
            this.bonusString = ByteBufUtils.readUTF8String((ByteBuf)buf);
            for (i = buf.readInt(); i > 0; --i) {
                this.equipment.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.sets.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.attributeMods.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.potions.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            for (i = buf.readInt(); i > 0; --i) {
                this.enchants.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }
    }
}

