/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common;

import com.fantasticsource.setbonus.SetBonusData;
import com.fantasticsource.setbonus.client.ClientBonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import com.fantasticsource.setbonus.server.ServerBonus;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.text.translation.I18n;

public class Bonus {
    public static final int MODE_DISCOVERABLE = 0;
    public static final int MODE_GLOBALLY_KNOWN = 1;
    public static final int MODE_GLOBALLY_HIDDEN = 2;
    public String id;
    public String name;
    public int discoveryMode;
    public ArrayList<ABonusRequirement> requirements = new ArrayList();
    public ArrayList<ABonusElement> bonusElements = new ArrayList();

    protected Bonus() {
    }

    public static Bonus getInstance(String parsableBonus, SetBonusData data) {
        ServerBonus bonus = data == SetBonusData.SERVER_DATA ? new ServerBonus() : (data == SetBonusData.CLIENT_DATA ? new ClientBonus() : new Bonus());
        String[] tokens = parsableBonus.split(",");
        if (tokens.length < 3) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughBonusArgs", (Object[])new Object[]{parsableBonus}));
            return null;
        }
        bonus.id = tokens[0].trim();
        if (bonus.id.equals("")) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.noBonusID", (Object[])new Object[]{parsableBonus}));
            return null;
        }
        bonus.name = tokens[1].trim();
        try {
            bonus.discoveryMode = Integer.parseInt(tokens[2].trim());
        }
        catch (NumberFormatException e) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.bonusDiscoveryMode", (Object[])new Object[]{parsableBonus}));
            return null;
        }
        if (bonus.discoveryMode < 0 || bonus.discoveryMode > 2) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.bonusDiscoveryMode", (Object[])new Object[]{parsableBonus}));
            return null;
        }
        for (String requirementString : Arrays.copyOfRange(tokens, 3, tokens.length)) {
            ABonusRequirement requirement = ABonusRequirement.parse(requirementString, data.sets);
            if (requirement == null) {
                System.err.println(I18n.func_74837_a((String)"setbonus.error.unknownBonusReq", (Object[])new Object[]{parsableBonus}));
                return null;
            }
            bonus.requirements.add(requirement);
        }
        return bonus;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Bonus)) {
            return false;
        }
        return ((Bonus)obj).id.equals(this.id);
    }

    public Bonus clone(SetBonusData data) {
        Bonus other = new Bonus();
        other.id = this.id;
        other.name = this.name;
        other.discoveryMode = this.discoveryMode;
        data.bonuses.add(other);
        for (ABonusRequirement requirement : this.requirements) {
            other.requirements.add(requirement.clone(data));
        }
        for (ABonusElement element : this.bonusElements) {
            element.clone(data);
        }
        return other;
    }

    public String toString() {
        String result = this.id + ", " + this.name + ", " + this.discoveryMode;
        for (ABonusRequirement requirement : this.requirements) {
            result = result + ", " + requirement;
        }
        return result;
    }
}

